
package org.owasp.dependencycheck.data.nvd.json;

import java.util.ArrayList;
import java.util.List;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

public class Version {

    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("version_data")
    @Expose
    private List<VersionDatum> versionData = new ArrayList<VersionDatum>();

    /**
     * 
     * (Required)
     * 
     */
    public List<VersionDatum> getVersionData() {
        return versionData;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setVersionData(List<VersionDatum> versionData) {
        this.versionData = versionData;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Version.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("versionData");
        sb.append('=');
        sb.append(((this.versionData == null)?"<null>":this.versionData));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.versionData == null)? 0 :this.versionData.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Version) == false) {
            return false;
        }
        Version rhs = ((Version) other);
        return ((this.versionData == rhs.versionData)||((this.versionData!= null)&&this.versionData.equals(rhs.versionData)));
    }

}
