/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.github.packageurl.MalformedPackageURLException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.boris.pecoff4j.PE;
import org.boris.pecoff4j.ResourceDirectory;
import org.boris.pecoff4j.ResourceEntry;
import org.boris.pecoff4j.io.PEParser;
import org.boris.pecoff4j.io.ResourceParser;
import org.boris.pecoff4j.resources.StringFileInfo;
import org.boris.pecoff4j.resources.StringTable;
import org.boris.pecoff4j.resources.VersionInfo;
import org.boris.pecoff4j.util.ResourceHelper;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.AssemblyAnalyzer;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.DependencyVersion;
import org.owasp.dependencycheck.utils.DependencyVersionUtil;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
@ThreadSafe
public class PEAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AssemblyAnalyzer.class);
    private static final String ANALYZER_NAME = "PE Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION2;
    private static final String[] EXTENSIONS = new String[]{"exe", "dll"};
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addExtensions(EXTENSIONS).build();
    public static final String DEPENDENCY_ECOSYSTEM = "native";

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.pe.enabled";
    }

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        for (Evidence e : dependency.getEvidence()) {
            if (!"grokassembly".equals(e.getSource())) continue;
            LOGGER.debug("Skipping {} because it was already analyzed by the Assembly Analyzer", (Object)dependency.getFileName());
            return;
        }
        try {
            ResourceEntry[] entries;
            File fileToCheck = dependency.getActualFile();
            PE pe = PEParser.parse((String)fileToCheck.getPath());
            ResourceDirectory rd = pe.getImageData().getResourceTable();
            for (ResourceEntry entrie : entries = ResourceHelper.findResources((ResourceDirectory)rd, (int)16)) {
                byte[] data = entrie.getData();
                VersionInfo version = ResourceParser.readVersionInfo((byte[])data);
                StringFileInfo strings = version.getStringFileInfo();
                StringTable table = strings.getTable(0);
                String pVersion = null;
                String fVersion = null;
                for (int j = 0; j < table.getCount(); ++j) {
                    DependencyVersion fileVersion;
                    String key = table.getString(j).getKey();
                    String value = table.getString(j).getValue();
                    switch (key) {
                        case "ProductVersion": {
                            dependency.addEvidence(EvidenceType.VERSION, "PE Header", "ProductVersion", value, Confidence.HIGHEST);
                            pVersion = value;
                            break;
                        }
                        case "CompanyName": {
                            dependency.addEvidence(EvidenceType.VENDOR, "PE Header", "CompanyName", value, Confidence.HIGHEST);
                            break;
                        }
                        case "FileVersion": {
                            dependency.addEvidence(EvidenceType.VERSION, "PE Header", "FileVersion", value, Confidence.HIGH);
                            fVersion = value;
                            break;
                        }
                        case "InternalName": {
                            dependency.addEvidence(EvidenceType.PRODUCT, "PE Header", "InternalName", value, Confidence.MEDIUM);
                            this.determineDependencyName(dependency, value);
                            break;
                        }
                        case "LegalCopyright": {
                            dependency.addEvidence(EvidenceType.VENDOR, "PE Header", "LegalCopyright", value, Confidence.HIGHEST);
                            if (dependency.getLicense() != null && dependency.getLicense().length() > 0) {
                                dependency.setLicense(dependency.getLicense() + "/n/nLegal Copyright: " + value);
                                break;
                            }
                            dependency.setLicense("Legal Copyright: " + value);
                            break;
                        }
                        case "OriginalFilename": {
                            dependency.addEvidence(EvidenceType.VERSION, "PE Header", "OriginalFilename", value, Confidence.MEDIUM);
                            this.determineDependencyName(dependency, value);
                            break;
                        }
                        case "ProductName": {
                            dependency.addEvidence(EvidenceType.PRODUCT, "PE Header", "ProductName", value, Confidence.HIGHEST);
                            this.determineDependencyName(dependency, value);
                            break;
                        }
                        default: {
                            LOGGER.debug("PE Analyzer found `" + key + "` with a value:" + value);
                        }
                    }
                    if (fVersion != null && pVersion != null) {
                        int pos;
                        int max = fVersion.length() > pVersion.length() ? pVersion.length() : fVersion.length();
                        for (pos = 0; pos < max && fVersion.charAt(pos) == pVersion.charAt(pos); ++pos) {
                        }
                        DependencyVersion fileVersion2 = DependencyVersionUtil.parseVersion(fVersion, true);
                        DependencyVersion productVersion = DependencyVersionUtil.parseVersion(pVersion, true);
                        if (pos > 0) {
                            DependencyVersion matchingVersion = DependencyVersionUtil.parseVersion(fVersion.substring(0, pos), true);
                            if (fileVersion2 != null && fileVersion2.toString().length() == fVersion.length() && matchingVersion != null && matchingVersion.getVersionParts().size() > 2) {
                                dependency.addEvidence(EvidenceType.VERSION, "PE Header", "FilteredVersion", matchingVersion.toString(), Confidence.HIGHEST);
                                dependency.setVersion(matchingVersion.toString());
                            }
                        }
                        if (dependency.getVersion() == null) {
                            if (fVersion.length() >= pVersion.length()) {
                                if (fileVersion2 != null && fileVersion2.toString().length() == fVersion.length()) {
                                    dependency.setVersion(fileVersion2.toString());
                                } else if (productVersion != null && productVersion.toString().length() == pVersion.length()) {
                                    dependency.setVersion(productVersion.toString());
                                }
                            } else if (productVersion != null && productVersion.toString().length() == pVersion.length()) {
                                dependency.setVersion(productVersion.toString());
                            } else if (fileVersion2 != null && fileVersion2.toString().length() == fVersion.length()) {
                                dependency.setVersion(fileVersion2.toString());
                            }
                        }
                    } else if (pVersion != null) {
                        DependencyVersion productVersion = DependencyVersionUtil.parseVersion(pVersion, true);
                        if (productVersion != null && dependency.getActualFile().getName().contains(productVersion.toString())) {
                            dependency.setVersion(productVersion.toString());
                        }
                    } else if (fVersion != null && (fileVersion = DependencyVersionUtil.parseVersion(fVersion, true)) != null && dependency.getActualFile().getName().contains(fileVersion.toString())) {
                        dependency.setVersion(fileVersion.toString());
                    }
                    if (dependency.getName() != null && dependency.getVersion() != null) {
                        try {
                            dependency.addSoftwareIdentifier(new PurlIdentifier("generic", dependency.getName(), dependency.getVersion(), Confidence.MEDIUM));
                        }
                        catch (MalformedPackageURLException ex) {
                            LOGGER.debug("Unable to create Package URL Identifier for " + dependency.getName(), (Throwable)ex);
                            dependency.addSoftwareIdentifier(new GenericIdentifier(String.format("%s@%s", dependency.getName(), dependency.getVersion()), Confidence.MEDIUM));
                        }
                    }
                    if (dependency.getEcosystem() != null) continue;
                    dependency.setEcosystem(DEPENDENCY_ECOSYSTEM);
                }
            }
        }
        catch (IOException ex) {
            throw new AnalysisException(ex);
        }
    }

    private void determineDependencyName(Dependency dependency, String value) {
        if (dependency.getName() == null && StringUtils.containsIgnoreCase((CharSequence)dependency.getActualFile().getName(), (CharSequence)value)) {
            String ext = FileUtils.getFileExtension((String)value);
            if (ext != null) {
                dependency.setName(value.substring(0, value.length() - ext.length() - 1));
            } else {
                dependency.setName(value);
            }
        }
    }
}

