/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractNpmAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.analyzer.exception.SearchException;
import org.owasp.dependencycheck.analyzer.exception.UnexpectedAnalysisException;
import org.owasp.dependencycheck.data.nodeaudit.Advisory;
import org.owasp.dependencycheck.data.nodeaudit.NodeAuditSearch;
import org.owasp.dependencycheck.data.nodeaudit.NpmPayloadBuilder;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Reference;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.owasp.dependencycheck.dependency.VulnerableSoftwareBuilder;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.URLConnectionFailureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.exceptions.CpeValidationException;
import us.springett.parsers.cpe.values.Part;

@ThreadSafe
public class NodeAuditAnalyzer
extends AbstractNpmAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeAuditAnalyzer.class);
    public static final String DEFAULT_URL = "https://registry.npmjs.org/-/npm/v1/security/audits";
    public static final String DEPENDENCY_ECOSYSTEM = "nodejs";
    public static final String PACKAGE_LOCK_JSON = "package-lock.json";
    public static final String SHRINKWRAP_JSON = "npm-shrinkwrap.json";
    private static final FileFilter PACKAGE_JSON_FILTER = FileFilterBuilder.newInstance().addFilenames("package-lock.json", "npm-shrinkwrap.json").build();
    private NodeAuditSearch searcher;

    @Override
    protected FileFilter getFileFilter() {
        return PACKAGE_JSON_FILTER;
    }

    @Override
    public void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
        if (!this.isEnabled() || !this.getFilesMatched()) {
            this.setEnabled(false);
            return;
        }
        if (this.searcher == null) {
            LOGGER.debug("Initializing {}", (Object)this.getName());
            try {
                this.searcher = new NodeAuditSearch(this.getSettings());
            }
            catch (MalformedURLException ex) {
                this.setEnabled(false);
                throw new InitializationException("The configured URL to NPM Audit API is malformed", ex);
            }
            try {
                Settings settings = engine.getSettings();
                boolean nodeEnabled = settings.getBoolean("analyzer.node.package.enabled");
                if (!nodeEnabled) {
                    LOGGER.warn("The Node Package Analyzer has been disabled; the resulting report will only contain the known vulnerable dependency - not a bill of materials for the node project.");
                }
            }
            catch (InvalidSettingException ex) {
                throw new InitializationException("Unable to read configuration settings", ex);
            }
        }
    }

    @Override
    public String getName() {
        return "Node Audit Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.FINDING_ANALYSIS;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.node.audit.enabled";
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        File packageLock;
        if (dependency.getDisplayFileName().equals(dependency.getFileName())) {
            engine.removeDependency(dependency);
        }
        if (!(packageLock = dependency.getActualFile()).isFile() || packageLock.length() == 0L || !this.shouldProcess(packageLock)) {
            return;
        }
        File packageJson = new File(packageLock.getParentFile(), "package.json");
        HashMap<String, String> dependencyMap = new HashMap<String, String>();
        List<Advisory> advisories = packageJson.isFile() ? this.analyzePackage(packageLock, packageJson, dependency, dependencyMap) : this.legacyAnalysis(packageLock, dependency, dependencyMap);
        try {
            this.processResults(advisories, engine, dependency, dependencyMap);
        }
        catch (CpeValidationException ex) {
            throw new UnexpectedAnalysisException(ex);
        }
    }

    private void processResults(List<Advisory> advisories, Engine engine, Dependency dependency, Map<String, String> dependencyMap) throws CpeValidationException {
        for (Advisory advisory : advisories) {
            Dependency existing;
            Vulnerability vuln = new Vulnerability();
            vuln.setDescription(advisory.getOverview());
            vuln.setName(String.valueOf(advisory.getId()));
            vuln.setUnscoredSeverity(advisory.getSeverity());
            vuln.setSource(Vulnerability.Source.NPM);
            vuln.addReference("Advisory " + advisory.getId() + ": " + advisory.getTitle(), advisory.getReferences(), null);
            VulnerableSoftwareBuilder builder = new VulnerableSoftwareBuilder();
            builder.part(Part.APPLICATION).product(advisory.getModuleName().replace(" ", "_")).version(advisory.getVulnerableVersions().replace(" ", ""));
            VulnerableSoftware vs = builder.build();
            vuln.setVulnerableSoftware(Collections.singleton(vs));
            String version = advisory.getVersion();
            if (version == null && dependencyMap.containsKey(advisory.getModuleName())) {
                version = dependencyMap.get(advisory.getModuleName());
            }
            if ((existing = this.findDependency(engine, advisory.getModuleName(), version)) == null) {
                Dependency nodeModule = this.createDependency(dependency, advisory.getModuleName(), version, "transitive");
                nodeModule.addVulnerability(vuln);
                engine.addDependency(nodeModule);
                continue;
            }
            this.replaceOrAddVulnerability(existing, vuln);
        }
    }

    private void replaceOrAddVulnerability(Dependency dependency, Vulnerability vuln) {
        boolean found = false;
        for (Vulnerability existing : dependency.getVulnerabilities()) {
            for (Reference ref : existing.getReferences()) {
                if (ref.getName() == null || !vuln.getSource().toString().equals("NPM") || !ref.getName().equals("https://nodesecurity.io/advisories/" + vuln.getName())) continue;
                found = true;
            }
        }
        if (!found) {
            dependency.addVulnerability(vuln);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<Advisory> analyzePackage(File lockFile, File packageFile, Dependency dependency, Map<String, String> dependencyMap) throws AnalysisException {
        try (JsonReader lockReader = Json.createReader((InputStream)FileUtils.openInputStream((File)lockFile));){
            List<Advisory> list;
            block18: {
                JsonReader packageReader = Json.createReader((InputStream)FileUtils.openInputStream((File)packageFile));
                try {
                    JsonObject lockJson = lockReader.readObject();
                    JsonObject packageJson = packageReader.readObject();
                    JsonObject payload = NpmPayloadBuilder.build(lockJson, packageJson, dependencyMap, this.getSettings().getBoolean("analyzer.node.audit.skipdev", false));
                    list = this.searcher.submitPackage(payload);
                    if (packageReader == null) break block18;
                }
                catch (Throwable lockJson) {
                    if (packageReader != null) {
                        try {
                            packageReader.close();
                        }
                        catch (Throwable throwable) {
                            lockJson.addSuppressed(throwable);
                        }
                    }
                    throw lockJson;
                }
                packageReader.close();
            }
            return list;
        }
        catch (URLConnectionFailureException e) {
            this.setEnabled(false);
            throw new AnalysisException("Failed to connect to the NPM Audit API (NodeAuditAnalyzer); the analyzer is being disabled and may result in false negatives.", e);
        }
        catch (IOException e) {
            LOGGER.debug("Error reading dependency or connecting to NPM Audit API", (Throwable)e);
            this.setEnabled(false);
            throw new AnalysisException("Failed to read results from the NPM Audit API (NodeAuditAnalyzer); the analyzer is being disabled and may result in false negatives.", e);
        }
        catch (JsonException e) {
            throw new AnalysisException(String.format("Failed to parse %s file from the NPM Audit API (NodeAuditAnalyzer).", lockFile.getPath()), e);
        }
        catch (SearchException ex) {
            File yarnCheck = new File(lockFile.getParentFile(), "yarn.lock");
            if (yarnCheck.exists()) {
                String msg = "NodeAuditAnalyzer filed on " + dependency.getActualFilePath() + " - yarn.lock was identified if generated using synp the lock file may not be in the correct format.";
                LOGGER.error(msg);
                throw new AnalysisException("msg", ex);
            }
            LOGGER.error("NodeAuditAnalyzer failed on {}", (Object)dependency.getActualFilePath());
            throw ex;
        }
    }

    private List<Advisory> legacyAnalysis(File file, Dependency dependency, Map<String, String> dependencyMap) throws AnalysisException {
        List<Advisory> list;
        block13: {
            JsonReader jsonReader = Json.createReader((InputStream)FileUtils.openInputStream((File)file));
            try {
                JsonObject packageJson = jsonReader.readObject();
                String projectName = packageJson.getString("name", "");
                String projectVersion = packageJson.getString("version", "");
                if (!projectName.isEmpty()) {
                    dependency.setName(projectName);
                }
                if (!projectVersion.isEmpty()) {
                    dependency.setVersion(projectVersion);
                }
                JsonObject payload = NpmPayloadBuilder.build(packageJson, dependencyMap);
                list = this.searcher.submitPackage(payload);
                if (jsonReader == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (URLConnectionFailureException e) {
                    this.setEnabled(false);
                    throw new AnalysisException("Failed to connect to the NPM Audit API (NodeAuditAnalyzer); the analyzer is being disabled and may result in false negatives.", e);
                }
                catch (IOException e) {
                    LOGGER.debug("Error reading dependency or connecting to NPM Audit API", (Throwable)e);
                    this.setEnabled(false);
                    throw new AnalysisException("Failed to read results from the NPM Audit API (NodeAuditAnalyzer); the analyzer is being disabled and may result in false negatives.", e);
                }
                catch (JsonException e) {
                    throw new AnalysisException(String.format("Failed to parse %s file from the NPM Audit API (NodeAuditAnalyzer).", file.getPath()), e);
                }
                catch (SearchException ex) {
                    LOGGER.error("NodeAuditAnalyzer failed on {}", (Object)dependency.getActualFilePath());
                    throw ex;
                }
            }
            jsonReader.close();
        }
        return list;
    }
}

