/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update.cpe;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import org.owasp.dependencycheck.data.update.nvd.NvdCveParser;
import org.owasp.dependencycheck.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CpeEcosystemCache {
    private static final String MULTIPLE_ECOSYSTEMS_IDENTIFIED = "MULTIPLE";
    private static Map<Pair<String, String>, String> cache = new HashMap<Pair<String, String>, String>();
    private static Map<Pair<String, String>, String> changed = new HashMap<Pair<String, String>, String>();
    private static final Logger LOGGER = LoggerFactory.getLogger(NvdCveParser.class);

    private CpeEcosystemCache() {
    }

    public static synchronized String getEcosystem(String vendor, String product, String identifiedEcosystem) {
        Pair<String, String> key = new Pair<String, String>(vendor, product);
        String current = cache.get(key);
        String result = null;
        if (current == null) {
            if (!Strings.isNullOrEmpty((String)identifiedEcosystem)) {
                cache.put(key, identifiedEcosystem);
                changed.put(key, identifiedEcosystem);
                result = identifiedEcosystem;
            }
        } else if (!MULTIPLE_ECOSYSTEMS_IDENTIFIED.equals(current)) {
            if (current.equals(identifiedEcosystem) || identifiedEcosystem == null) {
                result = current;
            } else {
                cache.put(key, MULTIPLE_ECOSYSTEMS_IDENTIFIED);
                changed.put(key, MULTIPLE_ECOSYSTEMS_IDENTIFIED);
            }
        }
        return result;
    }

    public static synchronized void setCache(Map<Pair<String, String>, String> cache) {
        CpeEcosystemCache.cache = cache;
        changed = new HashMap<Pair<String, String>, String>();
    }

    public static synchronized Map<Pair<String, String>, String> getChanged() {
        return changed;
    }

    public static synchronized boolean isEmpty() {
        return cache.isEmpty();
    }
}

