/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.lang.reflect.InvocationTargetException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.WriteLockCleanupHook;
import org.owasp.dependencycheck.utils.WriteLockShutdownHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WriteLockShutdownHookFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteLockShutdownHookFactory.class);

    private WriteLockShutdownHookFactory() {
    }

    public static WriteLockShutdownHook getHook(Settings settings) {
        try {
            String className = settings.getString("data.writelock.shutdownhook", "org.owasp.dependencycheck.utils.WriteLockCleanupHook");
            Class<?> type = Class.forName(className);
            return (WriteLockShutdownHook)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            LOGGER.debug("Failed to instantiate {}, using default shutdown hook instead", (Throwable)ex);
            return new WriteLockCleanupHook();
        }
    }
}

