/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvd.ecosystem;

import com.hankcs.algorithm.AhoCorasickDoubleArrayTrie;
import java.util.TreeMap;
import javax.annotation.concurrent.NotThreadSafe;
import org.owasp.dependencycheck.data.nvd.ecosystem.UrlHostHint;
import org.owasp.dependencycheck.data.nvd.ecosystem.UrlPathHint;
import org.owasp.dependencycheck.data.nvd.json.DefCveItem;
import org.owasp.dependencycheck.data.nvd.json.Reference;

@NotThreadSafe
public class UrlEcosystemMapper {
    private static final TreeMap<String, String> ECOSYSTEM_MAP = new TreeMap();
    private final AhoCorasickDoubleArrayTrie<String> search = new AhoCorasickDoubleArrayTrie();

    public UrlEcosystemMapper() {
        this.search.build(ECOSYSTEM_MAP);
    }

    public String getEcosystem(DefCveItem cve) {
        for (Reference r : cve.getCve().getReferences().getReferenceData()) {
            AhoCorasickDoubleArrayTrie.Hit ecosystem = this.search.findFirst(r.getUrl());
            if (ecosystem == null) continue;
            return (String)ecosystem.value;
        }
        return null;
    }

    static {
        for (UrlHostHint urlHostHint : UrlHostHint.values()) {
            ECOSYSTEM_MAP.put(urlHostHint.getValue(), urlHostHint.getEcosystem());
        }
        for (Enum enum_ : UrlPathHint.values()) {
            ECOSYSTEM_MAP.put(((UrlPathHint)enum_).getValue(), ((UrlPathHint)enum_).getEcosystem());
        }
    }
}

