/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.suppression;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.naming.CpeIdentifier;
import org.owasp.dependencycheck.dependency.naming.Identifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.xml.suppression.PropertyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;
import us.springett.parsers.cpe.exceptions.CpeEncodingException;

@NotThreadSafe
public class SuppressionRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(SuppressionRule.class);
    private PropertyType filePath;
    private String sha1;
    private List<PropertyType> cpe = new ArrayList<PropertyType>();
    private List<Float> cvssBelow = new ArrayList<Float>();
    private List<String> cwe = new ArrayList<String>();
    private List<String> cve = new ArrayList<String>();
    private List<PropertyType> vulnerabilityNames = new ArrayList<PropertyType>();
    private PropertyType gav = null;
    private PropertyType packageUrl = null;
    private String notes;
    private boolean base;
    private Calendar until;

    public Calendar getUntil() {
        return this.until;
    }

    public void setUntil(Calendar until) {
        this.until = until;
    }

    public PropertyType getFilePath() {
        return this.filePath;
    }

    public void setFilePath(PropertyType filePath) {
        this.filePath = filePath;
    }

    public String getSha1() {
        return this.sha1;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public List<PropertyType> getCpe() {
        return this.cpe;
    }

    public void setCpe(List<PropertyType> cpe) {
        this.cpe = cpe;
    }

    public void addCpe(PropertyType cpe) {
        this.cpe.add(cpe);
    }

    public void addVulnerabilityName(PropertyType name) {
        this.vulnerabilityNames.add(name);
    }

    public boolean hasCpe() {
        return !this.cpe.isEmpty();
    }

    public List<Float> getCvssBelow() {
        return this.cvssBelow;
    }

    public void setCvssBelow(List<Float> cvssBelow) {
        this.cvssBelow = cvssBelow;
    }

    public void addCvssBelow(Float cvss) {
        this.cvssBelow.add(cvss);
    }

    public boolean hasCvssBelow() {
        return !this.cvssBelow.isEmpty();
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public void addNotes(String notes) {
        this.notes = notes;
    }

    public boolean hasNotes() {
        return !this.cve.isEmpty();
    }

    public List<String> getCwe() {
        return this.cwe;
    }

    public void setCwe(List<String> cwe) {
        this.cwe = cwe;
    }

    public void addCwe(String cwe) {
        this.cwe.add(cwe);
    }

    public boolean hasCwe() {
        return !this.cwe.isEmpty();
    }

    public List<String> getCve() {
        return this.cve;
    }

    public void setCve(List<String> cve) {
        this.cve = cve;
    }

    public void addCve(String cve) {
        this.cve.add(cve);
    }

    public boolean hasCve() {
        return !this.cve.isEmpty();
    }

    public boolean hasVulnerabilityName() {
        return !this.vulnerabilityNames.isEmpty();
    }

    public PropertyType getGav() {
        return this.gav;
    }

    public void setGav(PropertyType gav) {
        this.gav = gav;
    }

    public boolean hasGav() {
        return this.gav != null;
    }

    public void setPackageUrl(PropertyType purl) {
        this.packageUrl = purl;
    }

    public boolean hasPackageUrl() {
        return this.packageUrl != null;
    }

    public boolean isBase() {
        return this.base;
    }

    public void setBase(boolean base) {
        this.base = base;
    }

    /*
     * Could not resolve type clashes
     */
    public void process(Dependency dependency) {
        Identifier i22;
        boolean found;
        Iterator<Identifier> itr;
        if (this.filePath != null && !this.filePath.matches(dependency.getFilePath())) {
            return;
        }
        if (this.sha1 != null && !this.sha1.equalsIgnoreCase(dependency.getSha1sum())) {
            return;
        }
        if (this.hasGav()) {
            itr = dependency.getSoftwareIdentifiers().iterator();
            found = false;
            while (itr.hasNext()) {
                i22 = itr.next();
                if (!this.identifierMatches(this.gav, i22)) continue;
                found = true;
                break;
            }
            if (!found) {
                return;
            }
        }
        if (this.hasPackageUrl()) {
            itr = dependency.getSoftwareIdentifiers().iterator();
            found = false;
            while (itr.hasNext()) {
                i22 = itr.next();
                if (!this.purlMatches(this.packageUrl, i22)) continue;
                found = true;
                break;
            }
            if (!found) {
                return;
            }
        }
        if (this.hasCpe()) {
            HashSet<Identifier> removalList = new HashSet<Identifier>();
            block2: for (Identifier i22 : dependency.getVulnerableSoftwareIdentifiers()) {
                for (PropertyType c : this.cpe) {
                    if (!this.identifierMatches(c, i22)) continue;
                    if (!this.isBase()) {
                        if (this.notes != null) {
                            i22.setNotes(this.notes);
                        }
                        dependency.addSuppressedIdentifier(i22);
                    }
                    removalList.add(i22);
                    continue block2;
                }
            }
            removalList.forEach(i -> dependency.removeVulnerableSoftwareIdentifier((Identifier)i));
        }
        if (this.hasCve() || this.hasVulnerabilityName() || this.hasCwe() || this.hasCvssBelow()) {
            HashSet<Vulnerability> removeVulns = new HashSet<Vulnerability>();
            for (Vulnerability v2 : dependency.getVulnerabilities()) {
                boolean remove = false;
                for (Object entry : this.cve) {
                    if (!((String)entry).equalsIgnoreCase(v2.getName())) continue;
                    removeVulns.add(v2);
                    remove = true;
                    break;
                }
                if (!remove && this.cwe != null && !v2.getCwes().isEmpty()) {
                    for (Object entry : this.cwe) {
                        String toMatch = String.format("CWE-%s", entry);
                        if (!v2.getCwes().stream().anyMatch(toTest -> toMatch.regionMatches(0, (String)toTest, 0, toMatch.length()))) continue;
                        remove = true;
                        removeVulns.add(v2);
                        break;
                    }
                }
                if (!remove && v2.getName() != null) {
                    for (Object entry : this.vulnerabilityNames) {
                        if (!((PropertyType)entry).matches(v2.getName())) continue;
                        remove = true;
                        removeVulns.add(v2);
                        break;
                    }
                }
                if (!remove) {
                    Iterator<Object> iterator = this.cvssBelow.iterator();
                    while (iterator.hasNext()) {
                        float cvss = ((Float)iterator.next()).floatValue();
                        if (v2.getCvssV2() != null && v2.getCvssV2().getScore() < cvss) {
                            remove = true;
                            removeVulns.add(v2);
                            break;
                        }
                        if (v2.getCvssV3() == null || !(v2.getCvssV3().getBaseScore() < cvss)) continue;
                        remove = true;
                        removeVulns.add(v2);
                        break;
                    }
                }
                if (!remove || this.isBase()) continue;
                if (this.notes != null) {
                    v2.setNotes(this.notes);
                }
                dependency.addSuppressedVulnerability(v2);
            }
            removeVulns.forEach(v -> dependency.removeVulnerability((Vulnerability)v));
        }
    }

    protected boolean cpeHasNoVersion(PropertyType c) {
        return !c.isRegex() && this.countCharacter(c.getValue(), ':') <= 3;
    }

    private int countCharacter(String str, char c) {
        int count = 0;
        int pos = str.indexOf(c) + 1;
        while (pos > 0) {
            ++count;
            pos = str.indexOf(c, pos) + 1;
        }
        return count;
    }

    protected boolean purlMatches(PropertyType suppressionEntry, Identifier identifier) {
        if (identifier instanceof PurlIdentifier) {
            PurlIdentifier purl = (PurlIdentifier)identifier;
            return suppressionEntry.matches(purl.toString());
        }
        return false;
    }

    protected boolean identifierMatches(PropertyType suppressionEntry, Identifier identifier) {
        block10: {
            if (identifier instanceof PurlIdentifier) {
                PurlIdentifier purl = (PurlIdentifier)identifier;
                return suppressionEntry.matches(purl.toGav());
            }
            if (identifier instanceof CpeIdentifier) {
                String id;
                Cpe cpeId = ((CpeIdentifier)identifier).getCpe();
                if (suppressionEntry.isRegex()) {
                    try {
                        return suppressionEntry.matches(cpeId.toCpe22Uri());
                    }
                    catch (CpeEncodingException ex) {
                        LOGGER.debug("Unable to convert CPE to 22 URI?" + cpeId.toString());
                        break block10;
                    }
                }
                if (suppressionEntry.isCaseSensitive()) {
                    try {
                        return cpeId.toCpe22Uri().startsWith(suppressionEntry.getValue());
                    }
                    catch (CpeEncodingException ex) {
                        LOGGER.debug("Unable to convert CPE to 22 URI?" + cpeId.toString());
                        break block10;
                    }
                }
                try {
                    id = cpeId.toCpe22Uri().toLowerCase();
                }
                catch (CpeEncodingException ex) {
                    LOGGER.debug("Unable to convert CPE to 22 URI?" + cpeId.toString());
                    return false;
                }
                String check = suppressionEntry.getValue().toLowerCase();
                return id.startsWith(check);
            }
        }
        return suppressionEntry.matches(identifier.getValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("SuppressionRule{");
        if (this.until != null) {
            sb.append("until=").append(this.until).append(',');
        }
        if (this.filePath != null) {
            sb.append("filePath=").append(this.filePath).append(',');
        }
        if (this.sha1 != null) {
            sb.append("sha1=").append(this.sha1).append(',');
        }
        if (this.gav != null) {
            sb.append("gav=").append(this.gav).append(',');
        }
        if (this.cpe != null && !this.cpe.isEmpty()) {
            sb.append("cpe={");
            this.cpe.forEach(pt -> sb.append(pt).append(','));
            sb.append('}');
        }
        if (this.cwe != null && !this.cwe.isEmpty()) {
            sb.append("cwe={");
            this.cwe.forEach(s -> sb.append((String)s).append(','));
            sb.append('}');
        }
        if (this.cve != null && !this.cve.isEmpty()) {
            sb.append("cve={");
            this.cve.forEach(s -> sb.append((String)s).append(','));
            sb.append('}');
        }
        if (this.vulnerabilityNames != null && !this.vulnerabilityNames.isEmpty()) {
            sb.append("vulnerabilityName={");
            this.vulnerabilityNames.forEach(pt -> sb.append(pt).append(','));
            sb.append('}');
        }
        if (this.cvssBelow != null && !this.cvssBelow.isEmpty()) {
            sb.append("cvssBelow={");
            this.cvssBelow.forEach(s -> sb.append(s).append(','));
            sb.append('}');
        }
        sb.append('}');
        return sb.toString();
    }
}

