/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update.nvd;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.parsers.ParserConfigurationException;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.data.update.nvd.DownloadTask;
import org.owasp.dependencycheck.data.update.nvd.NvdCveParser;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ProcessTask
implements Callable<ProcessTask> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessTask.class);
    private UpdateException exception = null;
    private final CveDB cveDB;
    private final DownloadTask downloadTask;
    private final DatabaseProperties properties;
    private final Settings settings;

    public UpdateException getException() {
        return this.exception;
    }

    public void setException(UpdateException exception) {
        this.exception = exception;
    }

    public ProcessTask(CveDB cveDB, DownloadTask downloadTask, Settings settings) {
        this.cveDB = cveDB;
        this.downloadTask = downloadTask;
        this.properties = cveDB.getDatabaseProperties();
        this.settings = settings;
    }

    @Override
    public ProcessTask call() throws Exception {
        try {
            this.processFiles();
        }
        catch (UpdateException ex) {
            this.exception = ex;
        }
        finally {
            this.settings.cleanup(false);
        }
        return this;
    }

    protected void importJSON(File file) throws ParserConfigurationException, IOException, SQLException, DatabaseException, ClassNotFoundException, UpdateException {
        NvdCveParser parser = new NvdCveParser(this.settings, this.cveDB);
        parser.parse(file);
    }

    private void processFiles() throws UpdateException {
        LOGGER.info("Processing Started for NVD CVE - {}", (Object)this.downloadTask.getNvdCveInfo().getId());
        long startProcessing = System.currentTimeMillis();
        try {
            this.importJSON(this.downloadTask.getFile());
            this.properties.save(this.downloadTask.getNvdCveInfo());
        }
        catch (IOException | ClassNotFoundException | SQLException | ParserConfigurationException | DatabaseException ex) {
            throw new UpdateException(ex);
        }
        finally {
            this.downloadTask.cleanup();
        }
        LOGGER.info("Processing Complete for NVD CVE - {}  ({} ms)", (Object)this.downloadTask.getNvdCveInfo().getId(), (Object)(System.currentTimeMillis() - startProcessing));
    }
}

