/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.cwe;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.owasp.dependencycheck.data.cwe.CweHandler;
import org.owasp.dependencycheck.utils.XmlUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class App {
    private App() {
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Incorrect arguments - please provide one or more files as input");
            System.err.println("Download the research concepts, developer concepts, and architectural concepts view of the CWE from https://cwe.mitre.org/data/downloads.html");
            return;
        }
        File in = new File(args[0]);
        if (!in.isFile()) {
            System.err.printf("%s does not exist%n", in.getAbsolutePath());
            return;
        }
        File out = new File("cwe.hashmap.serialized");
        HashMap<String, String> cwe = App.readCweData(args);
        if (cwe != null) {
            App.serializeCweData(cwe, out);
        }
    }

    private static HashMap<String, String> readCweData(String[] files) {
        try {
            SAXParser saxParser = XmlUtils.buildSecureSaxParser();
            CweHandler handler = new CweHandler();
            for (String f : files) {
                File in = new File(f);
                if (!in.isFile()) {
                    System.err.printf("File not found %s%n", in);
                    return null;
                }
                System.out.printf("Parsing %s%n", in);
                saxParser.parse(in, (DefaultHandler)handler);
            }
            return handler.getCwe();
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            System.err.printf("Error generating serialized data: %s%n", ex.getMessage());
            return null;
        }
    }

    private static void serializeCweData(HashMap<String, String> cwe, File out) {
        try (FileOutputStream fout = new FileOutputStream(out);
             ObjectOutputStream objOut = new ObjectOutputStream(fout);){
            System.out.println("Writing " + cwe.size() + " cwe entries.");
            objOut.writeObject(cwe);
            System.out.printf("Serialized CWE data written to %s%n", out.getCanonicalPath());
            System.out.println("To update the ODC CWE data copy the serialized file to 'src/main/resources/data/cwe.hashmap.serialized'");
        }
        catch (IOException ex) {
            System.err.printf("Error generating serialized data: %s%n", ex.getMessage());
        }
    }
}

