/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.pom;

import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.concurrent.NotThreadSafe;
import org.owasp.dependencycheck.xml.pom.Developer;
import org.owasp.dependencycheck.xml.pom.License;
import org.owasp.dependencycheck.xml.pom.Model;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@NotThreadSafe
public class PomHandler
extends DefaultHandler {
    public static final String PROJECT = "project";
    public static final String GROUPID = "groupId";
    public static final String ARTIFACTID = "artifactId";
    public static final String VERSION = "version";
    public static final String PARENT = "parent";
    public static final String NAME = "name";
    public static final String ORGANIZATION = "organization";
    public static final String DESCRIPTION = "description";
    public static final String LICENSES = "licenses";
    public static final String LICENSE_NODE = "license";
    public static final String DEVELOPERS = "developers";
    public static final String DEVELOPER_NODE = "developer";
    public static final String DEVELOPER_ID = "id";
    public static final String DEVELOPER_EMAIL = "email";
    public static final String DEVELOPER_ORGANIZATION = "organization";
    public static final String DEVELOPER_ORGANIZATION_URL = "organizationUrl";
    public static final String URL = "url";
    private final Model model = new Model();
    private final Deque<String> stack = new ArrayDeque<String>();
    private License license = null;
    private Developer developer = null;
    private StringBuilder currentText;

    public Model getModel() {
        return this.model;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.currentText = new StringBuilder();
        this.stack.push(qName);
        if (LICENSE_NODE.equals(qName)) {
            this.license = new License();
        } else if (DEVELOPER_NODE.equals(qName)) {
            this.developer = new Developer();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.stack.pop();
        String parentNode = this.stack.peek();
        if (null != parentNode) {
            block9 : switch (parentNode) {
                case "project": {
                    if (null == qName) break;
                    switch (qName) {
                        case "groupId": {
                            this.model.setGroupId(this.currentText.toString());
                            break block9;
                        }
                        case "artifactId": {
                            this.model.setArtifactId(this.currentText.toString());
                            break block9;
                        }
                        case "version": {
                            this.model.setVersion(this.currentText.toString());
                            break block9;
                        }
                        case "name": {
                            this.model.setName(this.currentText.toString());
                            break block9;
                        }
                        case "description": {
                            this.model.setDescription(this.currentText.toString());
                            break block9;
                        }
                        case "url": {
                            this.model.setProjectURL(this.currentText.toString());
                            break block9;
                        }
                    }
                    break;
                }
                case "organization": {
                    if (NAME.equals(qName)) {
                        this.model.setOrganization(this.currentText.toString());
                        break;
                    }
                    if (!URL.equals(qName)) break;
                    this.model.setOrganizationUrl(this.currentText.toString());
                    break;
                }
                case "parent": {
                    if (null == qName) break;
                    switch (qName) {
                        case "groupId": {
                            this.model.setParentGroupId(this.currentText.toString());
                            break block9;
                        }
                        case "artifactId": {
                            this.model.setParentArtifactId(this.currentText.toString());
                            break block9;
                        }
                        case "version": {
                            this.model.setParentVersion(this.currentText.toString());
                            break block9;
                        }
                    }
                    break;
                }
                case "license": {
                    if (this.license == null) break;
                    if (NAME.equals(qName)) {
                        this.license.setName(this.currentText.toString());
                        break;
                    }
                    if (!URL.equals(qName)) break;
                    this.license.setUrl(this.currentText.toString());
                    break;
                }
                case "licenses": {
                    if (!LICENSE_NODE.equals(qName) || this.license == null) break;
                    this.model.addLicense(this.license);
                    this.license = null;
                    break;
                }
                case "developer": {
                    if (this.developer == null || qName == null) break;
                    switch (qName) {
                        case "id": {
                            this.developer.setId(this.currentText.toString());
                            break block9;
                        }
                        case "name": {
                            this.developer.setName(this.currentText.toString());
                            break block9;
                        }
                        case "email": {
                            this.developer.setEmail(this.currentText.toString());
                            break block9;
                        }
                        case "organization": {
                            this.developer.setOrganization(this.currentText.toString());
                            break block9;
                        }
                        case "organizationUrl": {
                            this.developer.setOrganizationUrl(this.currentText.toString());
                            break block9;
                        }
                    }
                    break;
                }
                case "developers": {
                    if (!DEVELOPER_NODE.equals(qName) || this.developer == null) break;
                    this.model.addDeveloper(this.developer);
                    this.developer = null;
                    break;
                }
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentText.append(ch, start, length);
    }
}

