/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonArrayFixingInputStream
extends InputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonArrayFixingInputStream.class);
    private static final int BUFFER_SIZE = 2048;
    private volatile InputStream in;
    private final byte[] buffer = new byte[2048];
    private int bufferStart = 0;
    private int bufferAvailable = 0;
    private boolean needsTrailingBrace = true;
    private boolean firstRead = true;

    public JsonArrayFixingInputStream(InputStream in) {
        this.in = in;
        this.bufferAvailable = 1;
        this.buffer[this.bufferStart] = 91;
    }

    private boolean advanceStream() throws IOException {
        boolean chomp = false;
        if (this.firstRead) {
            chomp = true;
            this.firstRead = false;
            this.bufferStart = 0;
            this.bufferAvailable = this.in.read(this.buffer, 1, 2047) + 1;
        } else if (this.bufferAvailable == 0) {
            chomp = true;
            this.bufferStart = 0;
            this.bufferAvailable = this.in.read(this.buffer, 0, 2048);
        }
        if (chomp) {
            while (this.bufferAvailable > 0 && (this.buffer[this.bufferStart + this.bufferAvailable - 1] == 10 || this.buffer[this.bufferStart + this.bufferAvailable - 1] == 13)) {
                --this.bufferAvailable;
            }
            if (this.bufferAvailable == 0) {
                return this.advanceStream();
            }
        }
        return this.bufferAvailable > 0;
    }

    private int getClosingBraceOffset() {
        for (int pos = this.bufferStart; pos < 2048 && pos < this.bufferStart + this.bufferAvailable; ++pos) {
            if (this.buffer[pos] != 125) continue;
            return pos - this.bufferStart;
        }
        return -1;
    }

    private void incrementRead() throws IOException {
        if (this.buffer[this.bufferStart] == 125) {
            if (this.bufferAvailable > 1) {
                if (this.hasTrailingComma(this.bufferStart)) {
                    ++this.bufferStart;
                    --this.bufferAvailable;
                } else {
                    this.buffer[this.bufferStart] = 44;
                }
            } else {
                this.bufferAvailable = 0;
                if (this.advanceStream() || this.needsTrailingBrace) {
                    if (this.bufferAvailable >= 1) {
                        if (!this.hasTrailingComma(-1)) {
                            this.buffer[this.bufferStart] = 44;
                        }
                    } else if (this.needsTrailingBrace) {
                        this.needsTrailingBrace = false;
                        this.buffer[this.bufferStart] = 93;
                        this.bufferAvailable = 1;
                    }
                }
            }
        } else {
            ++this.bufferStart;
            --this.bufferAvailable;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.advanceStream()) {
            byte value = this.buffer[this.bufferStart];
            this.incrementRead();
            return value;
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.advanceStream()) {
            int copyLength;
            int brace = this.getClosingBraceOffset();
            if (brace == 0) {
                b[off] = this.buffer[this.bufferStart];
                this.incrementRead();
                return 1;
            }
            int n = copyLength = this.bufferAvailable > len ? len : this.bufferAvailable;
            if (brace > 0) {
                copyLength = copyLength > brace ? brace : copyLength;
            }
            int copyEnd = copyLength + off;
            for (int pos = off; pos < copyEnd; ++pos) {
                b[pos] = this.buffer[this.bufferStart];
                ++this.bufferStart;
            }
            this.bufferAvailable -= copyLength;
            return copyLength;
        }
        return -1;
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException("Unable to skip using the JsonArrayFixingInputStream");
    }

    @Override
    public int available() throws IOException {
        return this.in.available() + this.bufferAvailable;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private boolean hasTrailingComma(int start) {
        return this.bufferAvailable >= 1 && this.buffer[start + 1] == 44 || this.bufferAvailable >= 2 && this.isWhiteSpace(this.buffer[start + 1]) && this.buffer[start + 2] == 44;
    }

    protected boolean isWhiteSpace(byte c) {
        switch (c) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }
}

