/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.security.logging;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.owasp.security.logging.Utils;
import org.slf4j.Marker;

public class MultiMarker
implements Marker {
    private static final long serialVersionUID = 2438877789519766569L;
    private String name = "";
    private final Set<Marker> references = new LinkedHashSet<Marker>();

    public MultiMarker(Marker ... markers) {
        this.references.addAll(Arrays.asList(markers));
        this.updateName();
    }

    public String getName() {
        return this.name;
    }

    public void add(Marker reference) {
        this.references.add(reference);
        this.updateName();
    }

    public boolean remove(Marker reference) {
        boolean output = this.references.remove(reference);
        this.updateName();
        return output;
    }

    private void updateName() {
        this.name = "";
        StringBuilder builder = new StringBuilder();
        for (Marker ref : this.references) {
            if (!Utils.isEmpty(this.name)) {
                builder.append(" ");
            }
            builder.append(ref.getName());
        }
        this.name = builder.toString();
    }

    public boolean hasChildren() {
        return true;
    }

    public boolean hasReferences() {
        return true;
    }

    public Iterator<Marker> iterator() {
        return this.references.iterator();
    }

    public boolean contains(Marker other) {
        for (Marker ref : this.references) {
            if (!ref.contains(other)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String name) {
        for (Marker ref : this.references) {
            if (!ref.contains(name)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Marker)) {
            return false;
        }
        Marker other = (Marker)obj;
        return this.name.equals(other.getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

