/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.jee.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.config.AbstractConfigFilter;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.JEEContextFactory;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.WebContextFactory;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.CallbackLogic;
import org.pac4j.core.engine.DefaultCallbackLogic;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.http.adapter.JEEHttpActionAdapter;
import org.pac4j.core.util.FindBest;

public class CallbackFilter
extends AbstractConfigFilter {
    private CallbackLogic callbackLogic;
    private String defaultUrl;
    private Boolean renewSession;
    private String defaultClient;

    public CallbackFilter() {
    }

    public CallbackFilter(Config config) {
        this.setSharedConfig(config);
    }

    public CallbackFilter(Config config, String defaultUrl) {
        this(config);
        this.defaultUrl = defaultUrl;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.defaultUrl = this.getStringParam(filterConfig, "defaultUrl", this.defaultUrl);
        this.renewSession = this.getBooleanParam(filterConfig, "renewSession", this.renewSession);
        this.defaultClient = this.getStringParam(filterConfig, "defaultClient", this.defaultClient);
    }

    protected void internalFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        Config config = this.getSharedConfig();
        SessionStore bestSessionStore = FindBest.sessionStore(null, (Config)config, (SessionStore)JEESessionStore.INSTANCE);
        HttpActionAdapter bestAdapter = FindBest.httpActionAdapter(null, (Config)config, (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
        CallbackLogic bestLogic = FindBest.callbackLogic((CallbackLogic)this.callbackLogic, (Config)config, (CallbackLogic)DefaultCallbackLogic.INSTANCE);
        WebContext context = FindBest.webContextFactory(null, (Config)config, (WebContextFactory)JEEContextFactory.INSTANCE).newContext(new Object[]{request, response});
        bestLogic.perform(context, bestSessionStore, config, bestAdapter, this.defaultUrl, this.renewSession, this.defaultClient);
    }

    public String getDefaultUrl() {
        return this.defaultUrl;
    }

    public void setDefaultUrl(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public Boolean getRenewSession() {
        return this.renewSession;
    }

    public void setRenewSession(Boolean renewSession) {
        this.renewSession = renewSession;
    }

    public CallbackLogic getCallbackLogic() {
        return this.callbackLogic;
    }

    public void setCallbackLogic(CallbackLogic callbackLogic) {
        this.callbackLogic = callbackLogic;
    }

    public String getDefaultClient() {
        return this.defaultClient;
    }

    public void setDefaultClient(String defaultClient) {
        this.defaultClient = defaultClient;
    }
}

