/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.jee.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.config.AbstractConfigFilter;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.JEEContextFactory;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.WebContextFactory;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.DefaultLogoutLogic;
import org.pac4j.core.engine.LogoutLogic;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.http.adapter.JEEHttpActionAdapter;
import org.pac4j.core.util.FindBest;

public class LogoutFilter
extends AbstractConfigFilter {
    private LogoutLogic logoutLogic;
    private String defaultUrl;
    private String logoutUrlPattern;
    private Boolean localLogout;
    private Boolean destroySession;
    private Boolean centralLogout;

    public LogoutFilter() {
    }

    public LogoutFilter(Config config) {
        this.setSharedConfig(config);
    }

    public LogoutFilter(Config config, String defaultUrl) {
        this(config);
        this.defaultUrl = defaultUrl;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.defaultUrl = this.getStringParam(filterConfig, "defaultUrl", this.defaultUrl);
        this.logoutUrlPattern = this.getStringParam(filterConfig, "logoutUrlPattern", this.logoutUrlPattern);
        this.localLogout = this.getBooleanParam(filterConfig, "localLogout", this.localLogout);
        this.destroySession = this.getBooleanParam(filterConfig, "destroySession", this.destroySession);
        this.centralLogout = this.getBooleanParam(filterConfig, "centralLogout", this.centralLogout);
    }

    protected void internalFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        Config config = this.getSharedConfig();
        SessionStore bestSessionStore = FindBest.sessionStore(null, (Config)config, (SessionStore)JEESessionStore.INSTANCE);
        HttpActionAdapter bestAdapter = FindBest.httpActionAdapter(null, (Config)config, (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
        LogoutLogic bestLogic = FindBest.logoutLogic((LogoutLogic)this.logoutLogic, (Config)config, (LogoutLogic)DefaultLogoutLogic.INSTANCE);
        WebContext context = FindBest.webContextFactory(null, (Config)config, (WebContextFactory)JEEContextFactory.INSTANCE).newContext(new Object[]{request, response});
        bestLogic.perform(context, bestSessionStore, config, bestAdapter, this.defaultUrl, this.logoutUrlPattern, this.localLogout, this.destroySession, this.centralLogout);
    }

    public String getDefaultUrl() {
        return this.defaultUrl;
    }

    public void setDefaultUrl(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public String getLogoutUrlPattern() {
        return this.logoutUrlPattern;
    }

    public void setLogoutUrlPattern(String logoutUrlPattern) {
        this.logoutUrlPattern = logoutUrlPattern;
    }

    public LogoutLogic getLogoutLogic() {
        return this.logoutLogic;
    }

    public void setLogoutLogic(LogoutLogic logoutLogic) {
        this.logoutLogic = logoutLogic;
    }

    public Boolean getLocalLogout() {
        return this.localLogout;
    }

    public void setLocalLogout(Boolean localLogout) {
        this.localLogout = localLogout;
    }

    public Boolean getDestroySession() {
        return this.destroySession;
    }

    public void setDestroySession(Boolean destroySession) {
        this.destroySession = destroySession;
    }

    public Boolean getCentralLogout() {
        return this.centralLogout;
    }

    public void setCentralLogout(Boolean centralLogout) {
        this.centralLogout = centralLogout;
    }
}

