/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.credentials.authenticator;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.profile.CasRestProfile;
import org.pac4j.cas.util.HttpUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableWebObject;

public class CasRestAuthenticator
extends InitializableWebObject
implements Authenticator<UsernamePasswordCredentials> {
    private CasConfiguration configuration;

    public CasRestAuthenticator() {
    }

    public CasRestAuthenticator(CasConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        this.configuration.init(context);
    }

    public void validate(UsernamePasswordCredentials credentials, WebContext context) throws HttpAction {
        this.init(context);
        if (credentials == null || credentials.getPassword() == null || credentials.getUsername() == null) {
            throw new TechnicalException("Credentials are required");
        }
        String ticketGrantingTicketId = this.requestTicketGrantingTicket(credentials.getUsername(), credentials.getPassword(), context);
        CasRestProfile profile = new CasRestProfile(ticketGrantingTicketId, credentials.getUsername());
        credentials.setUserProfile((CommonProfile)profile);
    }

    private String requestTicketGrantingTicket(String username, String password, WebContext context) {
        int responseCode;
        String locationHeader;
        HttpURLConnection connection;
        block5: {
            connection = null;
            connection = HttpUtils.openPostConnection(new URL(this.configuration.computeFinalRestUrl(context)));
            String payload = HttpUtils.encodeQueryParam("username", username) + "&" + HttpUtils.encodeQueryParam("password", password);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), "UTF-8"));
            out.write(payload);
            out.close();
            locationHeader = connection.getHeaderField("location");
            responseCode = connection.getResponseCode();
            if (locationHeader == null || responseCode != 201) break block5;
            String string = locationHeader.substring(locationHeader.lastIndexOf("/") + 1);
            HttpUtils.closeConnection(connection);
            return string;
        }
        try {
            try {
                throw new TechnicalException("Ticket granting ticket request failed: " + locationHeader + " " + responseCode + HttpUtils.buildHttpErrorMessage(connection));
            }
            catch (IOException e) {
                throw new TechnicalException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            HttpUtils.closeConnection(connection);
            throw throwable;
        }
    }

    public CasConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CasConfiguration configuration) {
        this.configuration = configuration;
    }
}

