/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.logout;

import java.util.concurrent.TimeUnit;
import org.pac4j.cas.logout.CasLogoutHandler;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.store.GuavaStore;
import org.pac4j.core.store.Store;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCasLogoutHandler<C extends WebContext>
implements CasLogoutHandler<C> {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultCasLogoutHandler.class);
    private Store<String, Object> store = new GuavaStore(10000, 30, TimeUnit.MINUTES);
    private boolean destroySession;

    public DefaultCasLogoutHandler() {
    }

    public DefaultCasLogoutHandler(Store<String, Object> store) {
        this.store = store;
    }

    @Override
    public void recordSession(C context, String ticket) {
        SessionStore sessionStore = context.getSessionStore();
        if (sessionStore == null) {
            logger.error("No session store available for this web context");
        } else {
            String sessionId = sessionStore.getOrCreateSessionId(context);
            Object trackableSession = sessionStore.getTrackableSession(context);
            if (trackableSession != null) {
                logger.debug("ticket: {} -> trackableSession: {}", (Object)ticket, trackableSession);
                logger.debug("sessionId: {}", (Object)sessionId);
                this.store.set((Object)ticket, trackableSession);
                this.store.set((Object)sessionId, (Object)ticket);
            } else {
                logger.debug("No trackable session for the current session store: {}", (Object)sessionStore);
            }
        }
    }

    @Override
    public void destroySessionFront(C context, String ticket) {
        this.store.remove((Object)ticket);
        SessionStore sessionStore = context.getSessionStore();
        if (sessionStore == null) {
            logger.error("No session store available for this web context");
        } else {
            String currentSessionId = sessionStore.getOrCreateSessionId(context);
            logger.debug("currentSessionId: {}", (Object)currentSessionId);
            String sessionToTicket = (String)this.store.get((Object)currentSessionId);
            logger.debug("-> ticket: {}", (Object)ticket);
            this.store.remove((Object)currentSessionId);
            if (CommonHelper.areEquals((String)ticket, (String)sessionToTicket)) {
                this.destroy(context, sessionStore, "front");
            } else {
                logger.error("The user profiles (and session) can not be destroyed for CAS front channel logout because the provided ticket is not the same as the one linked to the current session");
            }
        }
    }

    protected void destroy(C context, SessionStore sessionStore, String channel) {
        ProfileManager manager = new ProfileManager(context);
        manager.logout();
        logger.debug("destroy the user profiles");
        if (this.destroySession) {
            logger.debug("destroy the whole session");
            boolean invalidated = sessionStore.destroySession(context);
            if (!invalidated) {
                logger.error("The session has not been invalidated for {} channel logout", (Object)channel);
            }
        }
    }

    @Override
    public void destroySessionBack(C context, String ticket) {
        Object trackableSession = this.store.get((Object)ticket);
        logger.debug("ticket: {} -> trackableSession: {}", (Object)ticket, trackableSession);
        if (trackableSession == null) {
            logger.error("No trackable session found for back channel logout. Either the session store does not support to track session or it has expired from the store and the store settings must be updated (expired data)");
        } else {
            this.store.remove((Object)ticket);
            SessionStore sessionStore = context.getSessionStore();
            if (sessionStore == null) {
                logger.error("No session store available for this web context");
            } else {
                SessionStore newSessionStore = sessionStore.buildFromTrackableSession(context, trackableSession);
                if (newSessionStore != null) {
                    logger.debug("newSesionStore: {}", (Object)newSessionStore);
                    context.setSessionStore(newSessionStore);
                    String sessionId = newSessionStore.getOrCreateSessionId(context);
                    logger.debug("remove sessionId: {}", (Object)sessionId);
                    this.store.remove((Object)sessionId);
                    this.destroy(context, newSessionStore, "back");
                } else {
                    logger.error("The session store should be able to build a new session store from the tracked session");
                }
            }
        }
    }

    @Override
    public void renewSession(String oldSessionId, C context) {
        String ticket = (String)this.store.get((Object)oldSessionId);
        logger.debug("oldSessionId: {} -> ticket: {}", (Object)oldSessionId, (Object)ticket);
        if (ticket != null) {
            this.store.remove((Object)ticket);
            this.store.remove((Object)oldSessionId);
            this.recordSession(context, ticket);
        }
    }

    public Store<String, Object> getStore() {
        return this.store;
    }

    public void setStore(Store<String, Object> store) {
        this.store = store;
    }

    public boolean isDestroySession() {
        return this.destroySession;
    }

    public void setDestroySession(boolean destroySession) {
        this.destroySession = destroySession;
    }

    public String toString() {
        return CommonHelper.toString(this.getClass(), (Object[])new Object[]{"store", this.store, "destroySession", this.destroySession});
    }
}

