/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.pac4j.core.authorization.generator.AuthorizationGenerator;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.AjaxRequestResolver;
import org.pac4j.core.http.DefaultAjaxRequestResolver;
import org.pac4j.core.http.DefaultUrlResolver;
import org.pac4j.core.http.UrlResolver;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableObject;

public class Clients
extends InitializableObject {
    public static final String DEFAULT_CLIENT_NAME_PARAMETER = "client_name";
    private String clientNameParameter = "client_name";
    private List<Client> clients;
    private String callbackUrl = null;
    private Client defaultClient;
    private AjaxRequestResolver ajaxRequestResolver = new DefaultAjaxRequestResolver();
    private UrlResolver urlResolver = new DefaultUrlResolver();
    private List<AuthorizationGenerator> authorizationGenerators = new ArrayList<AuthorizationGenerator>();

    public Clients() {
    }

    public Clients(String callbackUrl, List<Client> clients) {
        this.setCallbackUrl(callbackUrl);
        this.setClients(clients);
    }

    public Clients(String callbackUrl, Client ... clients) {
        this.setCallbackUrl(callbackUrl);
        this.setClients(clients);
    }

    public Clients(String callbackUrl, Client client) {
        this.setCallbackUrl(callbackUrl);
        this.setClients(Collections.singletonList(client));
    }

    public Clients(List<Client> clients) {
        this.setClients(clients);
    }

    public Clients(Client ... clients) {
        this.setClients(clients);
    }

    public Clients(Client client) {
        this.setClients(Collections.singletonList(client));
    }

    @Override
    protected void internalInit() {
        CommonHelper.assertNotNull("clients", this.getClients());
        HashSet<String> names = new HashSet<String>();
        for (Client client : this.getClients()) {
            String name = client.getName();
            String lowerName = name.toLowerCase();
            if (names.contains(lowerName)) {
                throw new TechnicalException("Duplicate name in clients: " + name);
            }
            names.add(lowerName);
            if (client instanceof IndirectClient) {
                this.updateCallbackUrlOfIndirectClient((IndirectClient)client);
            }
            BaseClient baseClient = (BaseClient)client;
            if (this.authorizationGenerators.isEmpty()) continue;
            baseClient.addAuthorizationGenerators(this.authorizationGenerators);
        }
    }

    protected void updateCallbackUrlOfIndirectClient(IndirectClient indirectClient) {
        String indirectClientCallbackUrl = indirectClient.getCallbackUrl();
        if (CommonHelper.isNotBlank(this.callbackUrl) && indirectClientCallbackUrl == null) {
            indirectClient.setCallbackUrl(this.callbackUrl);
            indirectClientCallbackUrl = this.callbackUrl;
        }
        if (indirectClient.isIncludeClientNameInCallbackUrl() && indirectClientCallbackUrl != null && !indirectClientCallbackUrl.contains(this.clientNameParameter + "=")) {
            indirectClient.setCallbackUrl(CommonHelper.addParameter(indirectClientCallbackUrl, this.clientNameParameter, indirectClient.getName()));
        }
        AjaxRequestResolver clientAjaxRequestResolver = indirectClient.getAjaxRequestResolver();
        if (this.ajaxRequestResolver != null && (clientAjaxRequestResolver == null || clientAjaxRequestResolver instanceof DefaultAjaxRequestResolver)) {
            indirectClient.setAjaxRequestResolver(this.ajaxRequestResolver);
        }
        UrlResolver clientUrlResolver = indirectClient.getUrlResolver();
        if (this.urlResolver != null && (clientUrlResolver == null || clientUrlResolver instanceof DefaultUrlResolver)) {
            indirectClient.setUrlResolver(this.urlResolver);
        }
    }

    public Client findClient(WebContext context) {
        this.init();
        String name = context.getRequestParameter(this.clientNameParameter);
        if (name == null && this.defaultClient != null) {
            return this.defaultClient;
        }
        CommonHelper.assertNotBlank("name", name);
        return this.findClient(name);
    }

    public Client findClient(String name) {
        this.init();
        for (Client client : this.getClients()) {
            if (!CommonHelper.areEqualsIgnoreCaseAndTrim(name, client.getName())) continue;
            return client;
        }
        String message = "No client found for name: " + name;
        throw new TechnicalException(message);
    }

    public <C extends Client> C findClient(Class<C> clazz) {
        this.init();
        if (clazz != null) {
            for (Client client : this.getClients()) {
                if (!clazz.isAssignableFrom(client.getClass())) continue;
                return (C)client;
            }
        }
        String message = "No client found for class: " + clazz;
        throw new TechnicalException(message);
    }

    public List<Client> findAllClients() {
        this.init();
        return this.getClients();
    }

    public String getClientNameParameter() {
        return this.clientNameParameter;
    }

    public void setClientNameParameter(String clientNameParameter) {
        this.clientNameParameter = clientNameParameter;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public void setClients(List<Client> clients) {
        this.clients = clients;
    }

    public void setClients(Client ... clients) {
        this.clients = Arrays.asList(clients);
    }

    public List<Client> getClients() {
        return this.clients;
    }

    public void setDefaultClient(Client defaultClient) {
        if (!(defaultClient == null || this.clients != null && this.clients.contains(defaultClient))) {
            throw new TechnicalException("The default client must be defined in the list of clients");
        }
        this.defaultClient = defaultClient;
    }

    public Client getDefaultClient() {
        return this.defaultClient;
    }

    public AjaxRequestResolver getAjaxRequestResolver() {
        return this.ajaxRequestResolver;
    }

    public void setAjaxRequestResolver(AjaxRequestResolver ajaxRequestResolver) {
        this.ajaxRequestResolver = ajaxRequestResolver;
    }

    public UrlResolver getUrlResolver() {
        return this.urlResolver;
    }

    public void setUrlResolver(UrlResolver urlResolver) {
        this.urlResolver = urlResolver;
    }

    public List<AuthorizationGenerator> getAuthorizationGenerators() {
        return this.authorizationGenerators;
    }

    public void setAuthorizationGenerators(List<AuthorizationGenerator> authorizationGenerators) {
        CommonHelper.assertNotNull("authorizationGenerators", authorizationGenerators);
        this.authorizationGenerators = authorizationGenerators;
    }

    public void setAuthorizationGenerators(AuthorizationGenerator ... authorizationGenerators) {
        CommonHelper.assertNotNull("authorizationGenerators", authorizationGenerators);
        this.authorizationGenerators = Arrays.asList(authorizationGenerators);
    }

    public void setAuthorizationGenerator(AuthorizationGenerator authorizationGenerator) {
        this.addAuthorizationGenerator(authorizationGenerator);
    }

    public void addAuthorizationGenerator(AuthorizationGenerator authorizationGenerator) {
        CommonHelper.assertNotNull("authorizationGenerator", authorizationGenerator);
        this.authorizationGenerators.add(authorizationGenerator);
    }

    public String toString() {
        return CommonHelper.toString(this.getClass(), "callbackUrl", this.callbackUrl, "clientNameParameter", this.clientNameParameter, "clients", this.getClients(), "defaultClient", this.defaultClient, "ajaxRequestResolver", this.ajaxRequestResolver, "urlResolver", this.urlResolver, "authorizationGenerators", this.authorizationGenerators);
    }
}

