/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.profile;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.JavaSerializationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalAttributeHandler {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final transient String PREFIX = "{#";
    public static final transient String PREFIX_BOOLEAN = "{#bool}";
    public static final transient String PREFIX_INT = "{#int}";
    public static final transient String PREFIX_LONG = "{#long}";
    public static final transient String PREFIX_DATE = "{#date}";
    public static final transient String PREFIX_URI = "{#uri}";
    public static final transient String PREFIX_SB64 = "{#sb64}";
    private JavaSerializationHelper serializationHelper = new JavaSerializationHelper();
    private boolean stringify = false;

    public Object prepare(Object value) {
        if (value == null || value instanceof String || !this.stringify) {
            return value;
        }
        if (value instanceof Boolean) {
            return PREFIX_BOOLEAN.concat(value.toString());
        }
        if (value instanceof Integer) {
            return PREFIX_INT.concat(value.toString());
        }
        if (value instanceof Long) {
            return PREFIX_LONG.concat(value.toString());
        }
        if (value instanceof Date) {
            return PREFIX_DATE.concat(this.newSdf().format((Date)value));
        }
        if (value instanceof URI) {
            return PREFIX_URI.concat(value.toString());
        }
        return PREFIX_SB64.concat(this.serializationHelper.serializeToBase64((Serializable)value));
    }

    public Object restore(Object value) {
        String sValue;
        if (value != null && value instanceof String && (sValue = (String)value).startsWith(PREFIX)) {
            if (sValue.startsWith(PREFIX_BOOLEAN)) {
                return Boolean.parseBoolean(sValue.substring(PREFIX_BOOLEAN.length()));
            }
            if (sValue.startsWith(PREFIX_INT)) {
                return Integer.parseInt(sValue.substring(PREFIX_INT.length()));
            }
            if (sValue.startsWith(PREFIX_LONG)) {
                return Long.parseLong(sValue.substring(PREFIX_LONG.length()));
            }
            if (sValue.startsWith(PREFIX_DATE)) {
                String d = sValue.substring(PREFIX_DATE.length());
                try {
                    return this.newSdf().parse(d);
                }
                catch (ParseException e) {
                    this.logger.warn("Unable to parse stringified date: {}", (Object)d, (Object)e);
                }
            } else if (sValue.startsWith(PREFIX_URI)) {
                String uri = sValue.substring(PREFIX_URI.length());
                try {
                    return new URI(uri);
                }
                catch (URISyntaxException e) {
                    this.logger.warn("Unable to parse stringified URI: {}", (Object)uri, (Object)e);
                }
            } else if (sValue.startsWith(PREFIX_SB64)) {
                return this.serializationHelper.unserializeFromBase64(sValue.substring(PREFIX_SB64.length()));
            }
        }
        return value;
    }

    protected SimpleDateFormat newSdf() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
    }

    public JavaSerializationHelper getSerializationHelper() {
        return this.serializationHelper;
    }

    public void setSerializationHelper(JavaSerializationHelper serializationHelper) {
        this.serializationHelper = serializationHelper;
    }

    public boolean isStringify() {
        return this.stringify;
    }

    public void setStringify(boolean stringify) {
        this.stringify = stringify;
    }

    public String toString() {
        return CommonHelper.toString(this.getClass(), "serializationHelper", this.serializationHelper, "stringify", this.stringify);
    }
}

