/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.jpackage;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.CommandLineUtils;
import org.apache.maven.shared.utils.cli.Commandline;
import org.apache.maven.shared.utils.cli.StreamConsumer;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.panteleyev.jpackage.CommandLineParameter;
import org.panteleyev.jpackage.EnumParameter;
import org.panteleyev.jpackage.ImageType;
import org.panteleyev.jpackage.Launcher;
import org.panteleyev.jpackage.util.DirectoryUtil;
import org.panteleyev.jpackage.util.OsUtil;
import org.panteleyev.jpackage.util.StringUtil;

@Mojo(name="jpackage", defaultPhase=LifecyclePhase.NONE)
public class JPackageMojo
extends AbstractMojo {
    private static final String TOOLCHAIN = "jdk";
    public static final String EXECUTABLE = "jpackage";
    private static final String DRY_RUN_PROPERTY = "jpackage.dryRun";
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private String projectBuildDirectory;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter
    private boolean verbose;
    @Parameter
    private ImageType type;
    @Parameter(defaultValue="${project.name}", required=true)
    private String name;
    @Parameter(defaultValue="${project.version}")
    private String appVersion;
    @Parameter
    private String vendor;
    @Parameter
    private File icon;
    @Parameter
    private File runtimeImage;
    @Parameter
    private File input;
    @Parameter
    private String installDir;
    @Parameter
    private File resourceDir;
    @Parameter(required=true)
    private File destination;
    @Parameter
    private String module;
    @Parameter
    private String mainClass;
    @Parameter
    private String mainJar;
    @Parameter
    private File temp;
    @Parameter
    private String copyright;
    @Parameter
    private String description;
    @Parameter
    private List<File> modulePaths;
    @Parameter
    private List<String> javaOptions;
    @Parameter
    private List<String> arguments;
    @Parameter
    private File licenseFile;
    @Parameter
    private List<File> fileAssociations;
    @Parameter
    private List<Launcher> launchers;
    @Parameter
    private List<String> addModules;
    @Parameter
    private File appImage;
    @Parameter
    private List<String> additionalOptions;
    @Parameter
    private List<String> jLinkOptions;
    @Parameter
    private String aboutUrl;
    @Parameter
    private List<File> appContentPaths;
    @Parameter
    private boolean launcherAsService;
    @Parameter
    private boolean removeDestination;
    @Parameter
    private boolean winMenu;
    @Parameter
    private boolean winDirChooser;
    @Parameter
    private String winHelpUrl;
    @Parameter
    private String winUpgradeUuid;
    @Parameter
    private String winMenuGroup;
    @Parameter
    private boolean winShortcut;
    @Parameter
    private boolean winShortcutPrompt;
    @Parameter
    private String winUpdateUrl;
    @Parameter
    private boolean winPerUserInstall;
    @Parameter
    private boolean winConsole;
    @Parameter
    private String macPackageIdentifier;
    @Parameter
    private String macPackageName;
    @Parameter
    private String macPackageSigningPrefix;
    @Parameter
    private boolean macSign;
    @Parameter
    private File macSigningKeychain;
    @Parameter
    private String macSigningKeyUserName;
    @Parameter
    private boolean macAppStore;
    @Parameter
    private File macEntitlements;
    @Parameter
    private String macAppCategory;
    @Parameter
    private List<File> macDmgContentPaths;
    @Parameter
    private String linuxPackageName;
    @Parameter
    private String linuxDebMaintainer;
    @Parameter
    private String linuxMenuGroup;
    @Parameter
    private String linuxPackageDeps;
    @Parameter
    private String linuxRpmLicenseType;
    @Parameter
    private String linuxAppRelease;
    @Parameter
    private String linuxAppCategory;
    @Parameter
    private boolean linuxShortcut;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        Toolchain tc = this.toolchainManager.getToolchainFromBuildContext(TOOLCHAIN, this.session);
        if (tc != null) {
            this.getLog().info((CharSequence)("Toolchain in jpackage-maven-plugin: " + tc));
        }
        String executable = this.getJPackageExecutable(tc).orElseThrow(() -> new MojoExecutionException("Failed to find jpackage"));
        this.getLog().info((CharSequence)("Using: " + executable));
        Commandline commandLine = this.buildParameters();
        commandLine.setExecutable(executable.contains(" ") ? "\"" + executable + "\"" : executable);
        boolean dryRun = "true".equalsIgnoreCase(System.getProperty(DRY_RUN_PROPERTY, "false"));
        if (dryRun) {
            this.getLog().warn((CharSequence)"Dry-run mode, not executing jpackage");
            return;
        }
        if (this.removeDestination && this.destination != null) {
            Path destinationPath = this.destination.toPath().toAbsolutePath();
            if (!DirectoryUtil.isNestedDirectory(new File(this.projectBuildDirectory).toPath(), destinationPath)) {
                this.getLog().error((CharSequence)("Cannot remove destination folder, must belong to " + this.projectBuildDirectory));
            } else {
                this.getLog().warn((CharSequence)("Trying to remove destination " + destinationPath));
                DirectoryUtil.removeDirectory(destinationPath);
            }
        }
        try {
            this.execute(commandLine);
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }

    private Optional<String> getJPackageFromJdkHome(String jdkHome) {
        if (jdkHome == null || jdkHome.isEmpty()) {
            return Optional.empty();
        }
        this.getLog().debug((CharSequence)("Looking for jpackage in " + jdkHome));
        String executable = jdkHome + File.separator + "bin" + File.separator + EXECUTABLE;
        if (OsUtil.isWindows()) {
            executable = executable + ".exe";
        }
        if (new File(executable).exists()) {
            return Optional.of(executable);
        }
        this.getLog().warn((CharSequence)("File " + executable + " does not exist"));
        return Optional.empty();
    }

    private Optional<String> getJPackageFromToolchain(Toolchain tc) {
        if (tc == null) {
            return Optional.empty();
        }
        String executable = tc.findTool(EXECUTABLE);
        if (executable == null) {
            this.getLog().warn((CharSequence)"jpackage is not part of configured toolchain");
        }
        return Optional.ofNullable(executable);
    }

    private Optional<String> getJPackageExecutable(Toolchain tc) {
        Optional<String> executable = this.getJPackageFromToolchain(tc);
        return executable.isPresent() ? executable : this.getJPackageFromJdkHome(System.getProperty("java.home"));
    }

    private void execute(Commandline commandline) throws Exception {
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
        try {
            String output;
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)commandline, (StreamConsumer)out, (StreamConsumer)err);
            String string = output = StringUtil.isEmpty(out.getOutput()) ? null : '\n' + out.getOutput().trim();
            if (exitCode != 0) {
                if (StringUtil.isNotEmpty(output)) {
                    for (String line : output.split("\n")) {
                        this.getLog().error((CharSequence)line);
                    }
                }
                StringBuilder msg = new StringBuilder("\nExit code: ").append(exitCode);
                String errOutput = err.getOutput();
                if (StringUtil.isNotEmpty(errOutput)) {
                    msg.append(" - ").append(errOutput);
                }
                msg.append('\n');
                msg.append("Command line was: ").append(commandline).append('\n').append('\n');
                throw new MojoExecutionException(msg.toString());
            }
            if (StringUtil.isNotEmpty(output)) {
                for (String outputLine : output.split("\n")) {
                    this.getLog().info((CharSequence)outputLine);
                }
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Error while executing jpackage: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private Commandline buildParameters() throws MojoFailureException {
        this.getLog().info((CharSequence)"jpackage options:");
        Commandline commandline = new Commandline();
        this.addMandatoryParameter(commandline, CommandLineParameter.NAME, this.name);
        this.addMandatoryParameter(commandline, CommandLineParameter.DESTINATION, this.destination, false);
        this.addParameter(commandline, CommandLineParameter.VERBOSE, this.verbose);
        this.addParameter(commandline, CommandLineParameter.TYPE, this.type);
        this.addParameter(commandline, CommandLineParameter.APP_VERSION, this.appVersion);
        this.addParameter(commandline, CommandLineParameter.COPYRIGHT, this.copyright);
        this.addParameter(commandline, CommandLineParameter.DESCRIPTION, this.description);
        this.addParameter(commandline, CommandLineParameter.RUNTIME_IMAGE, this.runtimeImage, true);
        this.addParameter(commandline, CommandLineParameter.INPUT, this.input, true);
        this.addParameter(commandline, CommandLineParameter.INSTALL_DIR, this.installDir);
        this.addParameter(commandline, CommandLineParameter.RESOURCE_DIR, this.resourceDir, true);
        this.addParameter(commandline, CommandLineParameter.VENDOR, this.vendor);
        this.addParameter(commandline, CommandLineParameter.MODULE, this.module);
        this.addParameter(commandline, CommandLineParameter.MAIN_CLASS, this.mainClass);
        this.addParameter(commandline, CommandLineParameter.MAIN_JAR, this.mainJar);
        this.addParameter(commandline, CommandLineParameter.TEMP, this.temp, false);
        this.addParameter(commandline, CommandLineParameter.ICON, this.icon, true);
        this.addParameter(commandline, CommandLineParameter.LICENSE_FILE, this.licenseFile, true);
        this.addParameter(commandline, CommandLineParameter.ABOUT_URL, this.aboutUrl);
        this.addParameter(commandline, CommandLineParameter.APP_IMAGE, this.appImage, true);
        this.addParameter(commandline, CommandLineParameter.LAUNCHER_AS_SERVICE, this.launcherAsService);
        if (this.modulePaths != null) {
            for (File modulePath : this.modulePaths) {
                this.addParameter(commandline, CommandLineParameter.MODULE_PATH, modulePath, true);
            }
        }
        if (this.addModules != null && !this.addModules.isEmpty()) {
            this.addParameter(commandline, CommandLineParameter.ADD_MODULES, String.join((CharSequence)",", this.addModules));
        }
        if (this.jLinkOptions != null && !this.jLinkOptions.isEmpty()) {
            this.addParameter(commandline, CommandLineParameter.JLINK_OPTIONS, String.join((CharSequence)" ", this.jLinkOptions));
        }
        if (this.javaOptions != null) {
            for (String option : this.javaOptions) {
                this.addParameter(commandline, CommandLineParameter.JAVA_OPTIONS, StringUtil.escape(option));
            }
        }
        if (this.arguments != null) {
            for (String arg : this.arguments) {
                this.addParameter(commandline, CommandLineParameter.ARGUMENTS, StringUtil.escape(arg));
            }
        }
        if (this.fileAssociations != null) {
            for (File association : this.fileAssociations) {
                this.addParameter(commandline, CommandLineParameter.FILE_ASSOCIATIONS, association, true);
            }
        }
        if (this.appContentPaths != null) {
            for (File appContent : this.appContentPaths) {
                this.addParameter(commandline, CommandLineParameter.APP_CONTENT, appContent, true);
            }
        }
        if (this.launchers != null) {
            for (Launcher launcher : this.launchers) {
                launcher.validate();
                this.addParameter(commandline, CommandLineParameter.ADD_LAUNCHER, launcher.getName() + "=" + launcher.getFile().getAbsolutePath());
            }
        }
        if (this.additionalOptions != null) {
            for (String option : this.additionalOptions) {
                this.addParameter(commandline, option);
            }
        }
        if (OsUtil.isMac()) {
            this.addParameter(commandline, CommandLineParameter.MAC_PACKAGE_IDENTIFIER, this.macPackageIdentifier);
            this.addParameter(commandline, CommandLineParameter.MAC_PACKAGE_NAME, this.macPackageName);
            this.addParameter(commandline, CommandLineParameter.MAC_PACKAGE_SIGNING_PREFIX, this.macPackageSigningPrefix);
            this.addParameter(commandline, CommandLineParameter.MAC_SIGN, this.macSign);
            this.addParameter(commandline, CommandLineParameter.MAC_SIGNING_KEYCHAIN, this.macSigningKeychain, true);
            this.addParameter(commandline, CommandLineParameter.MAC_SIGNING_KEY_USER_NAME, this.macSigningKeyUserName);
            this.addParameter(commandline, CommandLineParameter.MAC_APP_STORE, this.macAppStore);
            this.addParameter(commandline, CommandLineParameter.MAC_ENTITLEMENTS, this.macEntitlements, true);
            this.addParameter(commandline, CommandLineParameter.MAC_APP_CATEGORY, this.macAppCategory);
            if (this.macDmgContentPaths != null) {
                for (File content : this.macDmgContentPaths) {
                    this.addParameter(commandline, CommandLineParameter.MAC_DMG_CONTENT, content, true);
                }
            }
        } else if (OsUtil.isWindows()) {
            this.addParameter(commandline, CommandLineParameter.WIN_CONSOLE, this.winConsole);
            this.addParameter(commandline, CommandLineParameter.WIN_DIR_CHOOSER, this.winDirChooser);
            this.addParameter(commandline, CommandLineParameter.WIN_HELP_URL, this.winHelpUrl);
            this.addParameter(commandline, CommandLineParameter.WIN_MENU, this.winMenu);
            this.addParameter(commandline, CommandLineParameter.WIN_MENU_GROUP, this.winMenuGroup);
            this.addParameter(commandline, CommandLineParameter.WIN_PER_USER_INSTALL, this.winPerUserInstall);
            this.addParameter(commandline, CommandLineParameter.WIN_SHORTCUT, this.winShortcut);
            this.addParameter(commandline, CommandLineParameter.WIN_SHORTCUT_PROMPT, this.winShortcutPrompt);
            this.addParameter(commandline, CommandLineParameter.WIN_UPDATE_URL, this.winUpdateUrl);
            this.addParameter(commandline, CommandLineParameter.WIN_UPGRADE_UUID, this.winUpgradeUuid);
        } else if (OsUtil.isLinux()) {
            this.addParameter(commandline, CommandLineParameter.LINUX_PACKAGE_NAME, this.linuxPackageName);
            this.addParameter(commandline, CommandLineParameter.LINUX_DEB_MAINTAINER, this.linuxDebMaintainer);
            this.addParameter(commandline, CommandLineParameter.LINUX_MENU_GROUP, this.linuxMenuGroup);
            this.addParameter(commandline, CommandLineParameter.LINUX_PACKAGE_DEPS, this.linuxPackageDeps);
            this.addParameter(commandline, CommandLineParameter.LINUX_RPM_LICENSE_TYPE, this.linuxRpmLicenseType);
            this.addParameter(commandline, CommandLineParameter.LINUX_APP_RELEASE, this.linuxAppRelease);
            this.addParameter(commandline, CommandLineParameter.LINUX_APP_CATEGORY, this.linuxAppCategory);
            this.addParameter(commandline, CommandLineParameter.LINUX_SHORTCUT, this.linuxShortcut);
        }
        return commandline;
    }

    private void addMandatoryParameter(Commandline commandline, CommandLineParameter parameter, String value) throws MojoFailureException {
        if (value == null || value.isEmpty()) {
            throw new MojoFailureException("Mandatory parameter \"" + parameter.getName() + "\" cannot be null or empty");
        }
        this.addParameter(commandline, parameter, value);
    }

    private void addMandatoryParameter(Commandline commandline, CommandLineParameter parameter, File value, boolean checkExistence) throws MojoFailureException {
        if (value == null) {
            throw new MojoFailureException("Mandatory parameter \"" + parameter.getName() + "\" cannot be null or empty");
        }
        this.addParameter(commandline, parameter, value, checkExistence);
    }

    private void addParameter(Commandline commandline, String name, String value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        this.getLog().info((CharSequence)("  " + name + " " + value));
        commandline.createArg().setValue(name);
        commandline.createArg().setValue(value);
    }

    private void addParameter(Commandline commandline, CommandLineParameter parameter, String value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        this.getLog().info((CharSequence)("  " + parameter.getName() + " " + value));
        commandline.createArg().setValue(parameter.getName());
        commandline.createArg().setValue(value);
    }

    private void addParameter(Commandline commandline, CommandLineParameter parameter, File value, boolean checkExistence) throws MojoFailureException {
        if (value == null) {
            return;
        }
        String path = value.getAbsolutePath();
        if (checkExistence && !value.exists()) {
            throw new MojoFailureException("File or directory " + path + " does not exist");
        }
        this.addParameter(commandline, parameter.getName(), path);
    }

    private void addParameter(Commandline commandline, String name) {
        if (name == null || name.isEmpty()) {
            return;
        }
        this.getLog().info((CharSequence)("  " + name));
        commandline.createArg().setValue(name);
    }

    private void addParameter(Commandline commandline, CommandLineParameter parameter, boolean value) {
        if (!value) {
            return;
        }
        this.getLog().info((CharSequence)("  " + parameter.getName()));
        commandline.createArg().setValue(parameter.getName());
    }

    private void addParameter(Commandline commandline, CommandLineParameter parameter, EnumParameter value) {
        if (value == null) {
            return;
        }
        this.addParameter(commandline, parameter, value.getValue());
    }
}

