/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.parserunners;

import org.parboiled.Context;
import org.parboiled.MatchHandler;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.ConsoleSink;
import org.parboiled.common.Preconditions;
import org.parboiled.common.Predicate;
import org.parboiled.common.Predicates;
import org.parboiled.common.Sink;
import org.parboiled.common.Tuple2;
import org.parboiled.matchers.Matcher;
import org.parboiled.parserunners.ReportingParseRunner;
import org.parboiled.support.MatcherPath;
import org.parboiled.support.ParsingResult;
import org.parboiled.support.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracingParseRunner<V>
extends ReportingParseRunner<V>
implements MatchHandler {
    private Predicate<Tuple2<Context<?>, Boolean>> filter;
    private Sink<String> log;
    private MatcherPath lastPath;
    private int line;

    public TracingParseRunner(Rule rule) {
        super(rule);
    }

    public TracingParseRunner<V> withFilter(Predicate<?> filter) {
        this.filter = Preconditions.checkArgNotNull(filter, "filter");
        return this;
    }

    public Predicate<Tuple2<Context<?>, Boolean>> getFilter() {
        if (this.filter == null) {
            this.withFilter(Predicates.alwaysTrue());
        }
        return this.filter;
    }

    public TracingParseRunner<V> withLog(Sink<String> log) {
        this.log = log;
        return this;
    }

    public Sink<String> getLog() {
        if (this.log == null) {
            this.withLog(new ConsoleSink());
        }
        return this.log;
    }

    @Override
    protected ParsingResult<V> runBasicMatch(InputBuffer inputBuffer) {
        this.getLog().receive("Starting new parsing run\n");
        this.lastPath = null;
        MatcherContext rootContext = this.createRootContext(inputBuffer, this, true);
        boolean matched = rootContext.runMatcher();
        return this.createParsingResult(matched, rootContext);
    }

    @Override
    public boolean match(MatcherContext<?> context) {
        Matcher matcher = context.getMatcher();
        boolean matched = matcher.match(context);
        if (this.getFilter().apply(new Tuple2(context, matched))) {
            ++this.line;
            this.print(context, matched);
        }
        return matched;
    }

    private void print(MatcherContext<?> context, boolean matched) {
        MatcherPath prefix;
        Position pos = context.getInputBuffer().getPosition(context.getCurrentIndex());
        MatcherPath path = context.getPath();
        MatcherPath matcherPath = prefix = this.lastPath != null ? path.commonPrefix(this.lastPath) : null;
        if (prefix != null && prefix.length() > 1) {
            this.getLog().receive("..(" + (prefix.length() - 1) + ")../");
        }
        this.getLog().receive(path.toString(prefix != null ? prefix.parent : null));
        String line = context.getInputBuffer().extractLine(pos.line);
        this.getLog().receive(", " + (matched ? "matched" : "failed") + ", cursor at " + pos.line + ':' + pos.column + " after \"" + line.substring(0, Math.min(line.length(), pos.column - 1)) + "\"\n");
        this.lastPath = path;
    }
}

