/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.picketlink.idm.config.AbstractIdentityStoreConfiguration;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.credential.handler.CredentialHandler;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.spi.ContextInitializer;

public class JDBCIdentityStoreConfiguration
extends AbstractIdentityStoreConfiguration {
    private DataSource dataSource;
    private Map<String, Class<?>> customClassMapping = new HashMap();

    protected JDBCIdentityStoreConfiguration(String jndiName, Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> supportedTypes, Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> unsupportedTypes, List<ContextInitializer> contextInitializers, Map<String, Object> credentialHandlerProperties, Set<Class<? extends CredentialHandler>> credentialHandlers, boolean supportsAttribute, boolean supportsCredential, boolean supportsPermissions) {
        super(supportedTypes, unsupportedTypes, contextInitializers, credentialHandlerProperties, credentialHandlers, supportsAttribute, supportsCredential, supportsPermissions);
        try {
            InitialContext initContext = new InitialContext();
            Context envContext = (Context)initContext.lookup("java:comp/env");
            this.dataSource = (DataSource)envContext.lookup(jndiName);
            if (this.dataSource == null) {
                throw new RuntimeException("Null datasource");
            }
        }
        catch (NamingException e) {
            throw new RuntimeException("JDBC initialization error", e);
        }
    }

    protected JDBCIdentityStoreConfiguration(Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> supportedTypes, Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> unsupportedTypes, List<ContextInitializer> contextInitializers, Map<String, Object> credentialHandlerProperties, Set<Class<? extends CredentialHandler>> credentialHandlers, boolean supportsAttribute, boolean supportsCredential, boolean supportsPermissions) {
        super(supportedTypes, unsupportedTypes, contextInitializers, credentialHandlerProperties, credentialHandlers, supportsAttribute, supportsCredential, supportsPermissions);
    }

    protected void initConfig() {
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public JDBCIdentityStoreConfiguration setDataSource(DataSource ds) {
        this.dataSource = ds;
        return this;
    }

    public Map<String, Class<?>> getCustomClassMapping() {
        return Collections.unmodifiableMap(this.customClassMapping);
    }

    public void setCustomClassMapping(Map<String, Class<?>> customMap) {
        this.customClassMapping.putAll(customMap);
    }

    public void map(String key, Class<?> value) {
        this.customClassMapping.put(key, value);
    }
}

