/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.handler;

import java.util.Date;
import java.util.List;
import org.picketlink.common.util.Base64;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.credential.Digest;
import org.picketlink.idm.credential.DigestCredentials;
import org.picketlink.idm.credential.handler.AbstractCredentialHandler;
import org.picketlink.idm.credential.handler.annotations.SupportsCredentials;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.credential.storage.DigestCredentialStorage;
import org.picketlink.idm.credential.util.CredentialUtils;
import org.picketlink.idm.credential.util.DigestUtil;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.basic.Agent;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;

@SupportsCredentials(credentialClass={DigestCredentials.class, Digest.class}, credentialStorage=DigestCredentialStorage.class)
public class DigestCredentialHandler<S, V, U>
extends AbstractCredentialHandler<CredentialStore<?>, DigestCredentials, Digest> {
    @Override
    protected Account getAccount(IdentityContext context, DigestCredentials credentials) {
        return this.getAccount(context, credentials.getDigest().getUsername());
    }

    @Override
    protected CredentialStorage getCredentialStorage(IdentityContext context, Account account, DigestCredentials credentials, CredentialStore<?> store) {
        List<DigestCredentialStorage> storages = store.retrieveCredentials(context, account, DigestCredentialStorage.class);
        for (DigestCredentialStorage storage : storages) {
            if (!storage.getRealm().equals(credentials.getDigest().getRealm()) || !CredentialUtils.isCurrentCredential(storage)) continue;
            return storage;
        }
        return null;
    }

    @Override
    protected boolean validateCredential(CredentialStorage credentialStorage, DigestCredentials credentials) {
        DigestCredentialStorage currentCredential = (DigestCredentialStorage)credentialStorage;
        Digest digest = credentials.getDigest();
        if (currentCredential != null) {
            String providedDigest = digest.getDigest();
            String expectedDigest = null;
            if (digest.getMethod() != null && digest.getUri() != null) {
                byte[] storedHA1 = currentCredential.getHa1();
                byte[] ha2 = DigestUtil.calculateA2(digest.getMethod(), digest.getUri());
                expectedDigest = DigestUtil.calculateDigest(digest, storedHA1, ha2);
            } else {
                expectedDigest = String.valueOf(Base64.encodeBytes((byte[])currentCredential.getHa1()));
            }
            return expectedDigest.equals(providedDigest);
        }
        return false;
    }

    @Override
    public void update(IdentityContext context, Account account, Digest digest, CredentialStore<?> store, Date effectiveDate, Date expiryDate) {
        if (StringUtil.isNullOrEmpty((String)digest.getRealm())) {
            throw IDMMessages.MESSAGES.credentialDigestInvalidRealm();
        }
        if (StringUtil.isNullOrEmpty((String)digest.getPassword())) {
            throw IDMMessages.MESSAGES.credentialInvalidPassword();
        }
        Agent agent = (Agent)account;
        byte[] ha1 = DigestUtil.calculateA1(agent.getLoginName(), digest.getRealm(), digest.getPassword().toCharArray());
        DigestCredentialStorage storage = new DigestCredentialStorage(ha1, digest.getRealm());
        if (effectiveDate != null) {
            storage.setEffectiveDate(effectiveDate);
        }
        storage.setExpiryDate(expiryDate);
        store.storeCredential(context, account, storage);
    }
}

