/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.picketlink.idm.IDMLogger;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.FileIdentityStoreConfiguration;
import org.picketlink.idm.file.internal.FileAttribute;
import org.picketlink.idm.file.internal.FileAttributedType;
import org.picketlink.idm.file.internal.FilePartition;
import org.picketlink.idm.file.internal.FileRelationship;
import org.picketlink.idm.file.internal.FileUtils;

public class FileDataSource {
    private static final int FLUSH_BYTE_BUFFER = 1024;
    private static final String DEFAULT_WORKING_DIR = System.getProperty("java.io.tmpdir", File.separator + "tmp") + File.separator + "pl-idm";
    private static final String PARTITIONS_FILE_NAME = "pl-idm-partitions.db";
    private static final String IDENTITY_TYPES__FILE_NAME = "pl-idm-identity-types.db";
    private static final String ATTRIBUTED_TYPES__FILE_NAME = "pl-idm-attributed-types.db";
    private static final String ATTRIBUTES_FILE_NAME = "pl-idm-attributes.db";
    private static final String RELATIONSHIPS_FILE_NAME = "pl-idm-relationships.db";
    private static final String CREDENTIALS_FILE_NAME = "pl-idm-credentials.db";
    private final FileIdentityStoreConfiguration configuration;
    private Map<String, FilePartition> partitions;
    private Map<String, Map<String, FileRelationship>> relationships;
    private Map<String, FileAttribute> attributes;
    private Map<String, FileAttributedType> attributedTypes;
    private ExecutorService executorService;
    private final Map<String, FileChannel> streams = new ConcurrentHashMap<String, FileChannel>();

    FileDataSource(FileIdentityStoreConfiguration configuration) {
        this.configuration = configuration;
        this.init();
    }

    Map<String, FilePartition> getPartitions() {
        return this.partitions;
    }

    Map<String, Map<String, FileRelationship>> getRelationships() {
        return this.relationships;
    }

    Map<String, FileAttribute> getAttributes() {
        return this.attributes;
    }

    public Map<String, FileAttributedType> getAttributedTypes() {
        return this.attributedTypes;
    }

    void flushPartitions() {
        this.flush(PARTITIONS_FILE_NAME, this.getPartitions());
    }

    void flushPartitions(FilePartition partition) {
        this.initPartition(partition.getId());
        this.flush(PARTITIONS_FILE_NAME, this.getPartitions());
    }

    void flushAttributedTypes(FilePartition partition) {
        this.flush(partition, IDENTITY_TYPES__FILE_NAME, partition.getIdentityTypes());
    }

    void flushRelationships() {
        this.flush(RELATIONSHIPS_FILE_NAME, this.getRelationships());
    }

    void flushAttributes() {
        this.flush(ATTRIBUTES_FILE_NAME, this.getAttributes());
    }

    void flushAttributedTypes() {
        this.flush(ATTRIBUTED_TYPES__FILE_NAME, this.getAttributedTypes());
    }

    void flushCredentials(FilePartition partition) {
        FilePartition filePartition = this.getPartitions().get(partition.getId());
        this.flush(filePartition, CREDENTIALS_FILE_NAME, filePartition.getCredentials());
    }

    private void initWorkingDirectory() {
        String workingDir = this.getWorkingDir();
        File workingDirectoryFile = new File(workingDir);
        if (workingDirectoryFile.exists() && this.configuration.isAlwaysCreateFiles()) {
            IDMLogger.LOGGER.fileConfigAlwaysCreateWorkingDir(workingDirectoryFile.getPath());
            FileUtils.delete(workingDirectoryFile);
        }
        workingDirectoryFile.mkdirs();
        IDMLogger.LOGGER.fileConfigUsingWorkingDir(workingDirectoryFile.getPath());
    }

    private void init() {
        this.initWorkingDirectory();
        File partitionsFile = FileUtils.createFileIfNotExists(this.getWorkingDirFile(PARTITIONS_FILE_NAME));
        this.loadPartitions(partitionsFile);
        ConcurrentHashMap relationships = (ConcurrentHashMap)FileUtils.readObject(FileUtils.createFileIfNotExists(this.getWorkingDirFile(RELATIONSHIPS_FILE_NAME)));
        if (relationships == null) {
            relationships = new ConcurrentHashMap();
        }
        this.relationships = relationships;
        ConcurrentHashMap attributes = (ConcurrentHashMap)FileUtils.readObject(FileUtils.createFileIfNotExists(this.getWorkingDirFile(ATTRIBUTES_FILE_NAME)));
        if (attributes == null) {
            attributes = new ConcurrentHashMap();
        }
        this.attributes = attributes;
        ConcurrentHashMap attrubtedTypes = (ConcurrentHashMap)FileUtils.readObject(FileUtils.createFileIfNotExists(this.getWorkingDirFile(ATTRIBUTED_TYPES__FILE_NAME)));
        if (attrubtedTypes == null) {
            attrubtedTypes = new ConcurrentHashMap();
        }
        this.attributedTypes = attrubtedTypes;
        if (this.configuration.isAsyncWrite()) {
            IDMLogger.LOGGER.debugf("Async write enabled. Using thread pool of size %s", (Object)this.configuration.getAsyncThreadPool());
            this.executorService = Executors.newFixedThreadPool(this.configuration.getAsyncThreadPool());
        }
    }

    private void loadPartitions(File partitionsFile) {
        this.partitions = (Map)FileUtils.readObject(partitionsFile);
        if (this.partitions == null) {
            IDMLogger.LOGGER.debugf("No partitions to load from %s", (Object)partitionsFile.getPath());
            this.partitions = new ConcurrentHashMap<String, FilePartition>();
        } else {
            IDMLogger.LOGGER.infof("Loading %s Partitions from %s", (Object)this.partitions.size(), (Object)partitionsFile.getPath());
            Set<Map.Entry<String, FilePartition>> entrySet = this.partitions.entrySet();
            for (Map.Entry<String, FilePartition> entry : entrySet) {
                this.initPartition(entry.getKey());
            }
        }
    }

    private void initPartition(String partitionId) {
        FilePartition filePartition = this.partitions.get(partitionId);
        IDMLogger.LOGGER.debugf("Initializing Partition [%s] with id [%s].", (Object)filePartition.getId(), (Object)partitionId);
        File agentsFile = FileUtils.createFileIfNotExists(this.getWorkingDirFile(partitionId + File.separator + IDENTITY_TYPES__FILE_NAME));
        ConcurrentHashMap identityTypes = (ConcurrentHashMap)FileUtils.readObject(agentsFile);
        if (identityTypes == null) {
            identityTypes = new ConcurrentHashMap();
        }
        filePartition.setIdentityTypes(identityTypes);
        IDMLogger.LOGGER.debugf("Loaded Agents for Partition [%s].", (Object)filePartition.getId());
        File credentialsFile = FileUtils.createFileIfNotExists(this.getWorkingDirFile(partitionId + File.separator + CREDENTIALS_FILE_NAME));
        ConcurrentHashMap credentials = (ConcurrentHashMap)FileUtils.readObject(credentialsFile);
        if (credentials == null) {
            credentials = new ConcurrentHashMap();
        }
        filePartition.setCredentials(credentials);
        IDMLogger.LOGGER.debugf("Loaded Credentials for Partition [%s].", (Object)filePartition.getId());
    }

    private String getWorkingDir() {
        return this.configuration.getWorkingDir();
    }

    private void flush(FilePartition partition, String fileName, Object object) {
        this.flush(partition.getId() + File.separator + fileName, object);
    }

    private void flush(final String fileName, final Object object) {
        if (this.configuration.isAsyncWrite()) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    FileDataSource.this.performFlush(fileName, object);
                }
            });
        } else {
            this.performFlush(fileName, object);
        }
    }

    private void performFlush(String fileName, Object object) {
        ObjectOutputStream oos = null;
        ByteArrayOutputStream bos = null;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(this.getWorkingDir() + File.separator + fileName, "rw");
            FileChannel channel = randomAccessFile.getChannel();
            bos = new ByteArrayOutputStream(1024);
            oos = new ObjectOutputStream(bos);
            oos.writeObject(object);
            channel.write(ByteBuffer.wrap(bos.toByteArray()));
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error flushing changes to file system.", (Throwable)e);
        }
        finally {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException e) {}
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception e) {}
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private File getWorkingDirFile(String name) {
        return new File(this.getWorkingDir() + File.separator + name);
    }
}

