/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.properties.query.PropertyQuery;
import org.picketlink.common.properties.query.TypedPropertyCriteria;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.FileIdentityStoreConfiguration;
import org.picketlink.idm.credential.handler.DigestCredentialHandler;
import org.picketlink.idm.credential.handler.PasswordCredentialHandler;
import org.picketlink.idm.credential.handler.TOTPCredentialHandler;
import org.picketlink.idm.credential.handler.X509CertificateCredentialHandler;
import org.picketlink.idm.credential.handler.annotations.CredentialHandlers;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.credential.util.CredentialUtils;
import org.picketlink.idm.file.internal.FileAttribute;
import org.picketlink.idm.file.internal.FileAttributedType;
import org.picketlink.idm.file.internal.FileCredentialStorage;
import org.picketlink.idm.file.internal.FileDataSource;
import org.picketlink.idm.file.internal.FileIdentityType;
import org.picketlink.idm.file.internal.FilePartition;
import org.picketlink.idm.file.internal.FileRelationship;
import org.picketlink.idm.file.internal.FileSortingComparator;
import org.picketlink.idm.internal.AbstractIdentityStore;
import org.picketlink.idm.internal.RelationshipReference;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.annotation.AttributeProperty;
import org.picketlink.idm.query.AttributeParameter;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.query.RelationshipQueryParameter;
import org.picketlink.idm.spi.AttributeStore;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.PartitionStore;

@CredentialHandlers(value={PasswordCredentialHandler.class, X509CertificateCredentialHandler.class, DigestCredentialHandler.class, TOTPCredentialHandler.class})
public class FileIdentityStore
extends AbstractIdentityStore<FileIdentityStoreConfiguration>
implements PartitionStore<FileIdentityStoreConfiguration>,
CredentialStore<FileIdentityStoreConfiguration>,
AttributeStore<FileIdentityStoreConfiguration> {
    private FileDataSource fileDataSource;

    @Override
    public void setup(FileIdentityStoreConfiguration configuration) {
        super.setup(configuration);
        this.fileDataSource = new FileDataSource(configuration);
    }

    @Override
    public void addAttributedType(IdentityContext context, AttributedType attributedType) {
        AttributedType clonedAttributedType = this.cloneAttributedType(context, attributedType);
        if (IdentityType.class.isInstance(clonedAttributedType)) {
            this.storeIdentityType(context, (IdentityType)clonedAttributedType);
        } else if (Relationship.class.isInstance(clonedAttributedType)) {
            this.storeRelationshipType((Relationship)clonedAttributedType);
        } else {
            this.fileDataSource.getAttributedTypes().put(attributedType.getId(), new FileAttributedType(attributedType));
        }
    }

    @Override
    public void updateAttributedType(IdentityContext context, AttributedType attributedType) {
        AttributedType updatedAttributedType = this.cloneAttributedType(context, attributedType);
        if (IdentityType.class.isInstance(attributedType)) {
            this.storeIdentityType(context, (IdentityType)updatedAttributedType);
        } else if (Relationship.class.isInstance(attributedType)) {
            this.storeRelationshipType((Relationship)updatedAttributedType);
        }
    }

    @Override
    public void removeAttributedType(IdentityContext context, AttributedType attributedType) {
        if (IdentityType.class.isInstance(attributedType)) {
            IdentityType identityType = (IdentityType)attributedType;
            this.removeRelationships(identityType);
            this.removeCredentials(identityType);
            Partition partition = identityType.getPartition();
            FilePartition filePartition = this.resolve(partition.getClass(), partition.getName());
            Map<String, FileIdentityType> identityTypes = filePartition.getIdentityTypes().get(attributedType.getClass().getName());
            if (identityTypes != null) {
                identityTypes.remove(identityType.getId());
            }
            this.fileDataSource.flushAttributedTypes(filePartition);
        } else if (Relationship.class.isInstance(attributedType)) {
            Map<String, FileRelationship> fileRelationships = this.fileDataSource.getRelationships().get(attributedType.getClass().getName());
            for (FileRelationship fileRelationship : new HashMap<String, FileRelationship>(fileRelationships).values()) {
                if (!fileRelationship.getId().equals(attributedType.getId())) continue;
                fileRelationships.remove(fileRelationship.getId());
            }
            this.fileDataSource.flushRelationships();
        } else {
            this.fileDataSource.getAttributedTypes().remove(attributedType.getId());
            this.fileDataSource.flushAttributedTypes();
        }
    }

    public void add(IdentityContext identityContext, Partition partition, String configurationName) {
        try {
            partition.setId(identityContext.getIdGenerator().generate());
            FilePartition filePartition = new FilePartition(this.cloneAttributedType(identityContext, partition), configurationName);
            this.fileDataSource.getPartitions().put(filePartition.getId(), filePartition);
            this.fileDataSource.flushPartitions(filePartition);
        }
        catch (Exception e) {
            partition.setId(null);
            throw IDMMessages.MESSAGES.attributedTypeAddFailed((AttributedType)partition, (Throwable)e);
        }
    }

    public void update(IdentityContext identityContext, Partition partition) {
        try {
            FilePartition filePartition = this.resolve(partition.getClass(), partition.getName());
            this.fileDataSource.getPartitions().put(partition.getId(), new FilePartition(this.cloneAttributedType(identityContext, partition), filePartition.getConfigurationName()));
            this.fileDataSource.flushPartitions();
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.attributedTypeUpdateFailed((AttributedType)partition, (Throwable)e);
        }
    }

    public void remove(IdentityContext identityContext, Partition partition) {
        try {
            FilePartition filePartition = this.resolve(partition.getClass(), partition.getName());
            this.fileDataSource.getPartitions().remove(filePartition.getId());
            this.fileDataSource.flushPartitions();
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.attributedTypeRemoveFailed((AttributedType)partition, (Throwable)e);
        }
    }

    public <P extends Partition> P get(IdentityContext identityContext, Class<P> partitionClass, String name) {
        try {
            return (P)this.cloneAttributedType(identityContext, (Partition)this.resolve(partitionClass, name).getEntry());
        }
        catch (IdentityManagementException ime) {
            return null;
        }
    }

    public <P extends Partition> P lookupById(IdentityContext context, Class<P> partitionClass, String id) {
        FilePartition filePartition = this.fileDataSource.getPartitions().get(id);
        if (filePartition != null) {
            return (P)((Partition)this.cloneAttributedType(context, (AttributedType)filePartition.getEntry()));
        }
        return null;
    }

    public String getConfigurationName(IdentityContext identityContext, Partition partition) {
        return this.resolve(partition.getClass(), partition.getName()).getConfigurationName();
    }

    public void storeCredential(IdentityContext context, Account account, CredentialStorage storage) {
        List<FileCredentialStorage> credentials = this.getCredentials(account, storage.getClass());
        credentials.add(new FileCredentialStorage(storage));
        Partition partition = context.getPartition();
        this.fileDataSource.flushCredentials(this.resolve(partition.getClass(), partition.getName()));
    }

    public <T extends CredentialStorage> T retrieveCurrentCredential(IdentityContext context, Account account, Class<T> storageClass) {
        return (T)CredentialUtils.getCurrentCredential((IdentityContext)context, (Account)account, (CredentialStore)this, storageClass);
    }

    public <T extends CredentialStorage> List<T> retrieveCredentials(IdentityContext context, Account account, Class<T> storageClass) {
        ArrayList<CredentialStorage> storedCredentials = new ArrayList<CredentialStorage>();
        List<FileCredentialStorage> credentials = this.getCredentials(account, storageClass);
        for (FileCredentialStorage fileCredentialStorage : credentials) {
            storedCredentials.add((CredentialStorage)fileCredentialStorage.getEntry());
        }
        Collections.sort(storedCredentials, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o2.getEffectiveDate().compareTo(o1.getEffectiveDate());
            }
        });
        return storedCredentials;
    }

    public <V extends IdentityType> List<V> fetchQueryResults(IdentityContext context, IdentityQuery<V> identityQuery) {
        Object[] partitionParameters = identityQuery.getParameter(IdentityType.PARTITION);
        Partition partition = null;
        partition = partitionParameters == null ? context.getPartition() : (Partition)partitionParameters[0];
        FilePartition filePartition = this.resolve(partition.getClass(), partition.getName());
        List<Object> result = new ArrayList<IdentityType>();
        Object[] ids = identityQuery.getParameter(IdentityType.ID);
        Map<String, Map<String, FileIdentityType>> identityTypes = filePartition.getIdentityTypes();
        Map<Object, Object> typedIdentityTypes = null;
        if (IdentityType.class.equals((Object)identityQuery.getIdentityType())) {
            typedIdentityTypes = new HashMap();
            for (String string : identityTypes.keySet()) {
                typedIdentityTypes.putAll(identityTypes.get(string));
            }
        } else {
            typedIdentityTypes = identityTypes.get(identityQuery.getIdentityType().getName());
        }
        if (typedIdentityTypes == null) {
            return result;
        }
        if (ids != null && ids.length > 0) {
            FileIdentityType fileAttributedType;
            if (ids[0] != null && (fileAttributedType = (FileIdentityType)typedIdentityTypes.get(ids[0])) != null) {
                result.add(this.cloneAttributedType(context, (IdentityType)fileAttributedType.getEntry()));
            }
        } else {
            for (FileIdentityType fileIdentityType : typedIdentityTypes.values()) {
                IdentityType storedEntry = (IdentityType)fileIdentityType.getEntry();
                boolean match = identityQuery.getParameters().isEmpty();
                for (Map.Entry entry : identityQuery.getParameters().entrySet()) {
                    QueryParameter queryParameter = (QueryParameter)entry.getKey();
                    if (!AttributeParameter.class.isInstance(queryParameter)) continue;
                    AttributeParameter attributeParameter = (AttributeParameter)queryParameter;
                    String attributeParameterName = attributeParameter.getName();
                    Property property = PropertyQueries.createQuery((Class)identityQuery.getIdentityType()).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{attributeParameterName})).getFirstResult();
                    Object[] parameterValues = (Object[])entry.getValue();
                    if (property != null && property.getName().equals(attributeParameterName)) {
                        Serializable storedValue = (Serializable)property.getValue((Object)storedEntry);
                        if (storedValue != null && !storedValue.getClass().isArray() && !Collection.class.isInstance(storedValue)) {
                            match = queryParameter.equals(IdentityType.CREATED_BEFORE) || queryParameter.equals(IdentityType.EXPIRY_BEFORE) ? storedValue != null && ((Date)storedValue).compareTo((Date)parameterValues[0]) <= 0 : (queryParameter.equals(IdentityType.CREATED_AFTER) || queryParameter.equals(IdentityType.EXPIRY_AFTER) ? storedValue != null && ((Date)storedValue).compareTo((Date)parameterValues[0]) >= 0 : storedValue != null && storedValue.equals(parameterValues[0]));
                        }
                    } else {
                        this.loadAttributes(context, (AttributedType)storedEntry);
                        match = this.matchAttribute((AttributedType)storedEntry, attributeParameterName, parameterValues);
                    }
                    if (match) continue;
                    break;
                }
                if (!match) continue;
                result.add(this.cloneAttributedType(context, storedEntry));
            }
        }
        Collections.sort(result, new FileSortingComparator<V>(identityQuery));
        if (identityQuery.getLimit() > 0) {
            int numberOfItems = Math.min(identityQuery.getLimit(), result.size() - identityQuery.getOffset());
            result = result.subList(identityQuery.getOffset(), identityQuery.getOffset() + numberOfItems);
        }
        return result;
    }

    public <V extends IdentityType> int countQueryResults(IdentityContext context, IdentityQuery<V> identityQuery) {
        int limit = identityQuery.getLimit();
        int offset = identityQuery.getOffset();
        identityQuery.setLimit(0);
        identityQuery.setOffset(0);
        int resultCount = identityQuery.getResultList().size();
        identityQuery.setLimit(limit);
        identityQuery.setOffset(offset);
        return resultCount;
    }

    public <T extends Relationship> List<T> fetchQueryResults(IdentityContext context, RelationshipQuery<T> query) {
        ArrayList<Relationship> result = new ArrayList<Relationship>();
        Class typeToSearch = query.getRelationshipClass();
        Object[] idParameter = query.getParameter(Relationship.ID);
        if (idParameter != null && idParameter.length > 0) {
            String id = idParameter[0].toString();
            for (Map<String, FileRelationship> partitionRelationships : this.fileDataSource.getRelationships().values()) {
                FileRelationship storedRelationship = partitionRelationships.get(id);
                if (storedRelationship == null || !typeToSearch.isAssignableFrom(((Relationship)storedRelationship.getEntry()).getClass())) continue;
                result.add((Relationship)this.cloneAttributedType(context, (AttributedType)storedRelationship.getEntry()));
                return result;
            }
        } else {
            ArrayList<FileRelationship> relationships = new ArrayList<FileRelationship>();
            if (Relationship.class.equals((Object)typeToSearch)) {
                for (Map<String, FileRelationship> partitionRelationships : this.fileDataSource.getRelationships().values()) {
                    relationships.addAll(partitionRelationships.values());
                }
            } else {
                Map<String, FileRelationship> typedRelationship = this.fileDataSource.getRelationships().get(typeToSearch.getName());
                if (typedRelationship != null) {
                    relationships.addAll(typedRelationship.values());
                }
            }
            for (FileRelationship storedRelationship : relationships) {
                boolean match = query.getParameters().isEmpty();
                if (typeToSearch.isInstance(storedRelationship.getEntry())) {
                    for (Map.Entry entry : query.getParameters().entrySet()) {
                        IdentityType identityType;
                        QueryParameter queryParameter = (QueryParameter)entry.getKey();
                        Object[] values = (Object[])entry.getValue();
                        if (Relationship.IDENTITY.equals(queryParameter)) {
                            int valuesMathCount = values.length;
                            for (Object object : values) {
                                identityType = (IdentityType)object;
                                if (!storedRelationship.hasIdentityType(identityType)) continue;
                                --valuesMathCount;
                            }
                            match = valuesMathCount <= 0;
                        } else if (queryParameter instanceof RelationshipQueryParameter) {
                            RelationshipQueryParameter identityTypeParameter = (RelationshipQueryParameter)queryParameter;
                            for (Object value : values) {
                                identityType = (IdentityType)value;
                                String identityTypeId = storedRelationship.getIdentityTypeId(identityTypeParameter.getName());
                                match = identityTypeId != null && identityTypeId.equals(RelationshipReference.formatId(identityType));
                            }
                        } else if (AttributeParameter.class.isInstance(queryParameter) && values != null) {
                            AttributeParameter attributeParameter = (AttributeParameter)queryParameter;
                            Property property = PropertyQueries.createQuery((Class)query.getRelationshipClass()).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{attributeParameter.getName()})).getFirstResult();
                            if (property != null) {
                                Serializable value = (Serializable)property.getValue(storedRelationship.getEntry());
                                if (value != null) {
                                    match = value.equals(values[0]);
                                }
                            } else {
                                this.loadAttributes(context, (AttributedType)storedRelationship.getEntry());
                                match = this.matchAttribute((AttributedType)storedRelationship.getEntry(), attributeParameter.getName(), values);
                            }
                        }
                        if (match) continue;
                        break;
                    }
                }
                if (!match) continue;
                Relationship relationship = (Relationship)this.cloneAttributedType(context, (AttributedType)storedRelationship.getEntry());
                List properties = PropertyQueries.createQuery((Class)query.getRelationshipClass()).addCriteria((PropertyCriteria)new TypedPropertyCriteria(IdentityType.class, TypedPropertyCriteria.MatchOption.SUB_TYPE)).getResultList();
                RelationshipReference reference = new RelationshipReference(relationship);
                for (Property property : properties) {
                    reference.addIdentityTypeReference(property.getName(), storedRelationship.getIdentityTypeId(property.getName()));
                }
                result.add(reference);
            }
        }
        return result;
    }

    public <V extends Relationship> int countQueryResults(IdentityContext context, RelationshipQuery<V> query) {
        return this.fetchQueryResults(context, query).size();
    }

    public void setAttribute(IdentityContext context, AttributedType type, Attribute<? extends Serializable> attribute) {
        FileAttribute fileAttribute = this.getFileAttribute(type);
        if (fileAttribute == null) {
            fileAttribute = new FileAttribute(type);
        }
        this.removeAttribute(context, type, attribute.getName());
        ((Collection)fileAttribute.getEntry()).add(attribute);
        this.fileDataSource.getAttributes().put(type.getId(), fileAttribute);
        this.fileDataSource.flushAttributes();
    }

    private FileAttribute getFileAttribute(AttributedType type) {
        return this.fileDataSource.getAttributes().get(type.getId());
    }

    public <V extends Serializable> Attribute<V> getAttribute(IdentityContext context, AttributedType type, String attributeName) {
        FileAttribute fileAttribute = this.getFileAttribute(type);
        if (fileAttribute != null) {
            for (Attribute attribute : (Collection)fileAttribute.getEntry()) {
                if (!attribute.getName().equals(attributeName)) continue;
                return attribute;
            }
        }
        return null;
    }

    public void loadAttributes(IdentityContext context, AttributedType attributedType) {
        FileAttribute fileAttribute = this.getFileAttribute(attributedType);
        if (fileAttribute != null) {
            for (Attribute attribute : (Collection)fileAttribute.getEntry()) {
                attributedType.setAttribute(attribute);
            }
        }
    }

    public void removeAttribute(IdentityContext context, AttributedType type, String attributeName) {
        FileAttribute fileAttribute = this.getFileAttribute(type);
        if (fileAttribute != null) {
            for (Attribute attribute : new ArrayList((Collection)fileAttribute.getEntry())) {
                if (!attribute.getName().equals(attributeName)) continue;
                ((Collection)fileAttribute.getEntry()).remove(attribute);
            }
        }
        this.fileDataSource.flushAttributes();
    }

    <T extends Relationship> T convertToRelationship(IdentityContext context, FileRelationship fileRelationship) {
        return (T)((Relationship)this.cloneAttributedType(context, (AttributedType)fileRelationship.getEntry()));
    }

    private FilePartition resolve(Class<? extends Partition> type, String name) throws IdentityManagementException {
        for (FilePartition filePartition : this.fileDataSource.getPartitions().values()) {
            Partition storedPartition = (Partition)filePartition.getEntry();
            if (!storedPartition.getClass().equals(type) || !storedPartition.getName().equals(name)) continue;
            return filePartition;
        }
        throw IDMMessages.MESSAGES.partitionNotFoundWithName(type, name);
    }

    private <T extends AttributedType> T cloneAttributedType(IdentityContext context, T attributedType) {
        AttributedType clonedAttributedType = null;
        try {
            clonedAttributedType = (AttributedType)attributedType.getClass().newInstance();
        }
        catch (Exception e) {
            IDMMessages.MESSAGES.instantiationError(attributedType.getClass(), (Throwable)e);
        }
        clonedAttributedType.setId(attributedType.getId());
        PropertyQuery query = PropertyQueries.createQuery(attributedType.getClass());
        query.addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(AttributeProperty.class));
        for (Property property : query.getResultList()) {
            property.setValue((Object)clonedAttributedType, property.getValue(attributedType));
        }
        if (IdentityType.class.isInstance(attributedType)) {
            IdentityType identityType = (IdentityType)attributedType;
            identityType.setPartition(context.getPartition());
            IdentityType clonedIdentityType = (IdentityType)clonedAttributedType;
            clonedIdentityType.setPartition(identityType.getPartition());
            clonedIdentityType.setExpirationDate(identityType.getExpirationDate());
            clonedIdentityType.setCreatedDate(identityType.getCreatedDate());
            clonedIdentityType.setEnabled(identityType.isEnabled());
        } else if (Relationship.class.isInstance(attributedType)) {
            Relationship relationship = (Relationship)attributedType;
            Relationship clonedRelationship = (Relationship)clonedAttributedType;
            PropertyQuery identityPropertiesQuery = PropertyQueries.createQuery(relationship.getClass());
            identityPropertiesQuery.addCriteria((PropertyCriteria)new TypedPropertyCriteria(IdentityType.class, TypedPropertyCriteria.MatchOption.SUB_TYPE));
            for (Property property : identityPropertiesQuery.getResultList()) {
                property.setValue((Object)clonedRelationship, property.getValue((Object)relationship));
            }
        }
        return (T)clonedAttributedType;
    }

    private void removeRelationships(IdentityType identityType) {
        Map<String, Map<String, FileRelationship>> relationships = this.fileDataSource.getRelationships();
        for (Map<String, FileRelationship> relationshipsType : relationships.values()) {
            for (FileRelationship fileRelationship : new HashMap<String, FileRelationship>(relationshipsType).values()) {
                if (!fileRelationship.hasIdentityType(identityType)) continue;
                relationshipsType.remove(fileRelationship.getId());
            }
        }
        this.fileDataSource.flushRelationships();
    }

    private List<FileCredentialStorage> getCredentials(Account account, Class<? extends CredentialStorage> storageType) {
        List<FileCredentialStorage> credentials;
        Partition partition = account.getPartition();
        FilePartition filePartition = this.resolve(partition.getClass(), partition.getName());
        Map<String, List<FileCredentialStorage>> agentCredentials = filePartition.getCredentials().get(account.getId());
        if (agentCredentials == null) {
            agentCredentials = new HashMap<String, List<FileCredentialStorage>>();
            this.fileDataSource.getPartitions().get(partition.getId()).getCredentials().put(account.getId(), agentCredentials);
        }
        if ((credentials = agentCredentials.get(storageType.getName())) == null) {
            credentials = new ArrayList<FileCredentialStorage>();
        }
        agentCredentials.put(storageType.getName(), credentials);
        return credentials;
    }

    private void storeRelationshipType(Relationship relationship) {
        String type = relationship.getClass().getName();
        Map<String, FileRelationship> storedRelationships = this.fileDataSource.getRelationships().get(type);
        if (storedRelationships == null) {
            storedRelationships = new ConcurrentHashMap<String, FileRelationship>();
            this.fileDataSource.getRelationships().put(type, storedRelationships);
        }
        storedRelationships.put(relationship.getId(), new FileRelationship(relationship));
        this.fileDataSource.flushRelationships();
    }

    private void storeIdentityType(IdentityContext context, IdentityType identityType) {
        FilePartition filePartition = this.resolve(context.getPartition().getClass(), context.getPartition().getName());
        Map<String, FileIdentityType> identityTypes = filePartition.getIdentityTypes().get(identityType.getClass().getName());
        if (identityTypes == null) {
            identityTypes = new ConcurrentHashMap<String, FileIdentityType>();
            filePartition.getIdentityTypes().put(identityType.getClass().getName(), identityTypes);
        }
        identityTypes.put(identityType.getId(), new FileIdentityType(identityType));
        this.fileDataSource.flushAttributedTypes(filePartition);
    }

    private boolean matchAttribute(AttributedType attributedType, String parameterName, Object[] valuesToCompare) {
        Attribute userAttribute = attributedType.getAttribute(parameterName);
        Serializable userAttributeValue = null;
        if (userAttribute != null) {
            userAttributeValue = userAttribute.getValue();
        }
        if (userAttributeValue != null) {
            int count = valuesToCompare.length;
            for (Object value : valuesToCompare) {
                if (userAttributeValue.getClass().isArray()) {
                    Object[] userValues;
                    for (Object object : userValues = (Object[])userAttributeValue) {
                        if (!object.equals(value)) continue;
                        --count;
                    }
                    continue;
                }
                if (!value.equals(userAttributeValue)) continue;
                --count;
            }
            return count <= 0;
        }
        return false;
    }

    private void removeCredentials(IdentityType identityType) {
        Partition partition = identityType.getPartition();
        FilePartition filePartition = this.resolve(partition.getClass(), partition.getName());
        Map<String, Map<String, List<FileCredentialStorage>>> credentials = filePartition.getCredentials();
        credentials.remove(identityType.getId());
        this.fileDataSource.flushCredentials(filePartition);
    }
}

