/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.util.List;
import org.picketlink.idm.IdGenerator;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.event.EventBridge;
import org.picketlink.idm.internal.AbstractIdentityContext;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.query.internal.DefaultRelationshipQuery;
import org.picketlink.idm.spi.AttributeStore;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.StoreSelector;

public class ContextualRelationshipManager
extends AbstractIdentityContext
implements RelationshipManager {
    private StoreSelector storeSelector;

    public ContextualRelationshipManager(EventBridge eventBridge, IdGenerator idGenerator, StoreSelector storeSelector) {
        super(null, eventBridge, idGenerator);
        this.storeSelector = storeSelector;
    }

    public void add(Relationship relationship) {
        this.storeSelector.getStoreForRelationshipOperation((IdentityContext)this, relationship.getClass(), relationship, IdentityStoreConfiguration.IdentityOperation.create).add((IdentityContext)this, (AttributedType)relationship);
        AttributeStore attributeStore = this.storeSelector.getStoreForAttributeOperation((IdentityContext)this);
        if (attributeStore != null) {
            for (Attribute attribute : relationship.getAttributes()) {
                attributeStore.setAttribute((IdentityContext)this, (AttributedType)relationship, attribute);
            }
        }
    }

    public void update(Relationship relationship) {
        this.storeSelector.getStoreForRelationshipOperation((IdentityContext)this, relationship.getClass(), relationship, IdentityStoreConfiguration.IdentityOperation.update).update((IdentityContext)this, (AttributedType)relationship);
        List result = this.createRelationshipQuery(relationship.getClass()).setParameter(Relationship.ID, new Object[]{relationship.getId()}).getResultList();
        if (!result.isEmpty()) {
            Relationship storedType = (Relationship)result.get(0);
            AttributeStore attributeStore = this.storeSelector.getStoreForAttributeOperation((IdentityContext)this);
            if (attributeStore != null) {
                for (Attribute attribute : storedType.getAttributes()) {
                    if (relationship.getAttribute(attribute.getName()) != null) continue;
                    attributeStore.removeAttribute((IdentityContext)this, (AttributedType)relationship, attribute.getName());
                }
                for (Attribute attribute : relationship.getAttributes()) {
                    attributeStore.setAttribute((IdentityContext)this, (AttributedType)relationship, attribute);
                }
            }
        }
    }

    public void remove(Relationship relationship) {
        List result = this.createRelationshipQuery(relationship.getClass()).setParameter(Relationship.ID, new Object[]{relationship.getId()}).getResultList();
        if (!result.isEmpty()) {
            Relationship storedType = (Relationship)result.get(0);
            AttributeStore attributeStore = this.storeSelector.getStoreForAttributeOperation((IdentityContext)this);
            if (attributeStore != null) {
                for (Attribute attribute : storedType.getAttributes()) {
                    attributeStore.removeAttribute((IdentityContext)this, (AttributedType)storedType, attribute.getName());
                }
            }
        }
        this.storeSelector.getStoreForRelationshipOperation((IdentityContext)this, relationship.getClass(), relationship, IdentityStoreConfiguration.IdentityOperation.delete).remove((IdentityContext)this, (AttributedType)relationship);
    }

    public <T extends Relationship> RelationshipQuery<T> createRelationshipQuery(Class<T> relationshipClass) {
        return new DefaultRelationshipQuery<T>(this, relationshipClass, this.storeSelector);
    }
}

