/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.properties.query.TypedPropertyCriteria;
import org.picketlink.common.util.Base64;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;
import org.picketlink.idm.credential.handler.DigestCredentialHandler;
import org.picketlink.idm.credential.handler.PasswordCredentialHandler;
import org.picketlink.idm.credential.handler.TOTPCredentialHandler;
import org.picketlink.idm.credential.handler.X509CertificateCredentialHandler;
import org.picketlink.idm.credential.handler.annotations.CredentialHandlers;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.internal.AbstractIdentityStore;
import org.picketlink.idm.internal.RelationshipReference;
import org.picketlink.idm.jpa.annotations.AttributeName;
import org.picketlink.idm.jpa.annotations.AttributeValue;
import org.picketlink.idm.jpa.annotations.CredentialClass;
import org.picketlink.idm.jpa.annotations.EffectiveDate;
import org.picketlink.idm.jpa.annotations.Identifier;
import org.picketlink.idm.jpa.annotations.IdentityClass;
import org.picketlink.idm.jpa.annotations.OwnerReference;
import org.picketlink.idm.jpa.annotations.PartitionClass;
import org.picketlink.idm.jpa.annotations.RelationshipClass;
import org.picketlink.idm.jpa.annotations.RelationshipDescriptor;
import org.picketlink.idm.jpa.annotations.RelationshipMember;
import org.picketlink.idm.jpa.annotations.entity.ConfigurationName;
import org.picketlink.idm.jpa.annotations.entity.IdentityManaged;
import org.picketlink.idm.jpa.annotations.entity.ManagedCredential;
import org.picketlink.idm.jpa.internal.mappers.EntityMapper;
import org.picketlink.idm.jpa.internal.mappers.EntityMapping;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.query.AttributeParameter;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.query.RelationshipQueryParameter;
import org.picketlink.idm.spi.AttributeStore;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.PartitionStore;

@CredentialHandlers(value={PasswordCredentialHandler.class, X509CertificateCredentialHandler.class, DigestCredentialHandler.class, TOTPCredentialHandler.class})
public class JPAIdentityStore
extends AbstractIdentityStore<JPAIdentityStoreConfiguration>
implements CredentialStore<JPAIdentityStoreConfiguration>,
PartitionStore<JPAIdentityStoreConfiguration>,
AttributeStore<JPAIdentityStoreConfiguration> {
    public static final String INVOCATION_CTX_ENTITY_MANAGER = "CTX_ENTITY_MANAGER";
    public static final String EVENT_CONTEXT_IDENTITY = "IDENTITY_ENTITY";
    private final List<EntityMapper> entityMappers = new ArrayList<EntityMapper>();

    @Override
    public void setup(JPAIdentityStoreConfiguration config) {
        super.setup(config);
        for (Class entityType : config.getEntityTypes()) {
            this.configureEntityMapper(entityType);
        }
    }

    @Override
    public void addAttributedType(IdentityContext context, AttributedType attributedType) {
        EntityManager entityManager = this.getEntityManager(context);
        for (EntityMapper entityMapper : this.getMapperFor(attributedType.getClass())) {
            entityMapper.persist(attributedType, entityManager);
            if (!entityMapper.isRoot() || !Relationship.class.isInstance(attributedType)) continue;
            this.storeRelationshipMembers((Relationship)attributedType, entityManager);
        }
        entityManager.flush();
    }

    @Override
    public void updateAttributedType(IdentityContext context, AttributedType attributedType) {
        EntityManager entityManager = this.getEntityManager(context);
        for (EntityMapper entityMapper : this.getMapperFor(attributedType.getClass())) {
            entityMapper.updateEntity(attributedType, entityManager);
        }
        entityManager.flush();
    }

    @Override
    public void removeAttributedType(IdentityContext context, AttributedType attributedType) {
        EntityManager entityManager = this.getEntityManager(context);
        EntityMapper rootMapper = this.getRootMapper(attributedType.getClass());
        if (Relationship.class.isAssignableFrom(attributedType.getClass())) {
            this.removeChildRelationships(context, (Relationship)attributedType, entityManager);
        } else if (IdentityType.class.isInstance(attributedType)) {
            this.removeRelationships(context, (IdentityType)attributedType);
            this.removeCredentials(attributedType, entityManager);
        }
        this.removeAssociatedEntities(attributedType, entityManager, rootMapper);
        entityManager.remove(this.getRootEntity(attributedType, entityManager));
    }

    public void add(IdentityContext identityContext, Partition partition, String configurationName) {
        this.add(identityContext, (AttributedType)partition);
        EntityMapper entityMapper = this.getRootMapper(partition.getClass());
        EntityManager entityManager = this.getEntityManager(identityContext);
        Object partitionEntity = this.getRootEntity((AttributedType)partition, entityManager);
        Map.Entry<Property, Property> configurationNameProperty = entityMapper.getProperty(partition.getClass(), ConfigurationName.class);
        configurationNameProperty.getValue().setValue(partitionEntity, (Object)configurationName);
        entityManager.merge(partitionEntity);
        entityManager.flush();
    }

    public String getConfigurationName(IdentityContext identityContext, Partition partition) {
        EntityMapper entityMapper = this.getRootMapper(partition.getClass());
        EntityManager entityManager = this.getEntityManager(identityContext);
        Object partitionEntity = entityManager.find(entityMapper.getEntityType(), (Object)partition.getId());
        Map.Entry<Property, Property> configurationNameProperty = entityMapper.getProperty(partition.getClass(), ConfigurationName.class);
        String configurationName = configurationNameProperty.getValue().getValue(partitionEntity).toString();
        if (configurationName == null) {
            throw new IdentityManagementException("No configuration name defined for partition [" + partition + "].");
        }
        return configurationName;
    }

    public <P extends Partition> P get(IdentityContext identityContext, Class<P> partitionClass, String name) {
        EntityManager entityManager = this.getEntityManager(identityContext);
        String PARTITION_NAME_PROPERTY = "name";
        EntityMapper entityMapper = this.getEntityMapperForProperty(partitionClass, PARTITION_NAME_PROPERTY);
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(entityMapper.getEntityType());
        Root from = cq.from(entityMapper.getEntityType());
        Map.Entry<Property, Property> nameEntityMapping = entityMapper.getProperty(partitionClass, PARTITION_NAME_PROPERTY);
        Map.Entry<Property, Property> typeEntityMapping = entityMapper.getProperty(partitionClass, PartitionClass.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(cb.equal((Expression)from.get(nameEntityMapping.getValue().getName()), (Object)name));
        if (!Partition.class.equals(partitionClass)) {
            predicates.add(cb.equal((Expression)from.get(typeEntityMapping.getValue().getName()), (Object)partitionClass.getName()));
        }
        cq.where(predicates.toArray(new Predicate[predicates.size()]));
        TypedQuery query = entityManager.createQuery(cq);
        query.setMaxResults(1);
        List result = query.getResultList();
        if (!result.isEmpty()) {
            return (P)((Partition)entityMapper.createType(result.get(0), entityManager));
        }
        return null;
    }

    public <P extends Partition> P lookupById(IdentityContext context, Class<P> partitionClass, String id) {
        EntityManager entityManager = this.getEntityManager(context);
        EntityMapper entityMapper = this.getRootMapper(Partition.class);
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(entityMapper.getEntityType());
        Root from = cq.from(entityMapper.getEntityType());
        Map.Entry<Property, Property> idEntityMapping = entityMapper.getProperty(Partition.class, Identifier.class);
        Map.Entry<Property, Property> typeEntityMapping = entityMapper.getProperty(partitionClass, PartitionClass.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(cb.equal((Expression)from.get(idEntityMapping.getValue().getName()), (Object)id));
        if (!Partition.class.equals(partitionClass)) {
            predicates.add(cb.equal((Expression)from.get(typeEntityMapping.getValue().getName()), (Object)partitionClass.getName()));
        }
        cq.where(predicates.toArray(new Predicate[predicates.size()]));
        TypedQuery query = entityManager.createQuery(cq);
        query.setMaxResults(1);
        List result = query.getResultList();
        if (!result.isEmpty()) {
            return (P)((Partition)entityMapper.createType(result.get(0), entityManager));
        }
        return null;
    }

    public void update(IdentityContext identityContext, Partition partition) {
        this.update(identityContext, (AttributedType)partition);
    }

    public void remove(IdentityContext identityContext, Partition partition) {
        this.remove(identityContext, (AttributedType)partition);
    }

    public <V extends Serializable> Attribute<V> getAttribute(IdentityContext context, AttributedType attributedType, String attributeName) {
        EntityManager entityManager = this.getEntityManager(context);
        Map<String, Attribute<Serializable>> attributes = this.getAttributes(attributedType, attributeName, entityManager);
        return attributes.get(attributeName);
    }

    public void loadAttributes(IdentityContext context, AttributedType attributedType) {
        Map<String, Attribute<Serializable>> attributes = this.getAttributes(attributedType, null, this.getEntityManager(context));
        for (Attribute<Serializable> attribute : attributes.values()) {
            attributedType.setAttribute(attribute);
        }
    }

    public void removeAttribute(IdentityContext context, AttributedType attributedType, String attributeName) {
        EntityManager entityManager = this.getEntityManager(context);
        EntityMapper attributeMapper = this.getAttributeMapper(attributedType.getClass());
        Map.Entry<Property, Property> attributeNameProperty = attributeMapper.getProperty(Attribute.class, AttributeName.class);
        Map.Entry<Property, Property> ownerProperty = attributeMapper.getProperty(Attribute.class, OwnerReference.class);
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(attributeMapper.getEntityType());
        Root from = cq.from(attributeMapper.getEntityType());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(cb.equal((Expression)from.get(attributeNameProperty.getValue().getName()), (Object)attributeName));
        if (((JPAIdentityStoreConfiguration)this.getConfig()).supportsType(attributedType.getClass(), IdentityStoreConfiguration.IdentityOperation.create) && !String.class.equals((Object)ownerProperty.getValue().getJavaClass())) {
            predicates.add(cb.equal((Expression)from.get(ownerProperty.getValue().getName()), this.getOwnerEntity(attributedType, ownerProperty.getValue(), entityManager)));
        } else {
            predicates.add(cb.equal((Expression)from.get(ownerProperty.getValue().getName()), (Object)attributedType.getId()));
        }
        cq.where(predicates.toArray(new Predicate[predicates.size()]));
        for (Object entity : entityManager.createQuery(cq).getResultList()) {
            entityManager.remove(entity);
        }
        entityManager.flush();
    }

    public <V extends IdentityType> List<V> fetchQueryResults(IdentityContext context, IdentityQuery<V> identityQuery) {
        ArrayList result = new ArrayList();
        EntityManager entityManager = this.getEntityManager(context);
        EntityMapper rootMapper = this.getRootMapper(identityQuery.getIdentityType());
        if (identityQuery.getParameter(IdentityType.ID) != null) {
            Object entity;
            Object[] parameter = identityQuery.getParameter(IdentityType.ID);
            if (parameter.length > 0 && (entity = entityManager.find(rootMapper.getEntityType(), parameter[0])) != null) {
                result.add(rootMapper.createType(entity, entityManager));
            }
        } else {
            Map.Entry<Property, Property> partitionProperty;
            CriteriaBuilder cb = entityManager.getCriteriaBuilder();
            CriteriaQuery cq = cb.createQuery(rootMapper.getEntityType());
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            Root from = cq.from(rootMapper.getEntityType());
            Partition partition = context.getPartition();
            if (identityQuery.getParameter(IdentityType.PARTITION) != null) {
                partition = (Partition)identityQuery.getParameter(IdentityType.PARTITION)[0];
            }
            if ((partitionProperty = rootMapper.getProperty(OwnerReference.class)) != null) {
                Join join = from.join(partitionProperty.getValue().getName());
                predicates.add(cb.equal((Expression)join, entityManager.find(partitionProperty.getValue().getJavaClass(), (Object)partition.getId())));
            }
            if (!IdentityType.class.equals((Object)identityQuery.getIdentityType())) {
                Map.Entry<Property, Property> property = rootMapper.getProperty(identityQuery.getIdentityType(), IdentityClass.class);
                predicates.add(cb.equal((Expression)from.get(property.getValue().getName()), (Object)identityQuery.getIdentityType().getName()));
            }
            for (QueryParameter queryParameter : identityQuery.getParameters().keySet()) {
                if (IdentityType.PARTITION.equals(queryParameter) || !AttributeParameter.class.isInstance(queryParameter)) continue;
                AttributeParameter attributeParameter = (AttributeParameter)queryParameter;
                Object[] parameterValues = identityQuery.getParameter((QueryParameter)attributeParameter);
                EntityMapper parameterEntityMapper = this.getEntityMapperForProperty(identityQuery.getIdentityType(), attributeParameter.getName());
                if (parameterEntityMapper != null) {
                    AttributedType ownerType;
                    Property mappedProperty = parameterEntityMapper.getProperty(identityQuery.getIdentityType(), attributeParameter.getName()).getValue();
                    Root propertyEntityJoin = from;
                    if (!parameterEntityMapper.getEntityType().equals(rootMapper.getEntityType())) {
                        propertyEntityJoin = cq.from(parameterEntityMapper.getEntityType());
                        Map.Entry<Property, Property> ownerProperty = parameterEntityMapper.getProperty(OwnerReference.class);
                        if (ownerProperty != null) {
                            if (ownerProperty.getValue().getAnnotatedElement().isAnnotationPresent(Id.class)) {
                                predicates.add(cb.and(new Predicate[]{cb.equal((Expression)propertyEntityJoin, (Expression)from)}));
                            } else {
                                predicates.add(cb.and(new Predicate[]{cb.equal((Expression)propertyEntityJoin.get(ownerProperty.getValue().getName()), (Expression)from)}));
                            }
                        }
                    }
                    Object parameterValue = parameterValues[0];
                    if (IdentityType.CREATED_AFTER.equals(queryParameter) || IdentityType.EXPIRY_AFTER.equals(queryParameter)) {
                        predicates.add(cb.greaterThanOrEqualTo((Expression)propertyEntityJoin.get(mappedProperty.getName()), (Comparable)((Date)parameterValue)));
                        continue;
                    }
                    if (IdentityType.CREATED_BEFORE.equals(queryParameter) || IdentityType.EXPIRY_BEFORE.equals(queryParameter)) {
                        predicates.add(cb.lessThanOrEqualTo((Expression)propertyEntityJoin.get(mappedProperty.getName()), (Comparable)((Date)parameterValue)));
                        continue;
                    }
                    if (this.isMappedType(mappedProperty.getJavaClass()) && (ownerType = (AttributedType)parameterValue) != null) {
                        parameterValue = entityManager.find(mappedProperty.getJavaClass(), (Object)ownerType.getId());
                    }
                    predicates.add(cb.equal((Expression)propertyEntityJoin.get(mappedProperty.getName()), parameterValue));
                    continue;
                }
                this.addAttributeQueryPredicates(identityQuery.getIdentityType(), cb, cq, from, predicates, attributeParameter, parameterValues);
            }
            Property idProperty = rootMapper.getProperty(Id.class).getValue();
            cq.select((Selection)from.get(idProperty.getName()));
            cq.where(predicates.toArray(new Predicate[predicates.size()]));
            TypedQuery query = entityManager.createQuery(cq);
            if (identityQuery.getLimit() > 0) {
                query.setMaxResults(identityQuery.getLimit());
                if (identityQuery.getOffset() > 0) {
                    query.setFirstResult(identityQuery.getOffset());
                }
            }
            for (Object entity : query.getResultList()) {
                result.add(rootMapper.createType(entityManager.find(rootMapper.getEntityType(), entity), entityManager));
            }
        }
        return result;
    }

    public <V extends IdentityType> int countQueryResults(IdentityContext context, IdentityQuery<V> identityQuery) {
        int limit = identityQuery.getLimit();
        int offset = identityQuery.getOffset();
        identityQuery.setLimit(0);
        identityQuery.setOffset(0);
        int resultCount = identityQuery.getResultList().size();
        identityQuery.setLimit(limit);
        identityQuery.setOffset(offset);
        return resultCount;
    }

    public <V extends Relationship> List<V> fetchQueryResults(IdentityContext context, RelationshipQuery<V> query) {
        EntityManager entityManager = this.getEntityManager(context);
        List<Object> entities = new ArrayList();
        Object[] identityParameterValues = query.getParameter(Relationship.IDENTITY);
        if (identityParameterValues != null) {
            for (Object parameterValue : identityParameterValues) {
                if (!IdentityType.class.isInstance(parameterValue)) {
                    throw IDMMessages.MESSAGES.queryUnsupportedParameterValue("Relationship.IDENTITY", parameterValue);
                }
                entities = this.findIdentityTypeRelationships(context, (IdentityType)parameterValue);
            }
        } else {
            Object[] idParameter;
            EntityMapper entityMapper = this.getRootMapper(query.getRelationshipClass());
            CriteriaBuilder cb = entityManager.getCriteriaBuilder();
            CriteriaQuery cq = cb.createQuery(entityMapper.getEntityType());
            Root from = cq.from(entityMapper.getEntityType());
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            Property typeProperty = entityMapper.getProperty(RelationshipClass.class).getValue();
            if (!Relationship.class.equals((Object)query.getRelationshipClass())) {
                predicates.add(cb.equal((Expression)from.get(typeProperty.getName()), (Object)query.getRelationshipClass().getName()));
            }
            if ((idParameter = query.getParameter(Relationship.ID)) != null && idParameter.length > 0) {
                Property idProperty = entityMapper.getProperty(Identifier.class).getValue();
                predicates.add(cb.equal((Expression)from.get(idProperty.getName()), idParameter[0]));
            } else {
                for (Map.Entry entry : query.getParameters().entrySet()) {
                    QueryParameter queryParameter = (QueryParameter)entry.getKey();
                    Object[] values = (Object[])entry.getValue();
                    if (queryParameter instanceof RelationshipQueryParameter) {
                        RelationshipQueryParameter identityTypeParameter = (RelationshipQueryParameter)entry.getKey();
                        ArrayList<String> identityTypeIdentifiers = new ArrayList<String>();
                        for (Object object : values) {
                            IdentityType identityType = (IdentityType)object;
                            if (identityType == null) {
                                return Collections.emptyList();
                            }
                            if (((JPAIdentityStoreConfiguration)this.getConfig()).supportsType(identityType.getClass(), IdentityStoreConfiguration.IdentityOperation.create)) {
                                identityTypeIdentifiers.add(identityType.getId());
                                continue;
                            }
                            identityTypeIdentifiers.add(RelationshipReference.formatId(identityType));
                        }
                        EntityMapper relationshipMemberMapper = this.getEntityMapperForProperty(RelationshipMember.class);
                        Property relationshipProperty = relationshipMemberMapper.getProperty(OwnerReference.class).getValue();
                        Subquery subquery = cq.subquery(relationshipMemberMapper.getEntityType());
                        Root fromRelationshipIdentityType = subquery.from(relationshipMemberMapper.getEntityType());
                        subquery.select((Expression)fromRelationshipIdentityType.get(relationshipProperty.getName()));
                        Property descriptorProperty = relationshipMemberMapper.getProperty(RelationshipDescriptor.class).getValue();
                        Predicate conjunction = cb.conjunction();
                        conjunction.getExpressions().add(cb.equal((Expression)fromRelationshipIdentityType.get(descriptorProperty.getName()), (Object)identityTypeParameter.getName()));
                        Property identityProperty = relationshipMemberMapper.getProperty(RelationshipMember.class).getValue();
                        if (identityProperty.getJavaClass().equals(String.class)) {
                            conjunction.getExpressions().add(fromRelationshipIdentityType.get(identityProperty.getName()).in(identityTypeIdentifiers));
                        } else {
                            Join join = fromRelationshipIdentityType.join(identityProperty.getName());
                            EntityMapper identityTypeMapper = this.getMapperForEntity(identityProperty.getJavaClass());
                            Property identifierProperty = identityTypeMapper.getProperty(Identifier.class).getValue();
                            conjunction.getExpressions().add(join.get(identifierProperty.getName()).in(identityTypeIdentifiers));
                        }
                        subquery.where((Expression)conjunction);
                        predicates.add((Predicate)cb.in((Expression)from).value((Expression)subquery));
                        continue;
                    }
                    if (!AttributeParameter.class.equals(((QueryParameter)entry.getKey()).getClass())) continue;
                    AttributeParameter attributeParameter = (AttributeParameter)entry.getKey();
                    Object[] parameterValues = (Object[])entry.getValue();
                    EntityMapper parameterEntityMapper = this.getEntityMapperForProperty(query.getRelationshipClass(), attributeParameter.getName());
                    if (parameterEntityMapper != null) {
                        AttributedType ownerType;
                        Root propertyEntityJoin = from;
                        Map.Entry<Property, Property> ownerProperty = parameterEntityMapper.getProperty(query.getRelationshipClass(), OwnerReference.class);
                        if (ownerProperty.getValue().getJavaClass().equals(entityMapper.getEntityType())) {
                            propertyEntityJoin = cq.from(parameterEntityMapper.getEntityType());
                            predicates.add(cb.and(new Predicate[]{cb.equal((Expression)propertyEntityJoin.get(ownerProperty.getValue().getName()), (Expression)from)}));
                        }
                        Object parameterValue = parameterValues[0];
                        Property mappedProperty = parameterEntityMapper.getProperty(query.getRelationshipClass(), attributeParameter.getName()).getValue();
                        if (this.isMappedType(mappedProperty.getJavaClass()) && (ownerType = (AttributedType)parameterValue) != null) {
                            parameterValue = entityManager.find(mappedProperty.getJavaClass(), (Object)ownerType.getId());
                        }
                        predicates.add(cb.equal((Expression)propertyEntityJoin.get(mappedProperty.getName()), parameterValue));
                        continue;
                    }
                    this.addAttributeQueryPredicates(query.getRelationshipClass(), cb, cq, from, predicates, attributeParameter, parameterValues);
                }
            }
            cq.select((Selection)from);
            cq.where(predicates.toArray(new Predicate[predicates.size()]));
            entities = entityManager.createQuery(cq).getResultList();
        }
        ArrayList result = new ArrayList();
        for (Object relationshipObject : entities) {
            result.add(this.convertToRelationshipType(context, relationshipObject));
        }
        return result;
    }

    public void setAttribute(IdentityContext context, AttributedType attributedType, Attribute<? extends Serializable> attribute) {
        this.removeAttribute(context, attributedType, attribute.getName());
        Serializable[] values = attribute.getValue();
        if (!values.getClass().isArray()) {
            values = new Serializable[]{values};
        }
        if (values instanceof byte[]) {
            values = new Serializable[]{values};
        }
        EntityMapper attributeMapper = this.getAttributeMapper(attributedType.getClass());
        Property attributeNameProperty = attributeMapper.getProperty(Attribute.class, AttributeName.class).getValue();
        Property attributeValueProperty = attributeMapper.getProperty(Attribute.class, AttributeValue.class).getValue();
        Property ownerProperty = attributeMapper.getProperty(Attribute.class, OwnerReference.class).getValue();
        EntityManager entityManager = this.getEntityManager(context);
        for (Serializable attributeValue : values) {
            Object attributeEntity = null;
            try {
                attributeEntity = attributeMapper.getEntityType().newInstance();
            }
            catch (Exception e) {
                throw IDMMessages.MESSAGES.instantiationError(attributeMapper.getEntityType(), (Throwable)e);
            }
            attributeNameProperty.setValue(attributeEntity, (Object)attribute.getName());
            attributeValueProperty.setValue(attributeEntity, (Object)Base64.encodeObject((Serializable)attributeValue));
            if (((JPAIdentityStoreConfiguration)this.getConfig()).supportsType(attributedType.getClass(), IdentityStoreConfiguration.IdentityOperation.create) && !String.class.equals((Object)ownerProperty.getJavaClass())) {
                ownerProperty.setValue(attributeEntity, this.getOwnerEntity(attributedType, ownerProperty, entityManager));
            } else {
                ownerProperty.setValue(attributeEntity, (Object)attributedType.getId());
            }
            entityManager.persist(attributeEntity);
        }
    }

    public void storeCredential(IdentityContext context, Account account, CredentialStorage storage) {
        EntityMapper credentialMapper = this.getCredentialAttributeMapper(storage.getClass());
        Object newCredential = null;
        try {
            newCredential = credentialMapper.getEntityType().newInstance();
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.instantiationError(credentialMapper.getEntityType(), (Throwable)e);
        }
        EntityManager entityManager = this.getEntityManager(context);
        for (EntityMapping entityMapping : credentialMapper.getEntityMappings()) {
            for (Property property : entityMapping.getProperties().keySet()) {
                Property mappedProperty = entityMapping.getProperties().get(property);
                if (mappedProperty.getAnnotatedElement().isAnnotationPresent(OwnerReference.class)) {
                    mappedProperty.setValue(newCredential, this.getOwnerEntity((AttributedType)account, mappedProperty, entityManager));
                    continue;
                }
                mappedProperty.setValue(newCredential, property.getValue((Object)storage));
            }
        }
        entityManager.persist(newCredential);
        entityManager.flush();
    }

    public <T extends CredentialStorage> T retrieveCurrentCredential(IdentityContext context, Account account, Class<T> storageClass) {
        List<T> credentials = this.retrieveCredentials(context, account, storageClass);
        if (!credentials.isEmpty()) {
            return (T)((CredentialStorage)credentials.get(0));
        }
        return null;
    }

    public <T extends CredentialStorage> List<T> retrieveCredentials(IdentityContext context, Account account, Class<T> storageClass) {
        EntityMapper attributeMapper = this.getCredentialAttributeMapper(storageClass);
        Property identityTypeProperty = attributeMapper.getProperty(storageClass, OwnerReference.class).getValue();
        Property typeProperty = attributeMapper.getProperty(storageClass, CredentialClass.class).getValue();
        Property effectiveProperty = attributeMapper.getProperty(storageClass, EffectiveDate.class).getValue();
        EntityManager entityManager = this.getEntityManager(context);
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(attributeMapper.getEntityType());
        Root root = criteria.from(attributeMapper.getEntityType());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Object agentInstance = this.getRootEntity((AttributedType)account, entityManager);
        predicates.add(builder.equal((Expression)root.get(identityTypeProperty.getName()), agentInstance));
        predicates.add(builder.equal((Expression)root.get(typeProperty.getName()), (Object)storageClass.getName()));
        Predicate conjunction = builder.conjunction();
        conjunction.getExpressions().add(builder.lessThanOrEqualTo((Expression)root.get(effectiveProperty.getName()), (Comparable)new Date()));
        predicates.add(conjunction);
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        criteria.orderBy(new Order[]{builder.desc((Expression)root.get(effectiveProperty.getName()))});
        ArrayList<T> storages = new ArrayList<T>();
        for (Object object : entityManager.createQuery(criteria).getResultList()) {
            storages.add(this.convertToCredentialStorage(object, storageClass));
        }
        return storages;
    }

    public <V extends Relationship> int countQueryResults(IdentityContext context, RelationshipQuery<V> query) {
        return 0;
    }

    public Object getOwnerEntity(AttributedType attributedType, Property ownerProperty, EntityManager entityManager) {
        EntityMapper attributedTypeMapper = this.getRootMapper(attributedType.getClass());
        Object entity = null;
        if (ownerProperty.getJavaClass().isAssignableFrom(attributedTypeMapper.getEntityType())) {
            entity = this.getRootEntity(attributedType, entityManager);
        } else {
            EntityMapper ownerMapper = this.getMapperForEntity(ownerProperty.getJavaClass());
            List associatedEntities = attributedTypeMapper.getAssociatedEntities(attributedType, ownerMapper, entityManager);
            if (!associatedEntities.isEmpty()) {
                entity = associatedEntities.get(0);
            }
        }
        return entity;
    }

    public List<EntityMapper> getMapperFor(Class<? extends AttributedType> attributedType) {
        ArrayList<EntityMapper> mappers = new ArrayList<EntityMapper>();
        for (EntityMapper entityMapper : this.entityMappers) {
            if (!entityMapper.getEntityType().isAnnotationPresent(IdentityManaged.class)) continue;
            for (EntityMapping entityMapping : entityMapper.getEntityMappings()) {
                if (entityMapping.getSupportedType().equals(attributedType) && entityMapper.isRoot()) {
                    mappers.add(0, entityMapper);
                    continue;
                }
                if (entityMapping.getSupportedType().isAssignableFrom(attributedType)) {
                    mappers.add(entityMapper);
                    continue;
                }
                if (!attributedType.isAssignableFrom(entityMapping.getSupportedType())) continue;
                mappers.add(entityMapper);
            }
        }
        if (mappers.isEmpty()) {
            throw new IdentityManagementException("No entity mapper found for type [" + attributedType + "].");
        }
        return mappers;
    }

    public EntityMapper getRootMapperForEntity(Class<?> entityClass) {
        for (EntityMapper entityMapper : this.entityMappers) {
            if (!entityMapper.isRoot() || !entityMapper.getEntityType().equals(entityClass)) continue;
            return entityMapper;
        }
        throw new IdentityManagementException("No mapper for entity type [" + entityClass + "].");
    }

    public EntityMapper getMapperForEntity(Class<?> entityClass) {
        for (EntityMapper entityMapper : this.entityMappers) {
            if (!entityMapper.getEntityType().equals(entityClass)) continue;
            return entityMapper;
        }
        throw new IdentityManagementException("No mapper for entity type [" + entityClass + "].");
    }

    public List<EntityMapper> getEntityMappers() {
        return this.entityMappers;
    }

    public boolean isMappedType(Class mappedClass) {
        for (EntityMapper entityMapper : this.getEntityMappers()) {
            if (!entityMapper.getEntityType().equals(mappedClass)) continue;
            return true;
        }
        return false;
    }

    public Object getRootEntity(AttributedType attributedType, EntityManager entityManager) {
        return entityManager.find(this.getRootMapper(attributedType.getClass()).getEntityType(), (Object)attributedType.getId());
    }

    private EntityMapper getEntityMapperForProperty(Class<? extends AttributedType> attributedType, String propertyName) {
        for (EntityMapper entityMapper : this.getMapperFor(attributedType)) {
            Map.Entry<Property, Property> property = entityMapper.getProperty(attributedType, propertyName);
            if (property == null) continue;
            return entityMapper;
        }
        return null;
    }

    private EntityMapper getEntityMapperForProperty(Class<? extends Annotation> annotation) {
        for (EntityMapper entityMapper : this.entityMappers) {
            Map.Entry<Property, Property> property = entityMapper.getProperty(annotation);
            if (property == null) continue;
            return entityMapper;
        }
        return null;
    }

    private List<?> findIdentityTypeRelationships(IdentityContext context, IdentityType identityType) {
        EntityManager em = this.getEntityManager(context);
        EntityMapper relationshipMemberMapper = this.getEntityMapperForProperty(RelationshipMember.class);
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(relationshipMemberMapper.getEntityType());
        Root root = criteria.from(relationshipMemberMapper.getEntityType());
        Property identityTypeProperty = relationshipMemberMapper.getProperty(RelationshipMember.class).getValue();
        if (identityTypeProperty.getJavaClass().equals(String.class)) {
            criteria.where((Expression)builder.equal((Expression)root.get(identityTypeProperty.getName()), (Object)RelationshipReference.formatId(identityType)));
        } else {
            criteria.where((Expression)builder.equal((Expression)root.get(identityTypeProperty.getName()), em.find(identityTypeProperty.getJavaClass(), (Object)identityType.getId())));
        }
        ArrayList<Object> relationships = new ArrayList<Object>();
        List result = em.createQuery(criteria).getResultList();
        Property ownerProperty = relationshipMemberMapper.getProperty(OwnerReference.class).getValue();
        for (Object object : result) {
            relationships.add(ownerProperty.getValue(object));
        }
        return relationships;
    }

    private <T extends Relationship> T convertToRelationshipType(IdentityContext context, Object relationshipObject) {
        EntityMapper relationshipMemberMapper = this.getEntityMapperForProperty(RelationshipMember.class);
        Property identityProperty = relationshipMemberMapper.getProperty(RelationshipMember.class).getValue();
        Property descriptorProperty = relationshipMemberMapper.getProperty(RelationshipDescriptor.class).getValue();
        EntityManager entityManager = this.getEntityManager(context);
        EntityMapper relMapper = this.getRootMapper(Relationship.class);
        Relationship relationshipType = (Relationship)relMapper.createType(relationshipObject, entityManager);
        boolean supportsType = ((JPAIdentityStoreConfiguration)this.getConfig()).supportsType(IdentityType.class, IdentityStoreConfiguration.IdentityOperation.create);
        RelationshipReference reference = null;
        if (!supportsType) {
            reference = new RelationshipReference(relationshipType);
        }
        for (Object object : this.findChildRelationships(context, relationshipType)) {
            String descriptor = ((String)descriptorProperty.getValue(object)).toString();
            Property identityTypeProperty = PropertyQueries.createQuery(relationshipType.getClass()).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{descriptor})).getSingleResult();
            IdentityType identityType = null;
            Object identityTypeEntity = identityProperty.getValue(object);
            if (!supportsType) {
                reference.addIdentityTypeReference(descriptor, identityTypeEntity.toString());
            } else {
                EntityMapper entityMapper = this.getRootMapperForEntity(identityTypeEntity.getClass());
                identityType = (IdentityType)entityMapper.createType(identityTypeEntity, entityManager);
            }
            identityTypeProperty.setValue((Object)relationshipType, identityType);
        }
        if (reference != null) {
            return (T)((Object)reference);
        }
        return (T)relationshipType;
    }

    private List<?> findChildRelationships(IdentityContext context, Relationship relationship) {
        EntityManager em = this.getEntityManager(context);
        EntityMapper relationshipMemberMapper = this.getEntityMapperForProperty(RelationshipMember.class);
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(relationshipMemberMapper.getEntityType());
        Root root = criteria.from(relationshipMemberMapper.getEntityType());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Property ownerProperty = relationshipMemberMapper.getProperty(OwnerReference.class).getValue();
        Join join = root.join(ownerProperty.getName());
        EntityMapper relationshipMapper = this.getRootMapper(relationship.getClass());
        Property identifierProperty = relationshipMapper.getProperty(Identifier.class).getValue();
        predicates.add(builder.equal((Expression)join.get(identifierProperty.getName()), (Object)relationship.getId()));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        return em.createQuery(criteria).getResultList();
    }

    private void removeRelationships(IdentityContext context, IdentityType identityType) {
        List<?> relationshipsToRemove = this.findIdentityTypeRelationships(context, identityType);
        for (Object relationship : relationshipsToRemove) {
            this.remove(context, (AttributedType)this.convertToRelationshipType(context, relationship));
        }
    }

    private <T extends CredentialStorage> T convertToCredentialStorage(Object entity, Class<T> storageType) {
        CredentialStorage storage = null;
        if (entity != null) {
            EntityMapper credentialMapper = this.getCredentialAttributeMapper(storageType);
            try {
                storage = (CredentialStorage)storageType.newInstance();
            }
            catch (Exception e) {
                throw IDMMessages.MESSAGES.instantiationError(storageType, (Throwable)e);
            }
            for (EntityMapping entityMapping : credentialMapper.getEntityMappings()) {
                for (Property property : entityMapping.getProperties().keySet()) {
                    Property mappedProperty = entityMapping.getProperties().get(property);
                    if (mappedProperty.getAnnotatedElement().isAnnotationPresent(OwnerReference.class)) continue;
                    property.setValue((Object)storage, mappedProperty.getValue(entity));
                }
            }
        }
        return (T)storage;
    }

    private EntityMapper getCredentialAttributeMapper(Class<? extends CredentialStorage> credentialStorageClass) {
        for (EntityMapper entityMapper : this.entityMappers) {
            ManagedCredential managedCredential = entityMapper.getEntityType().getAnnotation(ManagedCredential.class);
            if (managedCredential == null) continue;
            if (managedCredential.value().length > 0) {
                for (Class supportedType : managedCredential.value()) {
                    if (!supportedType.equals(credentialStorageClass)) continue;
                    return entityMapper;
                }
                for (Class supportedType : managedCredential.value()) {
                    if (!supportedType.isAssignableFrom(credentialStorageClass)) continue;
                    return entityMapper;
                }
                continue;
            }
            return entityMapper;
        }
        throw new IdentityManagementException("No mapper for for credential storage type [" + credentialStorageClass + "].");
    }

    private void removeCredentials(AttributedType attributedType, EntityManager entityManager) {
        ArrayList entities = new ArrayList();
        for (EntityMapper attributeMapper : this.getEntityMappers()) {
            if (!attributeMapper.getEntityType().isAnnotationPresent(ManagedCredential.class)) continue;
            Property identityTypeProperty = attributeMapper.getProperty(OwnerReference.class).getValue();
            Property effectiveProperty = attributeMapper.getProperty(EffectiveDate.class).getValue();
            CriteriaBuilder builder = entityManager.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(attributeMapper.getEntityType());
            Root root = criteria.from(attributeMapper.getEntityType());
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            Object agentInstance = this.getRootEntity(attributedType, entityManager);
            predicates.add(builder.equal((Expression)root.get(identityTypeProperty.getName()), agentInstance));
            criteria.where(predicates.toArray(new Predicate[predicates.size()]));
            criteria.orderBy(new Order[]{builder.desc((Expression)root.get(effectiveProperty.getName()))});
            List result = entityManager.createQuery(criteria).getResultList();
            for (Object storageEntity : result) {
                entities.add(storageEntity);
            }
        }
        for (EntityMapper credentialEntity : entities) {
            entityManager.remove((Object)credentialEntity);
        }
    }

    private void removeChildRelationships(IdentityContext context, Relationship attributedType, EntityManager entityManager) {
        for (Object child : this.findChildRelationships(context, attributedType)) {
            entityManager.remove(child);
        }
    }

    private void removeAssociatedEntities(AttributedType attributedType, EntityManager entityManager, EntityMapper rootMapper) {
        for (EntityMapper childMapper : this.getMapperFor(attributedType.getClass())) {
            if (childMapper.isRoot()) continue;
            for (Object child : rootMapper.getAssociatedEntities(attributedType, childMapper, entityManager)) {
                entityManager.remove(child);
            }
        }
    }

    private EntityMapper getRootMapper(Class<? extends AttributedType> aClass) {
        return this.getMapperFor(aClass).get(0);
    }

    private Map<String, Attribute<Serializable>> getAttributes(AttributedType attributedType, String attributeName, EntityManager entityManager) {
        EntityMapper attributeMapper = this.getAttributeMapper(attributedType.getClass());
        Class<?> attributeEntityClass = attributeMapper.getEntityType();
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(attributeEntityClass);
        Root from = cq.from(attributeEntityClass);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Property attributeNameProperty = attributeMapper.getProperty(Attribute.class, AttributeName.class).getValue();
        if (attributeName != null) {
            predicates.add(cb.equal((Expression)from.get(attributeNameProperty.getName()), (Object)attributeName));
        }
        Property ownerProperty = attributeMapper.getProperty(Attribute.class, OwnerReference.class).getValue();
        if (((JPAIdentityStoreConfiguration)this.getConfig()).supportsType(attributedType.getClass(), IdentityStoreConfiguration.IdentityOperation.create) && !String.class.equals((Object)ownerProperty.getJavaClass())) {
            predicates.add(cb.equal((Expression)from.get(ownerProperty.getName()), this.getOwnerEntity(attributedType, ownerProperty, entityManager)));
        } else {
            predicates.add(cb.equal((Expression)from.get(ownerProperty.getName()), (Object)attributedType.getId()));
        }
        cq.where(predicates.toArray(new Predicate[predicates.size()]));
        Property attributeValueProperty = attributeMapper.getProperty(Attribute.class, AttributeValue.class).getValue();
        HashMap<String, Attribute<Serializable>> attributes = new HashMap<String, Attribute<Serializable>>();
        for (Object attributeEntity : entityManager.createQuery(cq).getResultList()) {
            String storedName = attributeNameProperty.getValue(attributeEntity).toString();
            Serializable storedValue = (Serializable)Base64.decodeToObject((String)attributeValueProperty.getValue(attributeEntity).toString());
            Attribute attribute = (Attribute)attributes.get(storedName);
            if (attribute == null) {
                attribute = new Attribute(storedName, storedValue);
            } else if (attribute != null) {
                Serializable[] values = null;
                if (attribute.getValue().getClass().isArray()) {
                    values = (Serializable[])attribute.getValue();
                } else {
                    values = (Serializable[])Array.newInstance(attribute.getValue().getClass(), 1);
                    values[0] = attribute.getValue();
                }
                Serializable[] newValues = Arrays.copyOf(values, values.length + 1);
                newValues[newValues.length - 1] = storedValue;
                attribute.setValue((Serializable)newValues);
            }
            attributes.put(attribute.getName(), (Attribute<Serializable>)attribute);
        }
        return attributes;
    }

    private void addAttributeQueryPredicates(Class<? extends AttributedType> attributedType, CriteriaBuilder cb, CriteriaQuery<?> cq, Root from, List<Predicate> predicates, AttributeParameter attributeParameter, Object[] parameterValues) {
        String[] valuesToSearch = new String[parameterValues.length];
        for (int i = 0; i < parameterValues.length; ++i) {
            valuesToSearch[i] = Base64.encodeObject((Serializable)((Serializable)parameterValues[i]));
        }
        EntityMapper attributeMapper = this.getAttributeMapper(attributedType);
        Class<?> attributeEntityClass = attributeMapper.getEntityType();
        Property attributeNameProperty = attributeMapper.getProperty(Attribute.class, AttributeName.class).getValue();
        Property attributeValueProperty = attributeMapper.getProperty(Attribute.class, AttributeValue.class).getValue();
        Property ownerProperty = attributeMapper.getProperty(Attribute.class, OwnerReference.class).getValue();
        Subquery subQuery = cq.subquery(attributeEntityClass);
        Root fromProject = subQuery.from(attributeEntityClass);
        subQuery.select((Expression)fromProject.get(ownerProperty.getName()));
        Predicate conjunction = cb.conjunction();
        conjunction.getExpressions().add(cb.equal((Expression)fromProject.get(attributeNameProperty.getName()), (Object)attributeParameter.getName()));
        conjunction.getExpressions().add(fromProject.get(attributeValueProperty.getName()).in((Object[])valuesToSearch));
        subQuery.where((Expression)conjunction);
        subQuery.groupBy(new Expression[]{subQuery.getSelection()}).having((Expression)cb.equal(cb.count(subQuery.getSelection()), (Object)valuesToSearch.length));
        predicates.add((Predicate)cb.in((Expression)from).value((Expression)subQuery));
    }

    private EntityMapper getAttributeMapper(Class<? extends AttributedType> attributedType) {
        ArrayList<EntityMapper> attributeMappers = new ArrayList<EntityMapper>();
        for (EntityMapper entityMapper : this.entityMappers) {
            if (entityMapper.getMappingsFor(Attribute.class) == null) continue;
            attributeMappers.add(entityMapper);
        }
        EntityMapper secondaryMapper = null;
        if (((JPAIdentityStoreConfiguration)this.getConfig()).supportsType(attributedType, IdentityStoreConfiguration.IdentityOperation.create)) {
            List<EntityMapper> attributedTypeMappers = this.getMapperFor(attributedType);
            for (EntityMapper entityMapper : attributedTypeMappers) {
                Class<?> entityType = entityMapper.getEntityType();
                for (EntityMapper mapper : attributeMappers) {
                    EntityMapping mappings = mapper.getMappingsFor(Attribute.class);
                    if (mappings == null) continue;
                    if (mappings.getOwnerType().equals(entityType)) {
                        return mapper;
                    }
                    if (!mappings.getOwnerType().isAssignableFrom(entityType)) continue;
                    secondaryMapper = mapper;
                }
            }
            if (secondaryMapper != null) {
                return secondaryMapper;
            }
        }
        for (EntityMapper mapper : attributeMappers) {
            EntityMapping mappings = mapper.getMappingsFor(Attribute.class);
            if (mappings == null || !String.class.equals(mappings.getOwnerType())) continue;
            return mapper;
        }
        throw new IdentityManagementException("Could not find mapper for attributes for type [" + attributedType + "].");
    }

    private void storeRelationshipMembers(Relationship relationship, EntityManager entityManager) {
        Object ownerEntity = this.getRootEntity((AttributedType)relationship, entityManager);
        List props = PropertyQueries.createQuery(relationship.getClass()).addCriteria((PropertyCriteria)new TypedPropertyCriteria(IdentityType.class, TypedPropertyCriteria.MatchOption.SUB_TYPE)).getResultList();
        EntityMapper relationshipMemberMapper = this.getEntityMapperForProperty(RelationshipMember.class);
        for (Property prop : props) {
            Object relationshipIdentity = null;
            try {
                relationshipIdentity = relationshipMemberMapper.getEntityType().newInstance();
            }
            catch (Exception e) {
                throw IDMMessages.MESSAGES.instantiationError(relationshipMemberMapper.getEntityType(), (Throwable)e);
            }
            IdentityType identityType = (IdentityType)prop.getValue((Object)relationship);
            if (identityType != null) {
                Property identityTypeProperty = relationshipMemberMapper.getProperty(RelationshipMember.class).getValue();
                if (((JPAIdentityStoreConfiguration)this.getConfig()).supportsType(identityType.getClass(), IdentityStoreConfiguration.IdentityOperation.create)) {
                    identityTypeProperty.setValue(relationshipIdentity, this.getRootEntity((AttributedType)identityType, entityManager));
                } else {
                    if (!String.class.equals((Object)identityTypeProperty.getJavaClass())) {
                        throw new IdentityManagementException("This store does not support type [" + identityType.getClass() + "]. @RelationshipMember should reference a String field to store " + "only ids.");
                    }
                    identityTypeProperty.setValue(relationshipIdentity, (Object)RelationshipReference.formatId(identityType));
                }
                Property descriptorProperty = relationshipMemberMapper.getProperty(RelationshipDescriptor.class).getValue();
                Property ownerProperty = relationshipMemberMapper.getProperty(OwnerReference.class).getValue();
                descriptorProperty.setValue(relationshipIdentity, (Object)prop.getName());
                ownerProperty.setValue(relationshipIdentity, ownerEntity);
            }
            entityManager.persist(relationshipIdentity);
        }
    }

    private void configureEntityMapper(Class<?> entityType) {
        Class ownerClass;
        EntityMapper entityMapper = new EntityMapper(entityType, this);
        Map.Entry<Property, Property> ownerProperty = entityMapper.getProperty(OwnerReference.class);
        if (ownerProperty != null && !String.class.equals((Object)(ownerClass = ownerProperty.getValue().getJavaClass())) && ((JPAIdentityStoreConfiguration)this.getConfig()).getEntityTypes().contains(ownerClass)) {
            this.configureEntityMapper(ownerClass);
        }
        if (!this.entityMappers.contains(entityMapper)) {
            this.entityMappers.add(entityMapper);
        }
    }

    private EntityManager getEntityManager(IdentityContext context) {
        if (!context.isParameterSet(INVOCATION_CTX_ENTITY_MANAGER)) {
            throw IDMMessages.MESSAGES.jpaStoreCouldNotGetEntityManagerFromStoreContext();
        }
        return (EntityManager)context.getParameter(INVOCATION_CTX_ENTITY_MANAGER);
    }
}

