/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal.mappers;

import org.picketlink.common.properties.Property;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.jpa.annotations.AttributeValue;
import org.picketlink.idm.jpa.annotations.Identifier;
import org.picketlink.idm.jpa.internal.mappers.AbstractIdentityManagedMapper;
import org.picketlink.idm.jpa.internal.mappers.EntityMapping;
import org.picketlink.idm.model.AttributedType;

public abstract class AbstractAttributedTypeMapper
extends AbstractIdentityManagedMapper {
    @Override
    public EntityMapping configure(Class<?> managedType, Class<?> entityType) {
        EntityMapping entityMapping = new EntityMapping(managedType);
        Property idProperty = this.getAnnotatedProperty(Identifier.class, entityType);
        if (idProperty == null) {
            throw IDMMessages.MESSAGES.jpaConfigRequiredMappingAnnotation(entityType, Identifier.class);
        }
        entityMapping.addProperty(this.getNamedProperty("id", AttributedType.class), idProperty);
        for (Property<String> mappedProperty : this.getAnnotatedProperties(AttributeValue.class, entityType)) {
            Property property;
            AttributeValue attributeValue = mappedProperty.getAnnotatedElement().getAnnotation(AttributeValue.class);
            String propertyName = mappedProperty.getName();
            if (!StringUtil.isNullOrEmpty((String)attributeValue.name())) {
                propertyName = attributeValue.name();
            }
            if ((property = this.getNamedProperty(propertyName, managedType)) == null) continue;
            entityMapping.addProperty(property, mappedProperty);
        }
        return entityMapping;
    }
}

