/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal.mappers;

import java.util.ArrayList;
import java.util.List;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.jpa.annotations.CredentialClass;
import org.picketlink.idm.jpa.annotations.CredentialProperty;
import org.picketlink.idm.jpa.annotations.EffectiveDate;
import org.picketlink.idm.jpa.annotations.ExpiryDate;
import org.picketlink.idm.jpa.annotations.entity.ManagedCredential;
import org.picketlink.idm.jpa.internal.mappers.AbstractModelMapper;
import org.picketlink.idm.jpa.internal.mappers.EntityMapping;

public class ManagedCredentialAttributeMapper
extends AbstractModelMapper {
    @Override
    public boolean supports(Class<?> entityType) {
        return this.getManagedCredential(entityType) != null;
    }

    @Override
    public List<EntityMapping> doCreateMapping(Class<?> entityType) throws SecurityConfigurationException {
        ArrayList<EntityMapping> mappings = new ArrayList<EntityMapping>();
        Class[] storageTypes = this.getManagedCredential(entityType).value();
        if (storageTypes.length == 0) {
            storageTypes = new Class[]{CredentialStorage.class};
        }
        for (Class storageType : storageTypes) {
            EntityMapping entityMapping = new EntityMapping(storageType);
            Property typeProperty = this.getAnnotatedProperty(CredentialClass.class, entityType);
            if (typeProperty == null) {
                throw IDMMessages.MESSAGES.jpaConfigRequiredMappingAnnotation(entityType, CredentialClass.class);
            }
            entityMapping.addTypeProperty(typeProperty);
            Property effectiveDate = this.getAnnotatedProperty(EffectiveDate.class, entityType);
            if (effectiveDate == null) {
                throw IDMMessages.MESSAGES.jpaConfigRequiredMappingAnnotation(entityType, EffectiveDate.class);
            }
            entityMapping.addProperty(this.getNamedProperty("effectiveDate", storageType), effectiveDate);
            Property expirationDate = this.getAnnotatedProperty(ExpiryDate.class, entityType);
            if (expirationDate == null) {
                throw IDMMessages.MESSAGES.jpaConfigRequiredMappingAnnotation(entityType, ExpiryDate.class);
            }
            entityMapping.addProperty(this.getNamedProperty("expiryDate", storageType), expirationDate);
            entityMapping.addOwnerProperty(entityType);
            List properties = PropertyQueries.createQuery(entityType).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(CredentialProperty.class)).getResultList();
            for (Property property : properties) {
                CredentialProperty credentialProperty = property.getAnnotatedElement().getAnnotation(CredentialProperty.class);
                String propertyName = credentialProperty.name();
                if (StringUtil.isNullOrEmpty((String)propertyName)) {
                    propertyName = property.getName();
                }
                entityMapping.addProperty(propertyName, property);
            }
            mappings.add(entityMapping);
        }
        return mappings;
    }

    private ManagedCredential getManagedCredential(Class<?> entityType) {
        return entityType.getAnnotation(ManagedCredential.class);
    }
}

