/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.util.Date;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.config.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.credential.UsernamePasswordCredentials;
import org.picketlink.idm.credential.handler.CredentialHandler;
import org.picketlink.idm.credential.handler.annotations.SupportsCredentials;
import org.picketlink.idm.ldap.internal.LDAPIdentityStore;
import org.picketlink.idm.ldap.internal.LDAPOperationManager;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.sample.Agent;
import org.picketlink.idm.model.sample.SampleModel;
import org.picketlink.idm.spi.IdentityContext;

@SupportsCredentials(value={UsernamePasswordCredentials.class, Password.class})
public class LDAPPlainTextPasswordCredentialHandler<S, V, U>
implements CredentialHandler<LDAPIdentityStore, UsernamePasswordCredentials, Password> {
    private static final String USER_PASSWORD_ATTRIBUTE = "userpassword";

    public void setup(LDAPIdentityStore store) {
    }

    public void validate(IdentityContext context, UsernamePasswordCredentials usernamePassword, LDAPIdentityStore identityStore) {
        usernamePassword.setStatus(Credentials.Status.INVALID);
        usernamePassword.setValidatedAccount(null);
        Account agent = this.getAccount(context, usernamePassword.getUsername());
        if (agent != null) {
            if (agent.isEnabled()) {
                LDAPIdentityStore ldapIdentityStore = identityStore;
                char[] password = usernamePassword.getPassword().getValue();
                String bindingDN = ldapIdentityStore.getBindingDN((AttributedType)agent);
                LDAPOperationManager operationManager = ldapIdentityStore.getOperationManager();
                if (operationManager.authenticate(bindingDN, new String(password))) {
                    usernamePassword.setValidatedAccount(agent);
                    usernamePassword.setStatus(Credentials.Status.VALID);
                }
            } else {
                usernamePassword.setStatus(Credentials.Status.ACCOUNT_DISABLED);
            }
        }
    }

    public void update(IdentityContext context, Account account, Password password, LDAPIdentityStore store, Date effectiveDate, Date expiryDate) {
        if (((LDAPIdentityStoreConfiguration)store.getConfig()).isActiveDirectory()) {
            this.updateADPassword(account, new String(password.getValue()), store);
        } else {
            ModificationItem[] mods = new ModificationItem[1];
            try {
                BasicAttribute mod0 = new BasicAttribute(USER_PASSWORD_ATTRIBUTE, new String(password.getValue()));
                mods[0] = new ModificationItem(2, mod0);
                store.getOperationManager().modifyAttribute(store.getBindingDN((AttributedType)account), mod0);
            }
            catch (Exception e) {
                throw new IdentityManagementException("Error updating password.", (Throwable)e);
            }
        }
    }

    private void updateADPassword(Account account, String password, LDAPIdentityStore store) {
        try {
            String newQuotedPassword = "\"" + password + "\"";
            byte[] newUnicodePassword = newQuotedPassword.getBytes("UTF-16LE");
            BasicAttribute unicodePwd = new BasicAttribute("unicodePwd", newUnicodePassword);
            store.getOperationManager().modifyAttribute(store.getBindingDN((AttributedType)account), unicodePwd);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Account getAccount(IdentityContext context, String loginName) {
        IdentityManager identityManager = this.getIdentityManager(context);
        Agent agent = SampleModel.getAgent((IdentityManager)identityManager, (String)loginName);
        if (agent == null) {
            agent = SampleModel.getUser((IdentityManager)identityManager, (String)loginName);
        }
        return agent;
    }

    protected IdentityManager getIdentityManager(IdentityContext context) {
        IdentityManager identityManager = (IdentityManager)context.getParameter("IDENTITY_MANAGER_CTX_PARAMETER");
        if (identityManager == null) {
            throw new IdentityManagementException("IdentityManager not set into context.");
        }
        return identityManager;
    }
}

