/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdentityManagementException;

public abstract class AbstractFileType<T>
implements Serializable {
    private static final long serialVersionUID = -3979114481984415635L;
    private String version;
    private String type;
    private Map<String, Serializable> properties = new ConcurrentHashMap<String, Serializable>();
    private transient T loadedObject;

    protected AbstractFileType(String version, T object) {
        if (version == null) {
            throw new IdentityManagementException("Version not specified.");
        }
        this.version = version;
        if (object == null) {
            throw new IdentityManagementException("Could not create a null file entry.");
        }
        this.loadedObject = object;
        this.type = this.loadedObject.getClass().getName();
    }

    private void writeObject(ObjectOutputStream s) {
        try {
            s.writeObject(this.version);
            s.writeObject(this.type);
            this.doPopulateProperties(this.properties);
            s.writeObject(this.properties);
            this.doWriteObject(s);
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.marshallingError((Throwable)e);
        }
    }

    protected void doWriteObject(ObjectOutputStream s) throws Exception {
    }

    protected abstract void doPopulateProperties(Map<String, Serializable> var1) throws Exception;

    private void readObject(ObjectInputStream s) {
        try {
            this.version = (String)s.readObject();
            this.type = (String)s.readObject();
            this.properties = (Map)s.readObject();
            this.doReadObject(s);
            this.loadedObject = this.doPopulateEntry(this.properties);
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.unmarshallingError((Throwable)e);
        }
    }

    protected void doReadObject(ObjectInputStream s) throws Exception {
    }

    protected abstract T doPopulateEntry(Map<String, Serializable> var1) throws Exception;

    protected T getEntry() {
        return this.loadedObject;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }
}

