/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import org.picketlink.idm.file.internal.AbstractFileIdentityType;
import org.picketlink.idm.model.User;

public class FileUser
extends AbstractFileIdentityType
implements User {
    private static final long serialVersionUID = 7828377893630773126L;
    private String id;
    private String firstName;
    private String lastName;
    private String email;
    private String fullName;

    public FileUser(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getKey() {
        return String.format("%s%s", "USER://", this.getId());
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
        this.update();
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
        this.update();
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
        this.update();
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
        this.update();
    }

    @Override
    protected void update() {
        if (this.changeListener != null) {
            this.changeListener.updateUsers();
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        return other.getId() != null && this.getId() != null && other.getId().equals(this.getId());
    }
}

