/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getClassLoader(final Class<?> theClass) {
        if (System.getSecurityManager() == null) {
            return theClass.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return theClass.getClassLoader();
            }
        });
    }

    static Object instance(Class<?> theClass, String fqn) {
        try {
            Class<?> clazz = SecurityActions.loadClass(theClass, fqn);
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static Class<?> loadClass(final Class<?> theClass, final String fqn) {
        if (System.getSecurityManager() == null) {
            ClassLoader classLoader = theClass.getClassLoader();
            Class<?> clazz = SecurityActions.loadClass(classLoader, fqn);
            if (clazz == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
                clazz = SecurityActions.loadClass(classLoader, fqn);
            }
            return clazz;
        }
        return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                ClassLoader classLoader = theClass.getClassLoader();
                Class<?> clazz = SecurityActions.loadClass(classLoader, fqn);
                if (clazz == null) {
                    classLoader = Thread.currentThread().getContextClassLoader();
                    clazz = SecurityActions.loadClass(classLoader, fqn);
                }
                return clazz;
            }
        });
    }

    static Class<?> loadClass(final ClassLoader cl, final String fqn) {
        if (System.getSecurityManager() == null) {
            try {
                return cl.loadClass(fqn);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    return cl.loadClass(fqn);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
        });
    }

    static String getSystemProperty(final String key, final String defaultValue) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(key, defaultValue);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key, defaultValue);
            }
        });
    }
}

