/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import org.picketlink.idm.ldap.internal.DirContextAdaptor;
import org.picketlink.idm.ldap.internal.LDAPRole;
import org.picketlink.idm.ldap.internal.LDAPUser;
import org.picketlink.idm.model.Group;

public class LDAPGroup
extends DirContextAdaptor
implements Group {
    private static final long serialVersionUID = 1L;
    public final String COMMA = ",";
    private LDAPGroup parent;
    private String groupName;
    private String groupDNSuffix;

    public LDAPGroup() {
        BasicAttribute oc = new BasicAttribute("objectclass");
        oc.add("top");
        oc.add("groupOfNames");
        this.attributes.put(oc);
    }

    public LDAPGroup(Attributes attributes, String groupDNSuffix) {
        this.attributes = attributes;
        this.groupDNSuffix = groupDNSuffix;
    }

    public String getDN() {
        return "cn=" + this.groupName + "," + this.groupDNSuffix;
    }

    public void addRole(LDAPRole role) {
        Attribute memberAttribute = this.attributes.get("member");
        if (memberAttribute != null) {
            if (memberAttribute.contains(" ")) {
                memberAttribute.remove(" ");
            }
        } else {
            memberAttribute = new BasicAttribute("objectclass");
            memberAttribute.add("top");
            memberAttribute.add("groupOfNames");
        }
        memberAttribute.add(role.getDN());
    }

    public void addUser(LDAPUser user) {
        Attribute memberAttribute = this.attributes.get("member");
        if (memberAttribute != null) {
            if (memberAttribute.contains(" ")) {
                memberAttribute.remove(" ");
            }
        } else {
            memberAttribute = new BasicAttribute("objectclass");
            memberAttribute.add("inetOrgPerson");
            memberAttribute.add("organizationalPerson");
            memberAttribute.add("person");
            memberAttribute.add("top");
        }
        memberAttribute.add(user.getDN());
    }

    public void removeRole(LDAPRole role) {
        Attribute memberAttribute = this.attributes.get("member");
        if (memberAttribute != null) {
            memberAttribute.remove(role.getDN());
        }
    }

    public String getId() {
        return this.getName();
    }

    public void setName(String name) {
        this.groupName = name;
        Attribute theAttribute = this.attributes.get("cn");
        if (theAttribute == null) {
            this.attributes.put("cn", this.groupName);
        } else {
            theAttribute.set(0, this.groupName);
        }
        this.attributes.put("member", " ");
    }

    public String getName() {
        Attribute cnAttribute;
        if (this.groupName == null && (cnAttribute = this.attributes.get("cn")) != null) {
            try {
                this.groupName = (String)cnAttribute.get();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return this.groupName;
    }

    public void setParentGroup(Group parent) {
        LDAPGroup parentGroup;
        if (!(parent instanceof LDAPGroup)) {
            throw new RuntimeException("Wrong type:" + parent.getClass());
        }
        this.parent = parentGroup = (LDAPGroup)parent;
    }

    public Group getParentGroup() {
        return this.parent;
    }

    public void addChildGroup(LDAPGroup childGroup) {
        Attribute memberAttribute = this.attributes.get("member");
        if (memberAttribute != null) {
            if (memberAttribute.contains(" ")) {
                memberAttribute.remove(" ");
            }
            memberAttribute.add("cn=" + childGroup.getName() + "," + this.groupDNSuffix);
        }
    }

    public String getGroupDNSuffix() {
        return this.groupDNSuffix;
    }

    public void setGroupDNSuffix(String groupDNSuffix) {
        this.groupDNSuffix = groupDNSuffix;
    }
}

