/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import org.picketlink.idm.ldap.internal.DirContextAdaptor;
import org.picketlink.idm.ldap.internal.LDAPConstants;
import org.picketlink.idm.ldap.internal.LDAPUser;
import org.picketlink.idm.model.Role;

public class LDAPRole
extends DirContextAdaptor
implements Role {
    private static final long serialVersionUID = 1L;
    private String roleName;
    private String roleDNSuffix;

    public LDAPRole() {
        BasicAttribute oc = new BasicAttribute("objectclass");
        oc.add("top");
        oc.add(LDAPConstants.GROUP_OF_NAMES);
        this.attributes.put(oc);
    }

    public LDAPRole(Attributes ldapAttributes, String roleDNSuffix) {
        this.attributes = ldapAttributes;
        this.roleDNSuffix = roleDNSuffix;
    }

    public void setRoleDNSuffix(String rdns) {
        this.roleDNSuffix = rdns;
    }

    public String getDN() {
        return "cn=" + this.getAttribute("cn") + "," + this.roleDNSuffix;
    }

    public void setName(String roleName) {
        this.roleName = roleName;
        Attribute theAttribute = this.attributes.get("cn");
        if (theAttribute == null) {
            this.attributes.put("cn", roleName);
        } else {
            theAttribute.set(0, roleName);
        }
        this.attributes.put("member", " ");
    }

    public String getName() {
        Attribute cnAttribute;
        if (this.roleName == null && (cnAttribute = this.attributes.get("cn")) != null) {
            try {
                this.roleName = (String)cnAttribute.get();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return this.roleName;
    }

    public void addUser(LDAPUser user) {
        Attribute memberAttribute = this.attributes.get("member");
        if (memberAttribute != null) {
            if (memberAttribute.contains(" ")) {
                memberAttribute.remove(" ");
            }
        } else {
            memberAttribute = new BasicAttribute("objectclass");
            memberAttribute.add("inetOrgPerson");
            memberAttribute.add("organizationalPerson");
            memberAttribute.add("person");
            memberAttribute.add("top");
        }
        memberAttribute.add(user.getDN());
    }

    public void removeUser(LDAPUser user) {
        Attribute memberAttribute = this.attributes.get("member");
        if (memberAttribute != null) {
            memberAttribute.remove(user.getDN());
        }
    }
}

