/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.credential.Credential;
import org.picketlink.idm.credential.DigestCredential;
import org.picketlink.idm.credential.DigestCredentialUtil;
import org.picketlink.idm.credential.PasswordCredential;
import org.picketlink.idm.credential.X509CertificateCredential;
import org.picketlink.idm.file.internal.FileChangeListener;
import org.picketlink.idm.file.internal.FileGroup;
import org.picketlink.idm.file.internal.FileMembership;
import org.picketlink.idm.file.internal.FileRole;
import org.picketlink.idm.file.internal.FileUser;
import org.picketlink.idm.internal.util.Base64;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Membership;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.GroupQuery;
import org.picketlink.idm.query.MembershipQuery;
import org.picketlink.idm.query.Range;
import org.picketlink.idm.query.RoleQuery;
import org.picketlink.idm.query.UserQuery;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;

public class FileBasedIdentityStore
implements IdentityStore {
    private static final String USER_CERTIFICATE_ATTRIBUTE = "usercertificate";
    private static final String USER_PASSWORD_ATTRIBUTE = "userPassword";
    private File usersFile;
    private File rolesFile = new File("/tmp/pl-idm-work/pl-idm-roles.db");
    private File groupsFile = new File("/tmp/pl-idm-work/pl-idm-groups.db");
    private File membershipsFile = new File("/tmp/pl-idm-work/pl-idm-memberships.db");
    private Map<String, FileUser> users = new HashMap<String, FileUser>();
    private Map<String, Role> roles = new HashMap<String, Role>();
    private Map<String, FileGroup> groups = new HashMap<String, FileGroup>();
    private List<FileMembership> memberships = new ArrayList<FileMembership>();
    private FileChangeListener changeListener = new FileChangeListener(this);
    private String workingDir;
    private boolean alwaysCreateFiles = true;

    public FileBasedIdentityStore() {
        this.initialize();
    }

    public FileBasedIdentityStore(String workingDir, boolean alwaysCreateFiles) {
        this.workingDir = workingDir;
        this.alwaysCreateFiles = alwaysCreateFiles;
        this.initialize();
    }

    private void initialize() {
        this.initDataFiles();
        this.loadUsers();
        this.loadRoles();
        this.loadGroups();
        this.loadMemberships();
    }

    private void initDataFiles() {
        File workingDirectoryFile = this.initWorkingDirectory();
        this.usersFile = this.checkAndCreateFile(new File(workingDirectoryFile.getPath() + "/pl-idm-users.db"));
        this.rolesFile = this.checkAndCreateFile(new File(workingDirectoryFile.getPath() + "/pl-idm-roles.db"));
        this.groupsFile = this.checkAndCreateFile(new File(workingDirectoryFile.getPath() + "/pl-idm-groups.db"));
        this.membershipsFile = this.checkAndCreateFile(new File(workingDirectoryFile.getPath() + "/pl-idm-memberships.db"));
    }

    private File initWorkingDirectory() {
        File workingDirectoryFile;
        String workingDir = this.getWorkingDir();
        if (workingDir == null) {
            workingDir = System.getProperty("java.io.tmpdir");
        }
        if (!(workingDirectoryFile = new File(workingDir)).exists()) {
            workingDirectoryFile.mkdirs();
        }
        return workingDirectoryFile;
    }

    private File checkAndCreateFile(File file) {
        if (this.alwaysCreateFiles && file.exists()) {
            file.delete();
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGroups() {
        ObjectInputStream ois = null;
        try {
            FileInputStream fis = new FileInputStream(this.groupsFile);
            ois = new ObjectInputStream(fis);
            this.groups = (Map)ois.readObject();
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMemberships() {
        ObjectInputStream ois = null;
        try {
            FileInputStream fis = new FileInputStream(this.membershipsFile);
            ois = new ObjectInputStream(fis);
            this.memberships = (List)ois.readObject();
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRoles() {
        ObjectInputStream ois = null;
        try {
            FileInputStream fis = new FileInputStream(this.rolesFile);
            ois = new ObjectInputStream(fis);
            this.roles = (Map)ois.readObject();
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUsers() {
        ObjectInputStream ois = null;
        try {
            FileInputStream fis = new FileInputStream(this.usersFile);
            ois = new ObjectInputStream(fis);
            this.users = (Map)ois.readObject();
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {}
        }
    }

    synchronized void flushUsers() {
        try {
            FileOutputStream fos = new FileOutputStream(this.usersFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.users);
            oos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void flushRoles() {
        try {
            FileOutputStream fos = new FileOutputStream(this.rolesFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.roles);
            oos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void flushGroups() {
        try {
            FileOutputStream fos = new FileOutputStream(this.groupsFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.groups);
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    synchronized void flushMemberships() {
        try {
            FileOutputStream fos = new FileOutputStream(this.membershipsFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.memberships);
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Set<IdentityStore.Feature> getFeatureSet() {
        return null;
    }

    public void createUser(IdentityStoreInvocationContext ctx, User user) {
        FileUser fileUser;
        if (!(user instanceof FileUser)) {
            fileUser = new FileUser(user.getId());
            fileUser.setFirstName(user.getFirstName());
            fileUser.setLastName(user.getLastName());
            fileUser.setEmail(user.getEmail());
            for (String attribName : user.getAttributes().keySet()) {
                fileUser.setAttribute(attribName, user.getAttribute(attribName));
            }
        } else {
            fileUser = (FileUser)user;
        }
        fileUser.setChangeListener(this.changeListener);
        this.users.put(user.getId(), fileUser);
        this.flushUsers();
    }

    public void removeUser(IdentityStoreInvocationContext ctx, User user) {
        this.users.remove(user.getId());
        this.flushUsers();
    }

    public User getUser(IdentityStoreInvocationContext ctx, String name) {
        FileUser user = this.users.get(name);
        if (user != null) {
            user.setChangeListener(this.changeListener);
        }
        return user;
    }

    public Group createGroup(IdentityStoreInvocationContext ctx, String name, Group parent) {
        FileGroup group = new FileGroup(name, parent);
        this.groups.put(group.getName(), group);
        group.setChangeListener(this.changeListener);
        this.flushGroups();
        return group;
    }

    public void removeGroup(IdentityStoreInvocationContext ctx, Group group) {
        this.groups.remove(group.getName());
        this.flushGroups();
    }

    public Group getGroup(IdentityStoreInvocationContext ctx, String name) {
        FileGroup group = this.groups.get(name);
        if (group != null) {
            group.setChangeListener(this.changeListener);
        }
        return group;
    }

    public Role createRole(IdentityStoreInvocationContext ctx, String name) {
        FileRole role = new FileRole(name);
        this.roles.put(role.getName(), role);
        role.setChangeListener(this.changeListener);
        this.flushRoles();
        return role;
    }

    public void removeRole(IdentityStoreInvocationContext ctx, Role role) {
        this.roles.remove(role.getName());
        this.flushRoles();
    }

    public Role getRole(IdentityStoreInvocationContext ctx, String role) {
        FileRole fileRole = (FileRole)this.roles.get(role);
        if (fileRole != null) {
            fileRole.setChangeListener(this.changeListener);
        }
        return fileRole;
    }

    public Membership createMembership(IdentityStoreInvocationContext ctx, IdentityType member, Group group, Role role) {
        FileMembership membership = new FileMembership(member, group, role);
        this.memberships.add(membership);
        this.flushMemberships();
        return membership;
    }

    public void removeMembership(IdentityStoreInvocationContext ctx, IdentityType member, Group group, Role role) {
        for (Membership membership : new ArrayList<FileMembership>(this.memberships)) {
            boolean match = false;
            if (role != null) {
                boolean bl = match = membership.getRole() != null && role.equals(membership.getRole());
            }
            if (member != null) {
                boolean bl = match = membership.getMember() != null && member.equals(membership.getMember());
            }
            if (group != null) {
                boolean bl = match = membership.getGroup() != null && group.equals(membership.getGroup());
            }
            if (!match) continue;
            this.memberships.remove(membership);
        }
        this.flushMemberships();
    }

    public Membership getMembership(IdentityStoreInvocationContext ctx, IdentityType member, Group group, Role role) {
        for (Membership membership : new ArrayList<FileMembership>(this.memberships)) {
            boolean match = false;
            match = role != null ? membership.getRole() != null && role.equals(membership.getRole()) : true;
            match = member != null ? membership.getMember() != null && member.equals(membership.getMember()) : true;
            match = group != null ? membership.getGroup() != null && group.equals(membership.getGroup()) : true;
            if (!match) continue;
            return membership;
        }
        return null;
    }

    public List<User> executeQuery(IdentityStoreInvocationContext ctx, UserQuery query, Range range) {
        ArrayList<User> users = new ArrayList<User>();
        for (Map.Entry<String, FileUser> entry : this.users.entrySet()) {
            FileUser fileUser = entry.getValue();
            if (query.getName() != null && !fileUser.getId().equals(query.getName()) || query.getEnabled() != fileUser.isEnabled() || query.getEmail() != null && !query.getEmail().equals(fileUser.getEmail()) || query.getFirstName() != null && !query.getFirstName().equals(fileUser.getFirstName()) || query.getLastName() != null && !query.getLastName().equals(fileUser.getLastName())) continue;
            users.add(fileUser);
        }
        Collection<Object> selectedUsers = users;
        if (users.isEmpty()) {
            selectedUsers = this.users.values();
        }
        if (query.getRole() != null || query.getRelatedGroup() != null) {
            ArrayList<User> fileteredUsers = new ArrayList<User>();
            for (User fileUser : new ArrayList(selectedUsers)) {
                for (Membership membership : this.memberships) {
                    if (query.getRole() != null && membership.getRole() == null || query.getRelatedGroup() != null && membership.getGroup() == null || membership.getMember() == null || !membership.getMember().equals(fileUser) || query.getRole() != null && !membership.getRole().equals(query.getRole()) || query.getRelatedGroup() != null && !membership.getGroup().equals(query.getRelatedGroup())) continue;
                    fileteredUsers.add(fileUser);
                }
            }
            users.retainAll(fileteredUsers);
        }
        Map queryAttributes = query.getAttributeFilters();
        this.searchForIdentityTypeAttributes(users, queryAttributes);
        return users;
    }

    public List<Group> executeQuery(IdentityStoreInvocationContext ctx, GroupQuery query, Range range) {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Map.Entry<String, FileGroup> entry : this.groups.entrySet()) {
            FileGroup fileGroup = entry.getValue();
            if (query.getName() != null && !fileGroup.getKey().equals(query.getName()) || query.getId() != null && !query.getId().equals(fileGroup.getId()) || query.getParentGroup() != null && (fileGroup.getParentGroup() == null || !query.getParentGroup().equals(fileGroup.getParentGroup()))) continue;
            groups.add(fileGroup);
        }
        Collection<Object> selectedGroups = groups;
        if (groups.isEmpty()) {
            selectedGroups = this.groups.values();
        }
        if (query.getRole() != null || query.getRelatedUser() != null) {
            ArrayList<Group> fileteredGroups = new ArrayList<Group>();
            for (Group fileGroup : new ArrayList<Group>(selectedGroups)) {
                for (Membership membership : this.memberships) {
                    if (query.getRole() != null && membership.getRole() == null || query.getRelatedUser() != null && membership.getMember() == null || membership.getGroup() == null || !membership.getGroup().equals(fileGroup) || query.getRole() != null && !membership.getRole().equals(query.getRole()) || query.getRelatedUser() != null && !membership.getMember().equals(query.getRelatedUser())) continue;
                    fileteredGroups.add(fileGroup);
                }
            }
            groups.retainAll(fileteredGroups);
        }
        if (query.getAttributeFilters() != null && !query.getAttributeFilters().isEmpty()) {
            this.searchForIdentityTypeAttributes(groups, query.getAttributeFilters());
        }
        return groups;
    }

    public List<Role> executeQuery(IdentityStoreInvocationContext ctx, RoleQuery query, Range range) {
        Role role;
        ArrayList<Role> roles = new ArrayList<Role>();
        if (query.getName() != null && (role = this.getRole(ctx, query.getName())) != null) {
            roles.add(role);
        }
        if (query.getOwner() != null || query.getGroup() != null) {
            for (Membership membership : this.memberships) {
                if (membership.getRole() == null || query.getOwner() != null && (membership.getMember() == null || !membership.getMember().getKey().equals(query.getOwner().getKey())) || query.getGroup() != null && (membership.getGroup() == null || !membership.getGroup().getKey().equals(query.getGroup().getKey()))) continue;
                roles.add(membership.getRole());
            }
        }
        if (query.getAttributeFilters() != null && !query.getAttributeFilters().isEmpty()) {
            this.searchForIdentityTypeAttributes(roles, query.getAttributeFilters());
        }
        return roles;
    }

    public List<Membership> executeQuery(IdentityStoreInvocationContext ctx, MembershipQuery query, Range range) {
        ArrayList<Membership> memberships = new ArrayList<Membership>();
        for (Membership membership : this.memberships) {
            if (query.getRole() != null && membership.getRole() == null || query.getGroup() != null && membership.getGroup() == null || query.getUser() != null && membership.getMember() == null || query.getRole() != null && !membership.getRole().equals(query.getRole()) || query.getGroup() != null && !membership.getGroup().equals(query.getGroup()) || query.getUser() != null && !membership.getMember().equals(query.getUser())) continue;
            memberships.add(membership);
        }
        return memberships;
    }

    public void setAttribute(IdentityStoreInvocationContext ctx, IdentityType identityType, String name, String[] values) {
        if (identityType instanceof FileUser) {
            FileUser user = (FileUser)identityType;
            FileUser fileUser = (FileUser)this.getUser(ctx, user.getId());
            fileUser.setAttribute(name, values);
            this.flushUsers();
        } else if (identityType instanceof FileRole) {
            FileRole role = (FileRole)identityType;
            FileRole fileRole = (FileRole)this.getRole(ctx, role.getName());
            fileRole.setAttribute(name, values);
            this.flushRoles();
        } else if (identityType instanceof FileGroup) {
            FileGroup group = (FileGroup)identityType;
            FileGroup fileGroup = (FileGroup)this.getGroup(ctx, group.getName());
            fileGroup.setAttribute(name, values);
            this.flushRoles();
        } else {
            this.throwsNotSupportedIdentityType(identityType);
        }
    }

    public void removeAttribute(IdentityStoreInvocationContext ctx, IdentityType identityType, String name) {
        if (identityType instanceof FileUser) {
            FileUser user = (FileUser)identityType;
            FileUser fileUser = (FileUser)this.getUser(ctx, user.getId());
            if (fileUser != null) {
                this.users.remove(fileUser.getId());
            }
            this.flushUsers();
        } else if (identityType instanceof FileRole) {
            FileRole role = (FileRole)identityType;
            FileRole fileRole = (FileRole)this.getRole(ctx, role.getName());
            if (fileRole != null) {
                this.roles.remove(fileRole.getName());
            }
            this.flushRoles();
        } else if (identityType instanceof FileGroup) {
            FileGroup group = (FileGroup)identityType;
            FileGroup fileGroup = (FileGroup)this.getGroup(ctx, group.getName());
            if (fileGroup != null) {
                this.groups.remove(fileGroup.getName());
            }
            this.flushRoles();
        } else {
            this.throwsNotSupportedIdentityType(identityType);
        }
    }

    public String[] getAttributeValues(IdentityStoreInvocationContext ctx, IdentityType identityType, String name) {
        if (identityType instanceof FileUser) {
            FileUser user = (FileUser)identityType;
            FileUser fileUser = (FileUser)this.getUser(ctx, user.getId());
            if (fileUser != null) {
                return fileUser.getAttributeValues(name);
            }
        } else if (identityType instanceof FileRole) {
            FileRole role = (FileRole)identityType;
            FileRole fileRole = (FileRole)this.getRole(ctx, role.getName());
            if (fileRole != null) {
                return fileRole.getAttributeValues(name);
            }
        } else if (identityType instanceof FileGroup) {
            FileGroup group = (FileGroup)identityType;
            FileGroup fileGroup = (FileGroup)this.getGroup(ctx, group.getName());
            if (fileGroup != null) {
                return fileGroup.getAttributeValues(name);
            }
            this.flushRoles();
        } else {
            this.throwsNotSupportedIdentityType(identityType);
        }
        return null;
    }

    public Map<String, String[]> getAttributes(IdentityStoreInvocationContext ctx, IdentityType identityType) {
        if (identityType instanceof FileUser) {
            FileUser user = (FileUser)identityType;
            FileUser fileUser = (FileUser)this.getUser(ctx, user.getId());
            if (fileUser != null) {
                return fileUser.getAttributes();
            }
        } else if (identityType instanceof FileRole) {
            FileRole role = (FileRole)identityType;
            FileRole fileRole = (FileRole)this.getRole(ctx, role.getName());
            if (fileRole != null) {
                return fileRole.getAttributes();
            }
        } else if (identityType instanceof FileGroup) {
            FileGroup group = (FileGroup)identityType;
            FileGroup fileGroup = (FileGroup)this.getGroup(ctx, group.getName());
            if (fileGroup != null) {
                return fileGroup.getAttributes();
            }
            this.flushRoles();
        } else {
            this.throwsNotSupportedIdentityType(identityType);
        }
        return null;
    }

    public boolean validateCredential(IdentityStoreInvocationContext ctx, User user, Credential credential) {
        if (credential instanceof PasswordCredential) {
            PasswordCredential passwordCredential = (PasswordCredential)credential;
            User storedUser = this.getUser(ctx, user.getId());
            String storedPassword = storedUser.getAttribute(USER_PASSWORD_ATTRIBUTE);
            return storedPassword != null && storedPassword.equals(passwordCredential.getPassword());
        }
        if (credential instanceof DigestCredential) {
            DigestCredential digestCredential = (DigestCredential)credential;
            User storedUser = this.getUser(ctx, user.getId());
            String storedPassword = storedUser.getAttribute(USER_PASSWORD_ATTRIBUTE);
            return DigestCredentialUtil.matchCredential((DigestCredential)digestCredential, (char[])storedPassword.toCharArray());
        }
        if (credential instanceof X509CertificateCredential) {
            X509CertificateCredential certCredential = (X509CertificateCredential)credential;
            User storedUser = this.getUser(ctx, user.getId());
            String storedCert = storedUser.getAttribute(USER_CERTIFICATE_ATTRIBUTE);
            if (storedCert != null) {
                try {
                    return storedCert.equals(new String(Base64.encodeBytes(certCredential.getCertificate().getEncoded())));
                }
                catch (CertificateEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            this.throwsNotSupportedCredentialType(credential);
        }
        return false;
    }

    public void updateCredential(IdentityStoreInvocationContext ctx, User user, Credential credential) {
        if (credential instanceof PasswordCredential) {
            PasswordCredential passwordCredential = (PasswordCredential)credential;
            User storedUser = this.getUser(ctx, user.getId());
            storedUser.setAttribute(USER_PASSWORD_ATTRIBUTE, passwordCredential.getPassword());
            this.flushUsers();
        } else if (credential instanceof X509CertificateCredential) {
            X509CertificateCredential certCredential = (X509CertificateCredential)credential;
            User storedUser = this.getUser(ctx, user.getId());
            try {
                storedUser.setAttribute(USER_CERTIFICATE_ATTRIBUTE, new String(Base64.encodeBytes(certCredential.getCertificate().getEncoded())));
            }
            catch (CertificateEncodingException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.throwsNotSupportedCredentialType(credential);
        }
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public void setAlwaysCreateFiles(boolean alwaysCreateFiles) {
        this.alwaysCreateFiles = alwaysCreateFiles;
    }

    private void searchForIdentityTypeAttributes(List<? extends IdentityType> users, Map<String, String[]> queryAttributes) {
        if (queryAttributes != null) {
            Set<Map.Entry<String, String[]>> entrySet = queryAttributes.entrySet();
            for (IdentityType identityType : new ArrayList<IdentityType>(users)) {
                for (Map.Entry<String, String[]> entry : entrySet) {
                    String searchAttributeKey = entry.getKey();
                    String[] searchAttributeValue = entry.getValue();
                    String[] userAttributes = identityType.getAttributeValues(searchAttributeKey);
                    if (userAttributes == null) {
                        users.remove(identityType);
                        continue;
                    }
                    if (Collections.indexOfSubList(Arrays.asList(userAttributes), Arrays.asList(searchAttributeValue)) <= 0) continue;
                    users.remove(identityType);
                }
            }
        }
    }

    private void throwsNotSupportedCredentialType(Credential credential) throws IllegalArgumentException {
        throw new IllegalArgumentException("Credential type not supported: " + credential.getClass());
    }

    private void throwsNotSupportedIdentityType(IdentityType identityType) throws IllegalArgumentException {
        throw new IllegalArgumentException("IdentityType not supported: " + identityType.getClass());
    }
}

