/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.Credential;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.model.User;
import org.picketlink.idm.password.PasswordEncoder;
import org.picketlink.idm.query.GroupQuery;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.MembershipQuery;
import org.picketlink.idm.query.RoleQuery;
import org.picketlink.idm.query.UserQuery;
import org.picketlink.idm.query.internal.DefaultGroupQuery;
import org.picketlink.idm.query.internal.DefaultMembershipQuery;
import org.picketlink.idm.query.internal.DefaultRoleQuery;
import org.picketlink.idm.query.internal.DefaultUserQuery;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;

public class DefaultIdentityManager
implements IdentityManager {
    private IdentityStore store = null;
    private PasswordEncoder passwordEncoder;

    public DefaultIdentityManager() {
    }

    public DefaultIdentityManager(IdentityStore theStore) {
        this.store = theStore;
    }

    public void setIdentityStore(IdentityStore theStore) {
        this.store = theStore;
    }

    public User createUser(String name) {
        this.ensureStoreExists();
        SimpleUser user = new SimpleUser(name);
        this.store.createUser(this.getInvocationContext(this.store), (User)user);
        return user;
    }

    public void createUser(User user) {
        this.ensureStoreExists();
        this.store.createUser(this.getInvocationContext(this.store), user);
    }

    public void removeUser(User user) {
        this.ensureStoreExists();
        this.store.removeUser(this.getInvocationContext(this.store), user);
    }

    public void removeUser(String name) {
        this.ensureStoreExists();
        this.store.removeUser(this.getInvocationContext(this.store), this.getUser(name));
    }

    public User getUser(String name) {
        this.ensureStoreExists();
        return this.store.getUser(this.getInvocationContext(this.store), name);
    }

    public Collection<User> getAllUsers() {
        throw new RuntimeException();
    }

    public Group createGroup(String id) {
        return this.store.createGroup(this.getInvocationContext(this.store), id, null);
    }

    public Group createGroup(String id, Group parent) {
        this.ensureStoreExists();
        return this.store.createGroup(this.getInvocationContext(this.store), id, parent);
    }

    public Group createGroup(String id, String parent) {
        this.ensureStoreExists();
        Group parentGroup = this.store.getGroup(this.getInvocationContext(this.store), parent);
        return this.store.createGroup(this.getInvocationContext(this.store), id, parentGroup);
    }

    public void removeGroup(Group group) {
        this.ensureStoreExists();
        this.store.removeGroup(this.getInvocationContext(this.store), group);
    }

    public void removeGroup(String groupId) {
        this.ensureStoreExists();
        this.store.removeGroup(this.getInvocationContext(this.store), this.getGroup(groupId));
    }

    public Group getGroup(String groupId) {
        this.ensureStoreExists();
        return this.store.getGroup(this.getInvocationContext(this.store), groupId);
    }

    public Group getGroup(String groupId, Group parent) {
        this.ensureStoreExists();
        return this.getGroup(groupId);
    }

    public Collection<Group> getAllGroups() {
        throw new RuntimeException();
    }

    public void addToGroup(IdentityType identityType, Group group) {
        throw new RuntimeException();
    }

    public void removeFromGroup(IdentityType identityType, Group group) {
        throw new RuntimeException();
    }

    public Collection<IdentityType> getGroupMembers(Group group) {
        throw new RuntimeException();
    }

    public Role createRole(String name) {
        this.ensureStoreExists();
        return this.store.createRole(this.getInvocationContext(this.store), name);
    }

    public void removeRole(Role role) {
        this.ensureStoreExists();
        this.store.removeRole(this.getInvocationContext(this.store), role);
    }

    public void removeRole(String name) {
        this.ensureStoreExists();
        this.store.removeRole(this.getInvocationContext(this.store), this.getRole(name));
    }

    public Role getRole(String name) {
        this.ensureStoreExists();
        return this.store.getRole(this.getInvocationContext(this.store), name);
    }

    public Collection<Role> getAllRoles() {
        throw new RuntimeException();
    }

    public Collection<Role> getRoles(IdentityType identityType, Group group) {
        RoleQuery query = this.createRoleQuery();
        if (query == null) {
            return Collections.EMPTY_LIST;
        }
        query.setGroup(group);
        query.setOwner(identityType);
        return query.executeQuery();
    }

    public boolean hasRole(Role role, IdentityType identityType, Group group) {
        if (!(identityType instanceof User)) {
            throw new IllegalArgumentException("For now only the User type is supported as the IdentityType argument.");
        }
        MembershipQuery query = this.createMembershipQuery();
        query.setRole(role);
        query.setGroup(group);
        query.setUser((User)identityType);
        return !query.executeQuery().isEmpty();
    }

    public void grantRole(Role role, IdentityType identityType, Group group) {
        this.store.createMembership(this.getInvocationContext(this.store), identityType, group, role);
    }

    public void revokeRole(Role role, IdentityType identityType, Group group) {
        throw new RuntimeException();
    }

    public UserQuery createUserQuery() {
        return new DefaultUserQuery(this.store);
    }

    public GroupQuery createGroupQuery() {
        return new DefaultGroupQuery(this.store);
    }

    public MembershipQuery createMembershipQuery() {
        return new DefaultMembershipQuery(this.store);
    }

    public boolean validateCredential(User user, Credential credential) {
        return this.store.validateCredential(this.getInvocationContext(this.store), user, credential);
    }

    public void updateCredential(User user, Credential credential) {
        this.store.updateCredential(this.getInvocationContext(this.store), user, credential);
    }

    public void setEnabled(IdentityType identityType, boolean enabled) {
        throw new RuntimeException();
    }

    public void setExpirationDate(IdentityType identityType, Date expirationDate) {
        throw new RuntimeException();
    }

    private void ensureStoreExists() {
        if (this.store == null) {
            throw new RuntimeException("Identity Store has not been set");
        }
    }

    protected IdentityStoreInvocationContext getInvocationContext(IdentityStore store) {
        return null;
    }

    public RoleQuery createRoleQuery() {
        return new DefaultRoleQuery(this.store);
    }

    public IdentityType lookupIdentityByKey(String key) {
        return null;
    }

    public <T extends IdentityType> IdentityQuery<T> createQuery() {
        return null;
    }
}

