/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.credential.Credential;
import org.picketlink.idm.internal.util.properties.Property;
import org.picketlink.idm.internal.util.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.idm.internal.util.properties.query.NamedPropertyCriteria;
import org.picketlink.idm.internal.util.properties.query.PropertyCriteria;
import org.picketlink.idm.internal.util.properties.query.PropertyQueries;
import org.picketlink.idm.internal.util.properties.query.TypedPropertyCriteria;
import org.picketlink.idm.jpa.annotations.IDMAttribute;
import org.picketlink.idm.jpa.annotations.IDMProperty;
import org.picketlink.idm.jpa.annotations.PropertyType;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Membership;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.GroupQuery;
import org.picketlink.idm.query.MembershipQuery;
import org.picketlink.idm.query.Range;
import org.picketlink.idm.query.RoleQuery;
import org.picketlink.idm.query.UserQuery;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.JPAIdentityStoreConfiguration;
import org.picketlink.idm.spi.JPAIdentityStoreSession;

public class JPAIdentityStore
implements IdentityStore {
    private static final String DEFAULT_USER_IDENTITY_DISCRIMINATOR = "USER";
    private static final String DEFAULT_ROLE_IDENTITY_DISCRIMINATOR = "ROLE";
    private static final String DEFAULT_GROUP_IDENTITY_DISCRIMINATOR = "GROUP";
    private static final String PROPERTY_IDENTITY_DISCRIMINATOR = "IDENTITY_DISCRIMINATOR";
    private static final String PROPERTY_IDENTITY_KEY = "IDENTITY_KEY";
    private static final String PROPERTY_IDENTITY_ENABLED = "IDENTITY_ENABLED";
    private static final String PROPERTY_IDENTITY_CREATED = "IDENTITY_CREATED";
    private static final String PROPERTY_IDENTITY_EXPIRES = "IDENTITY_EXPIRES";
    private static final String PROPERTY_USER_FIRST_NAME = "USER_FIRST_NAME";
    private static final String PROPERTY_USER_LAST_NAME = "USER_LAST_NAME";
    private static final String PROPERTY_USER_EMAIL = "USER_EMAIL";
    private static final String PROPERTY_IDENTITY_ID = "IDENTITY_ID";
    private static final String PROPERTY_IDENTITY_NAME = "IDENTITY_NAME";
    private static final String PROPERTY_PARENT_GROUP = "PARENT_GROUP";
    private static final String PROPERTY_MEMBERSHIP_MEMBER = "MEMBERSHIP_MEMBER";
    private static final String PROPERTY_MEMBERSHIP_ROLE = "MEMBERSHIP_ROLE";
    private static final String PROPERTY_MEMBERSHIP_GROUP = "MEMBERSHIP_GROUP";
    private static final String PROPERTY_CREDENTIAL_VALUE = "CREDENTIAL_VALUE";
    private static final String PROPERTY_CREDENTIAL_TYPE = "CREDENTIAL_TYPE";
    private static final String PROPERTY_CREDENTIAL_TYPE_NAME = "CREDENTIAL_TYPE_NAME";
    private static final String PROPERTY_CREDENTIAL_IDENTITY = "CREDENTIAL_IDENTITY";
    private static final String PROPERTY_ATTRIBUTE_NAME = "ATTRIBUTE_NAME";
    private static final String PROPERTY_ATTRIBUTE_VALUE = "ATTRIBUTE_VALUE";
    private static final String PROPERTY_ATTRIBUTE_IDENTITY = "ATTRIBUTE_IDENTITY";
    private static final String PROPERTY_ATTRIBUTE_TYPE = "ATTRIBUTE_TYPE";
    private static final String ATTRIBUTE_TYPE_TEXT = "text";
    private static final String ATTRIBUTE_TYPE_BOOLEAN = "boolean";
    private static final String ATTRIBUTE_TYPE_DATE = "date";
    private static final String ATTRIBUTE_TYPE_INT = "int";
    private static final String ATTRIBUTE_TYPE_LONG = "long";
    private static final String ATTRIBUTE_TYPE_FLOAT = "float";
    private static final String ATTRIBUTE_TYPE_DOUBLE = "double";
    private Set<IdentityStore.Feature> featureSet = new HashSet<IdentityStore.Feature>();
    private Class<?> identityClass;
    private Class<?> membershipClass;
    private Class<?> credentialClass;
    private Class<?> attributeClass;
    private Map<String, Property<Object>> modelProperties = new HashMap<String, Property<Object>>();
    private Map<String, MappedAttribute> attributeProperties = new HashMap<String, MappedAttribute>();
    private String identityTypeUser = "USER";
    private String identityTypeRole = "ROLE";
    private String identityTypeGroup = "GROUP";

    protected Property<Object> findNamedProperty(Class<?> targetClass, String ... allowedNames) {
        List props = PropertyQueries.createQuery(targetClass).addCriteria(new TypedPropertyCriteria(String.class)).addCriteria(new NamedPropertyCriteria(allowedNames)).getResultList();
        for (String name : allowedNames) {
            for (Property<Object> property : props) {
                if (!name.equals(property.getName())) continue;
                return property;
            }
        }
        return null;
    }

    public void bootstrap(JPAIdentityStoreConfiguration config) throws SecurityConfigurationException {
        this.identityClass = config.getIdentityClass();
        if (this.identityClass == null) {
            throw new SecurityConfigurationException("Error initializing JpaIdentityStore - identityClass not set");
        }
        this.credentialClass = config.getCredentialClass();
        this.membershipClass = config.getMembershipClass();
        this.attributeClass = config.getAttributeClass();
        this.configureIdentityDiscriminator();
        this.configureIdentityKey();
        this.configureIdentityId();
        this.configureIdentityName();
        this.configureIdentityParentGroup();
        this.configureIdentityEnabled();
        this.configureIdentityCreationDate();
        this.configureIdentityExpiryDate();
        this.configureUserProperties();
        this.configureMemberships();
        this.configureAttributes();
    }

    protected void configureIdentityDiscriminator() throws SecurityConfigurationException {
        List props = PropertyQueries.createQuery(this.identityClass).addCriteria(new PropertyTypeCriteria(PropertyType.DISCRIMINATOR)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_IDENTITY_DISCRIMINATOR, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous identity discriminator property in identity class " + this.identityClass.getName());
            }
            Property<Object> p = this.findNamedProperty(this.identityClass, "discriminator", "identityType", "identityTypeName", "typeName", "type");
            if (p != null) {
                this.modelProperties.put(PROPERTY_IDENTITY_DISCRIMINATOR, p);
            }
        }
    }

    protected void configureIdentityKey() throws SecurityConfigurationException {
        List props = PropertyQueries.createQuery(this.identityClass).addCriteria(new PropertyTypeCriteria(PropertyType.KEY)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_IDENTITY_KEY, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous identity key property in identity class " + this.identityClass.getName());
            }
            props = PropertyQueries.createQuery(this.identityClass).addCriteria(new NamedPropertyCriteria("key")).getResultList();
            if (!props.isEmpty()) {
                this.modelProperties.put(PROPERTY_IDENTITY_KEY, props.get(0));
            } else {
                throw new SecurityConfigurationException("Error initializing JPAIdentityStore - no key property found in identity class " + this.identityClass.getName());
            }
        }
    }

    protected void configureIdentityId() throws SecurityConfigurationException {
        List props = PropertyQueries.createQuery(this.identityClass).addCriteria(new PropertyTypeCriteria(PropertyType.ID)).getResultList();
        if (props.size() != 1) {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous identity id property in identity class " + this.identityClass.getName());
            }
            throw new SecurityConfigurationException("Error initializing JPAIdentityStore - no id property found in identity class " + this.identityClass.getName());
        }
        this.modelProperties.put(PROPERTY_IDENTITY_ID, props.get(0));
    }

    protected void configureIdentityName() throws SecurityConfigurationException {
        List props = PropertyQueries.createQuery(this.identityClass).addCriteria(new PropertyTypeCriteria(PropertyType.NAME)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_IDENTITY_NAME, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous identity name property in identity class " + this.identityClass.getName());
            }
            Property<Object> prop = this.findNamedProperty(this.identityClass, "name");
            if (prop != null) {
                this.modelProperties.put(PROPERTY_IDENTITY_NAME, prop);
            } else {
                throw new SecurityConfigurationException("Error initializing JPAIdentityStore - no name property found in identity class " + this.identityClass.getName());
            }
        }
    }

    protected void configureIdentityParentGroup() throws SecurityConfigurationException {
        List props = PropertyQueries.createQuery(this.identityClass).addCriteria(new PropertyTypeCriteria(PropertyType.PARENT_GROUP)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_PARENT_GROUP, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous identity parent group property in identity class " + this.identityClass.getName());
            }
            Property<Object> prop = this.findNamedProperty(this.identityClass, "parentGroup", "parent");
            if (prop != null) {
                this.modelProperties.put(PROPERTY_PARENT_GROUP, prop);
            } else {
                throw new SecurityConfigurationException("Error initializing JPAIdentityStore - no parent group property found in identity class " + this.identityClass.getName());
            }
        }
    }

    protected void configureIdentityEnabled() throws SecurityConfigurationException {
        List props = PropertyQueries.createQuery(this.identityClass).addCriteria(new PropertyTypeCriteria(PropertyType.ENABLED)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_IDENTITY_ENABLED, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous identity enabled property in identity class " + this.identityClass.getName());
            }
            Property<Object> prop = this.findNamedProperty(this.identityClass, "enabled", "active");
            if (prop != null) {
                this.modelProperties.put(PROPERTY_IDENTITY_ENABLED, props.get(0));
            }
        }
    }

    protected void configureIdentityCreationDate() throws SecurityConfigurationException {
        List props = PropertyQueries.createQuery(this.identityClass).addCriteria(new PropertyTypeCriteria(PropertyType.CREATION_DATE)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_IDENTITY_CREATED, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous identity creation date property in identity class " + this.identityClass.getName());
            }
            Property<Object> prop = this.findNamedProperty(this.identityClass, "created", "creationDate");
            if (prop != null) {
                this.modelProperties.put(PROPERTY_IDENTITY_CREATED, prop);
            }
        }
    }

    protected void configureIdentityExpiryDate() throws SecurityConfigurationException {
        List props = PropertyQueries.createQuery(this.identityClass).addCriteria(new PropertyTypeCriteria(PropertyType.EXPIRY_DATE)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_IDENTITY_EXPIRES, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous identity expiry date property in identity class " + this.identityClass.getName());
            }
            Property<Object> prop = this.findNamedProperty(this.identityClass, "expires", "expiryDate");
            if (prop != null) {
                this.modelProperties.put(PROPERTY_IDENTITY_EXPIRES, prop);
            }
        }
    }

    protected void configureUserProperties() throws SecurityConfigurationException {
        Property<Object> prop;
        List props = PropertyQueries.createQuery(this.identityClass).addCriteria(new PropertyTypeCriteria(PropertyType.FIRST_NAME)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_USER_FIRST_NAME, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous first name property in identity class " + this.identityClass.getName());
            }
            prop = this.findNamedProperty(this.identityClass, "firstName");
            if (prop != null) {
                this.modelProperties.put(PROPERTY_USER_FIRST_NAME, prop);
            }
        }
        props = PropertyQueries.createQuery(this.identityClass).addCriteria(new PropertyTypeCriteria(PropertyType.LAST_NAME)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_USER_LAST_NAME, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous last name property in identity class " + this.identityClass.getName());
            }
            prop = this.findNamedProperty(this.identityClass, "lastName");
            if (prop != null) {
                this.modelProperties.put(PROPERTY_USER_LAST_NAME, prop);
            }
        }
        props = PropertyQueries.createQuery(this.identityClass).addCriteria(new PropertyTypeCriteria(PropertyType.EMAIL)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_USER_EMAIL, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous e-mail property in identity class " + this.identityClass.getName());
            }
            prop = this.findNamedProperty(this.identityClass, "email");
            if (prop != null) {
                this.modelProperties.put(PROPERTY_USER_EMAIL, prop);
            }
        }
    }

    protected void configureMemberships() throws SecurityConfigurationException {
        Property<Object> p;
        if (this.membershipClass == null) {
            return;
        }
        List props = PropertyQueries.createQuery(this.membershipClass).addCriteria(new TypedPropertyCriteria(this.identityClass)).addCriteria(new PropertyTypeCriteria(PropertyType.MEMBER)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_MEMBERSHIP_MEMBER, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous member property in membership class " + this.membershipClass.getName());
            }
            p = this.findNamedProperty(this.membershipClass, "member");
            if (p != null) {
                this.modelProperties.put(PROPERTY_MEMBERSHIP_MEMBER, p);
            } else {
                throw new SecurityConfigurationException("Error initializing JPAIdentityStore - no member property found in membership class " + this.membershipClass.getName());
            }
        }
        props = PropertyQueries.createQuery(this.membershipClass).addCriteria(new TypedPropertyCriteria(this.identityClass)).addCriteria(new PropertyTypeCriteria(PropertyType.GROUP)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_MEMBERSHIP_GROUP, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous group property in membership class " + this.membershipClass.getName());
            }
            p = this.findNamedProperty(this.membershipClass, "group");
            if (p != null) {
                this.modelProperties.put(PROPERTY_MEMBERSHIP_GROUP, p);
            } else {
                throw new SecurityConfigurationException("Error initializing JPAIdentityStore - no group property found in membership class " + this.membershipClass.getName());
            }
        }
        props = PropertyQueries.createQuery(this.membershipClass).addCriteria(new TypedPropertyCriteria(this.identityClass)).addCriteria(new PropertyTypeCriteria(PropertyType.ROLE)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_MEMBERSHIP_ROLE, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous role property in membership class " + this.membershipClass.getName());
            }
            p = this.findNamedProperty(this.membershipClass, "role");
            if (p != null) {
                this.modelProperties.put(PROPERTY_MEMBERSHIP_ROLE, p);
            } else {
                throw new SecurityConfigurationException("Error initializing JPAIdentityStore - no role property found in membership class " + this.membershipClass.getName());
            }
        }
    }

    protected void configureAttributes() throws SecurityConfigurationException {
        List props;
        if (this.attributeClass != null) {
            Property<Object> prop;
            props = PropertyQueries.createQuery(this.attributeClass).addCriteria(new PropertyTypeCriteria(PropertyType.NAME)).addCriteria(new TypedPropertyCriteria(String.class)).getResultList();
            if (props.size() == 1) {
                this.modelProperties.put(PROPERTY_ATTRIBUTE_NAME, props.get(0));
            } else {
                if (props.size() > 1) {
                    throw new SecurityConfigurationException("Ambiguous attribute name property in attribute class " + this.attributeClass.getName());
                }
                prop = this.findNamedProperty(this.attributeClass, "attributeName", "name");
                if (prop != null) {
                    this.modelProperties.put(PROPERTY_ATTRIBUTE_NAME, prop);
                } else {
                    throw new SecurityConfigurationException("Error initializing JPAIdentityStore - no name property found in attribute class " + this.attributeClass.getName());
                }
            }
            props = PropertyQueries.createQuery(this.attributeClass).addCriteria(new PropertyTypeCriteria(PropertyType.VALUE)).getResultList();
            if (props.size() == 1) {
                this.modelProperties.put(PROPERTY_ATTRIBUTE_VALUE, props.get(0));
            } else {
                if (props.size() > 1) {
                    throw new SecurityConfigurationException("Ambiguous attribute value property in class " + this.attributeClass.getName());
                }
                prop = this.findNamedProperty(this.attributeClass, "attributeValue", "value");
                if (prop != null) {
                    this.modelProperties.put(PROPERTY_ATTRIBUTE_VALUE, prop);
                } else {
                    throw new SecurityConfigurationException("Error initializing JPAIdentityStore - no value property found in attribute class " + this.attributeClass.getName());
                }
            }
            props = PropertyQueries.createQuery(this.attributeClass).addCriteria(new TypedPropertyCriteria(this.identityClass)).getResultList();
            if (props.size() != 1) {
                if (props.size() > 1) {
                    throw new SecurityConfigurationException("Ambiguous identity property in attribute class " + this.attributeClass.getName());
                }
                throw new SecurityConfigurationException("Error initializing JPAIdentityStore - no attribute identity property found.");
            }
            this.modelProperties.put(PROPERTY_ATTRIBUTE_IDENTITY, props.get(0));
            props = PropertyQueries.createQuery(this.attributeClass).addCriteria(new PropertyTypeCriteria(PropertyType.ATTRIBUTE_TYPE)).getResultList();
            if (props.size() == 1) {
                this.modelProperties.put(PROPERTY_ATTRIBUTE_TYPE, props.get(0));
            } else {
                if (props.size() > 1) {
                    throw new SecurityConfigurationException("Ambiguous attribute type property in class " + this.attributeClass.getName());
                }
                prop = this.findNamedProperty(this.attributeClass, "attributeType", "type");
                if (prop != null) {
                    this.modelProperties.put(PROPERTY_ATTRIBUTE_TYPE, prop);
                } else {
                    throw new SecurityConfigurationException("Error initializing JPAIdentityStore - no attribute type property found in attribute class " + this.attributeClass.getName());
                }
            }
        }
        props = PropertyQueries.createQuery(this.identityClass).addCriteria(new AnnotatedPropertyCriteria(IDMAttribute.class)).getResultList();
        for (Property<Object> property : props) {
            String attribName = property.getAnnotatedElement().getAnnotation(IDMAttribute.class).name();
            if (this.attributeProperties.containsKey(attribName)) {
                Property<Object> other = this.attributeProperties.get(attribName).getAttributeProperty();
                throw new SecurityConfigurationException("Multiple properties defined for attribute [" + attribName + "] - " + "Property: " + other.getDeclaringClass().getName() + "." + other.getAnnotatedElement().toString() + ", Property: " + property.getDeclaringClass().getName() + "." + property.getAnnotatedElement().toString());
            }
            this.attributeProperties.put(attribName, new MappedAttribute(null, property));
        }
        props = PropertyQueries.createQuery(this.identityClass).getResultList();
        for (Property<Object> property : props) {
            if (property.isReadOnly() || !property.getJavaClass().isAnnotationPresent(Entity.class)) continue;
            List pp = PropertyQueries.createQuery(property.getJavaClass()).addCriteria(new AnnotatedPropertyCriteria(IDMAttribute.class)).getResultList();
            for (Property<Object> property2 : pp) {
                String attribName = property2.getAnnotatedElement().getAnnotation(IDMAttribute.class).name();
                if (this.attributeProperties.containsKey(attribName)) {
                    Property<Object> other = this.attributeProperties.get(attribName).getAttributeProperty();
                    throw new SecurityConfigurationException("Multiple properties defined for attribute [" + attribName + "] - " + "Property: " + other.getDeclaringClass().getName() + "." + other.getAnnotatedElement().toString() + ", Property: " + property2.getDeclaringClass().getName() + "." + property2.getAnnotatedElement().toString());
                }
                this.attributeProperties.put(attribName, new MappedAttribute(property, property2));
            }
        }
    }

    protected EntityManager getEntityManager(IdentityStoreInvocationContext invocationContext) {
        return ((JPAIdentityStoreSession)invocationContext.getIdentityStoreSession()).getEntityManager();
    }

    public Set<IdentityStore.Feature> getFeatureSet() {
        return this.featureSet;
    }

    public void createUser(IdentityStoreInvocationContext ctx, User user) {
        try {
            Object identity = this.identityClass.newInstance();
            this.modelProperties.get(PROPERTY_IDENTITY_ID).setValue(identity, user.getId());
            this.modelProperties.get(PROPERTY_IDENTITY_DISCRIMINATOR).setValue(identity, this.identityTypeUser);
            if (this.modelProperties.containsKey(PROPERTY_USER_FIRST_NAME)) {
                this.modelProperties.get(PROPERTY_USER_FIRST_NAME).setValue(identity, user.getFirstName());
            }
            if (this.modelProperties.containsKey(PROPERTY_USER_LAST_NAME)) {
                this.modelProperties.get(PROPERTY_USER_LAST_NAME).setValue(identity, user.getLastName());
            }
            if (this.modelProperties.containsKey(PROPERTY_USER_EMAIL)) {
                this.modelProperties.get(PROPERTY_USER_EMAIL).setValue(identity, user.getEmail());
            }
            EntityManager em = this.getEntityManager(ctx);
            for (String attribName : this.attributeProperties.keySet()) {
                MappedAttribute attrib = this.attributeProperties.get(attribName);
                if (attrib.getIdentityProperty() == null || attrib.getIdentityProperty().getValue(identity) != null) continue;
                Object instance = attrib.getIdentityProperty().getJavaClass().newInstance();
                attrib.getIdentityProperty().setValue(identity, instance);
                em.persist(instance);
            }
            em.persist(identity);
            if (user.getAttributes() != null && !user.getAttributes().isEmpty()) {
                for (String key : user.getAttributes().keySet()) {
                    this.setAttribute(ctx, (IdentityType)user, key, user.getAttributeValues(key));
                }
            }
            em.flush();
        }
        catch (Exception ex) {
            throw new IdentityManagementException("Exception while creating user", (Throwable)ex);
        }
    }

    public void removeUser(IdentityStoreInvocationContext ctx, User user) {
    }

    public boolean validateCredential(IdentityStoreInvocationContext ctx, User user, Credential credential) {
        return false;
    }

    public void updateCredential(IdentityStoreInvocationContext ctx, User user, Credential credential) {
    }

    public User getUser(IdentityStoreInvocationContext ctx, String id) {
        return null;
    }

    public Group createGroup(IdentityStoreInvocationContext ctx, String name, Group parent) {
        return null;
    }

    public void removeGroup(IdentityStoreInvocationContext ctx, Group group) {
    }

    public Group getGroup(IdentityStoreInvocationContext ctx, String name) {
        return null;
    }

    public Role createRole(IdentityStoreInvocationContext ctx, String name) {
        return null;
    }

    public void removeRole(IdentityStoreInvocationContext ctx, Role role) {
    }

    public Role getRole(IdentityStoreInvocationContext ctx, String name) {
        return null;
    }

    public List<User> executeQuery(IdentityStoreInvocationContext ctx, UserQuery query, Range range) {
        return null;
    }

    public List<Group> executeQuery(IdentityStoreInvocationContext ctx, GroupQuery query, Range range) {
        return null;
    }

    public List<Role> executeQuery(IdentityStoreInvocationContext ctx, RoleQuery query, Range range) {
        return null;
    }

    public List<Membership> executeQuery(IdentityStoreInvocationContext ctx, MembershipQuery query, Range range) {
        return null;
    }

    public void setAttribute(IdentityStoreInvocationContext ctx, IdentityType identity, String name, String[] values) {
    }

    public void removeAttribute(IdentityStoreInvocationContext ctx, IdentityType identity, String name) {
    }

    public String[] getAttributeValues(IdentityStoreInvocationContext ctx, IdentityType identity, String name) {
        return null;
    }

    public Map<String, String[]> getAttributes(IdentityStoreInvocationContext ctx, IdentityType identity) {
        return null;
    }

    public Membership createMembership(IdentityStoreInvocationContext ctx, IdentityType member, Group group, Role role) {
        return null;
    }

    public void removeMembership(IdentityStoreInvocationContext ctx, IdentityType member, Group group, Role role) {
    }

    public Membership getMembership(IdentityStoreInvocationContext ctx, IdentityType member, Group group, Role role) {
        return null;
    }

    private class MappedAttribute {
        private Property<Object> identityProperty;
        private Property<Object> attributeProperty;

        public MappedAttribute(Property<Object> identityProperty, Property<Object> attributeProperty) {
            this.identityProperty = identityProperty;
            this.attributeProperty = attributeProperty;
        }

        public Property<Object> getIdentityProperty() {
            return this.identityProperty;
        }

        public Property<Object> getAttributeProperty() {
            return this.attributeProperty;
        }
    }

    private class PropertyTypeCriteria
    implements PropertyCriteria {
        private PropertyType pt;

        public PropertyTypeCriteria(PropertyType pt) {
            this.pt = pt;
        }

        @Override
        public boolean fieldMatches(Field f) {
            return f.isAnnotationPresent(IDMProperty.class) && f.getAnnotation(IDMProperty.class).value().equals((Object)this.pt);
        }

        @Override
        public boolean methodMatches(Method m) {
            return m.isAnnotationPresent(IDMProperty.class) && m.getAnnotation(IDMProperty.class).value().equals((Object)this.pt);
        }
    }
}

