/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.picketlink.idm.ldap.internal.DirContextAdaptor;
import org.picketlink.idm.ldap.internal.LDAPObjectChangedNotification;
import org.picketlink.idm.ldap.internal.LDAPUserCustomAttributes;
import org.picketlink.idm.ldap.internal.ManagedAttributeLookup;
import org.picketlink.idm.model.User;

public class LDAPUser
extends DirContextAdaptor
implements User {
    private static final long serialVersionUID = 1L;
    protected String userid;
    protected String firstName;
    protected String lastName;
    protected String fullName;
    protected String email;
    protected String userDNSuffix;
    protected LDAPUserCustomAttributes customAttributes = new LDAPUserCustomAttributes();
    protected transient ManagedAttributeLookup lookup;

    public LDAPUser() {
        BasicAttribute oc = new BasicAttribute("objectclass");
        oc.add("inetOrgPerson");
        oc.add("organizationalPerson");
        oc.add("person");
        oc.add("top");
        oc.add("extensibleObject");
        this.attributes.put(oc);
    }

    public LDAPUser(String userId, ManagedAttributeLookup lookup) {
        this();
        this.setLookup(lookup);
        this.setId(userId);
        this.setFullName(userId);
    }

    public ManagedAttributeLookup getLookup() {
        return this.lookup;
    }

    public void setLookup(ManagedAttributeLookup lookup) {
        this.lookup = lookup;
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        BasicAttributes collectiveAttributes = new BasicAttributes(true);
        NamingEnumeration<? extends Attribute> ne = this.attributes.getAll();
        while (ne.hasMore()) {
            collectiveAttributes.put(ne.next());
        }
        Map<String, Object> custom = this.customAttributes.getAttributes();
        Set<String> keys = custom.keySet();
        for (String key : keys) {
            Object value = custom.get(key);
            collectiveAttributes.put(key, value);
        }
        return collectiveAttributes;
    }

    @Override
    public String getAttribute(String name) {
        if (!this.lookup.isManaged(name)) {
            return (String)this.customAttributes.getAttribute(name);
        }
        return super.getAttribute(name);
    }

    @Override
    public String[] getAttributeValues(String name) {
        if (!this.lookup.isManaged(name)) {
            Object value = this.customAttributes.getAttribute(name);
            if (value instanceof String[]) {
                return (String[])value;
            }
            return new String[]{(String)value};
        }
        return super.getAttributeValues(name);
    }

    @Override
    public Map<String, String[]> getAttributes() {
        Map<String, String[]> map = super.getAttributes();
        Map<String, Object> values = this.customAttributes.getAttributes();
        Set<String> keys = values.keySet();
        for (String key : keys) {
            Object value = values.get(key);
            if (value instanceof String[]) {
                map.put(key, (String[])value);
                continue;
            }
            if (!(value instanceof String)) continue;
            String[] arr = new String[]{(String)value};
            map.put(key, arr);
        }
        return map;
    }

    @Override
    public void setAttribute(String name, String value) {
        if (this.lookup.isManaged(name)) {
            super.setAttribute(name, value);
        } else {
            this.setCustomAttribute(name, value);
        }
    }

    @Override
    public void setAttribute(String name, String[] values) {
        if (this.lookup.isManaged(name)) {
            super.setAttribute(name, values);
        } else {
            this.setCustomAttribute(name, values);
        }
    }

    public void setCustomAttribute(String name, String value) {
        this.customAttributes.addAttribute(name, value);
        if (this.handler != null) {
            this.handler.handle(new LDAPObjectChangedNotification(this, LDAPObjectChangedNotification.NType.CUSTOM_ATTRIBUTE, null));
        }
    }

    public void setCustomAttribute(String name, String[] values) {
        this.customAttributes.addAttribute(name, values);
        if (this.handler != null) {
            this.handler.handle(new LDAPObjectChangedNotification(this, LDAPObjectChangedNotification.NType.CUSTOM_ATTRIBUTE, null));
        }
    }

    public LDAPUserCustomAttributes getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(LDAPUserCustomAttributes customAttributes) {
        this.customAttributes = customAttributes;
    }

    public void setUserDNSuffix(String udn) {
        this.userDNSuffix = udn;
    }

    public String getDN() {
        try {
            if (this.userid == null) {
                this.userid = (String)this.attributes.get("uid").get();
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return "uid=" + this.getId() + "," + this.userDNSuffix;
    }

    public void setId(String id) {
        this.userid = id;
        Attribute theAttribute = this.attributes.get("uid");
        if (theAttribute == null) {
            this.attributes.put("uid", id);
        } else {
            theAttribute.set(0, id);
        }
    }

    public String getId() {
        Attribute theAttribute = this.attributes.get("uid");
        if (theAttribute != null) {
            try {
                return (String)theAttribute.get();
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public String getKey() {
        return this.getId();
    }

    public String getFirstName() {
        try {
            Attribute theAttribute;
            if (this.firstName == null && (theAttribute = this.attributes.get("givenname")) != null) {
                this.firstName = (String)theAttribute.get();
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
        Attribute theAttribute = this.attributes.get("givenname");
        if (theAttribute == null) {
            this.attributes.put("givenname", firstName);
        } else {
            this.replaceAttribute("givenname", firstName);
        }
        Attribute cnAttribute = this.attributes.get("cn");
        if (cnAttribute != null) {
            this.replaceAttribute("cn", firstName);
        }
        this.attributes.put("cn", firstName);
    }

    public String getLastName() {
        try {
            Attribute theAttribute;
            if (this.lastName == null && (theAttribute = this.attributes.get("sn")) != null) {
                this.lastName = (String)theAttribute.get();
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
        Attribute theAttribute = this.attributes.get("sn");
        if (theAttribute == null) {
            this.attributes.put("sn", lastName);
        } else {
            theAttribute.set(0, lastName);
        }
        Attribute cnAttribute = this.attributes.get("cn");
        if (cnAttribute == null) {
            cnAttribute = new BasicAttribute("cn", lastName);
            this.attributes.put(cnAttribute);
        } else {
            try {
                this.replaceAttribute("sn", lastName);
                this.replaceAttribute("cn", cnAttribute.get().toString() + " " + lastName);
            }
            catch (NamingException e) {
                throw new RuntimeException("Could not set user's last name.", e);
            }
        }
    }

    public String getFullName() {
        try {
            Attribute theAttribute;
            if (this.fullName == null && (theAttribute = this.attributes.get("cn")) != null) {
                this.fullName = (String)theAttribute.get();
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
        Attribute theAttribute = this.attributes.get("cn");
        if (theAttribute == null) {
            this.attributes.put("cn", fullName);
        } else {
            theAttribute.set(0, fullName);
        }
        this.setFirstName(this.getFirstName(fullName));
        this.setLastName(this.getLastName(fullName));
    }

    public String getEmail() {
        try {
            Attribute theAttribute;
            if (this.email == null && (theAttribute = this.attributes.get("mail")) != null) {
                this.email = (String)theAttribute.get();
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
        Attribute theAttribute = this.attributes.get("mail");
        if (theAttribute == null) {
            this.setAttribute("mail", email);
        } else {
            this.replaceAttribute("mail", email);
        }
    }

    private String getFirstName(String name) {
        String[] tokens = name.split("\\ ");
        int length = tokens.length;
        String firstName = null;
        if (length > 0) {
            firstName = tokens[0];
        }
        return firstName;
    }

    private String getLastName(String name) {
        String lastName = null;
        String[] tokens = name.split("\\ ");
        if (tokens.length > 0) {
            lastName = tokens[tokens.length - 1];
        }
        return lastName;
    }
}

