/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.query.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.Range;
import org.picketlink.idm.query.UserQuery;
import org.picketlink.idm.query.internal.AbstractQuery;
import org.picketlink.idm.spi.IdentityStore;

public class DefaultUserQuery
extends AbstractQuery<UserQuery>
implements UserQuery {
    protected IdentityStore store = null;
    private String name;
    private Group relatedGroup;
    private String relatedGroupID;
    private Role role;
    private String roleName;
    private Map<String, String[]> filters = new HashMap<String, String[]>();
    private String firstName;
    private String lastName;
    private String email;
    private boolean enabled = true;
    private Range range;

    public DefaultUserQuery(IdentityStore store) {
        this.store = store;
    }

    @Override
    public UserQuery reset() {
        return null;
    }

    @Override
    public UserQuery getImmutable() {
        return null;
    }

    public List<User> executeQuery(UserQuery query) {
        return null;
    }

    @Override
    public UserQuery setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public UserQuery setRelatedGroup(Group group) {
        this.relatedGroup = group;
        return this;
    }

    public UserQuery setRelatedGroup(String groupId) {
        this.relatedGroupID = groupId;
        return this;
    }

    public Group getRelatedGroup() {
        if (this.relatedGroup != null) {
            return this.relatedGroup;
        }
        if (this.relatedGroupID == null) {
            return null;
        }
        return new SimpleGroup(null, this.relatedGroupID, null);
    }

    public UserQuery setRole(Role role) {
        this.role = role;
        return this;
    }

    public UserQuery setRole(String name) {
        this.roleName = name;
        return this;
    }

    public Role getRole() {
        if (this.role != null) {
            return this.role;
        }
        if (this.roleName == null) {
            return null;
        }
        return new SimpleRole(this.roleName);
    }

    @Override
    public UserQuery setAttributeFilter(String name, String[] values) {
        this.filters.put(name, values);
        return this;
    }

    @Override
    public Map<String, String[]> getAttributeFilters() {
        return Collections.unmodifiableMap(this.filters);
    }

    public UserQuery setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public UserQuery setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public String getLastName() {
        return this.lastName;
    }

    public UserQuery setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    @Override
    public UserQuery setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public UserQuery sort(boolean ascending) {
        return null;
    }

    @Override
    public void setRange(Range range) {
        this.range = range;
    }

    @Override
    public Range getRange() {
        return this.range;
    }

    public List<User> executeQuery() {
        return this.store.executeQuery(this.getInvocationContext(this.store), (UserQuery)this, null);
    }
}

