/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.picketlink.idm.file.internal;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;

/**
 * <p> {@link Serializable} class used to store {@link Relationship} metadata.</p>
 * 
 * @author <a href="mailto:psilva@redhat.com">Pedro Silva</a>
 * 
 */
public class FileRelationshipStorage implements Serializable {

    private static final long serialVersionUID = -349640861496483678L;

    private Map<String, IdentityType> identityTypes = new HashMap<String, IdentityType>();
    private Map<String, Serializable> attributes = new HashMap<String, Serializable>();

    private String id;

    private String type;

    public Map<String, IdentityType> getIdentityTypes() {
        return this.identityTypes;
    }
    
    public Map<String, Serializable> getAttributes() {
        return this.attributes;
    }

    public String getId() {
        return this.id;
    }
    
    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }
    
    public void setType(String type) {
        this.type = type;
    }

}
