/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.util;

import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.pitest.util.StringUtil;
import org.pitest.util.TimeSpan;

public class Timings {
    private final Map<Stage, TimeSpan> timings = new LinkedHashMap<Stage, TimeSpan>();

    public void registerStart(Stage stage) {
        this.timings.put(stage, new TimeSpan(System.currentTimeMillis(), 0L));
    }

    public void registerEnd(Stage stage) {
        long end = System.currentTimeMillis();
        this.timings.get((Object)stage).setEnd(end);
    }

    public void report(PrintStream ps) {
        long total = 0L;
        for (Map.Entry<Stage, TimeSpan> each : this.timings.entrySet()) {
            total += each.getValue().duration();
            ps.println("> " + (Object)((Object)each.getKey()) + " : " + each.getValue());
        }
        ps.println(StringUtil.separatorLine());
        ps.println("> Total  : " + new TimeSpan(0L, total));
        ps.println(StringUtil.separatorLine());
    }

    public static enum Stage {
        BUILD_MUTATION_TESTS("build mutation tests"),
        RUN_MUTATION_TESTS("run mutation analysis"),
        SCAN_CLASS_PATH("scan classpath"),
        COVERAGE("coverage and dependency analysis");

        private final String description;

        private Stage(String desc) {
            this.description = desc;
        }

        public String toString() {
            return this.description;
        }
    }
}

