/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.tooling;

import java.io.File;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.pitest.functional.FArray;
import org.pitest.functional.FCollection;
import org.pitest.mutationtest.SourceLocator;
import org.pitest.mutationtest.tooling.DirectorySourceLocator;

public class SmartSourceLocator
implements SourceLocator {
    private static final int MAX_DEPTH = 4;
    private final Collection<SourceLocator> children;

    public SmartSourceLocator(Collection<File> roots) {
        List childDirs = FCollection.flatMap(roots, this.collectChildren(0));
        childDirs.addAll(roots);
        this.children = FCollection.map((Iterable)childDirs, DirectorySourceLocator::new);
    }

    private Function<File, Collection<File>> collectChildren(int depth) {
        return a -> this.collectDirectories((File)a, depth);
    }

    private Collection<File> collectDirectories(File root, int depth) {
        Collection<File> childDirs = SmartSourceLocator.listFirstLevelDirectories(root);
        if (depth < 4) {
            childDirs.addAll(FCollection.flatMap(childDirs, this.collectChildren(depth + 1)));
        }
        return childDirs;
    }

    private static Collection<File> listFirstLevelDirectories(File root) {
        return FArray.filter((Object[])root.listFiles(), File::isDirectory);
    }

    @Override
    public Optional<Reader> locate(Collection<String> classes, String fileName) {
        for (SourceLocator each : this.children) {
            Optional<Reader> reader = each.locate(classes, fileName);
            if (!reader.isPresent()) continue;
            return reader;
        }
        return Optional.empty();
    }
}

