/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.equivalent;

import java.util.Arrays;
import java.util.HashSet;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.OpcodeMatchers;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.build.CompoundMutationInterceptor;
import org.pitest.mutationtest.build.InterceptorParameters;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.MutationInterceptorFactory;
import org.pitest.mutationtest.build.intercept.equivalent.EmptyReturnsFilter;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.mutators.returns.BooleanFalseReturnValsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.returns.BooleanTrueReturnValsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.returns.EmptyObjectReturnValsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.returns.NullReturnValsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.returns.PrimitiveReturnsMutator;
import org.pitest.plugin.Feature;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.Result;
import org.pitest.sequence.SequenceQuery;

public class EquivalentReturnMutationFilter
implements MutationInterceptorFactory {
    public String description() {
        return "Trivial return vals equivalence filter";
    }

    public Feature provides() {
        return Feature.named((String)"FRETEQUIV").withOnByDefault(true).withDescription("Filters return vals mutants with bytecode equivalent to the unmutated class");
    }

    @Override
    public MutationInterceptor createInterceptor(InterceptorParameters params) {
        return new CompoundMutationInterceptor(Arrays.asList(new EmptyReturnsFilter(this.primitiveZeroConstants(), this.primitiveReturns(), new MethodMutatorFactory[]{PrimitiveReturnsMutator.PRIMITIVE_RETURNS, BooleanFalseReturnValsMutator.FALSE_RETURNS}), new EmptyReturnsFilter(QueryStart.match(OpcodeMatchers.ACONST_NULL), OpcodeMatchers.ARETURN, new MethodMutatorFactory[]{NullReturnValsMutator.NULL_RETURNS}), new EmptyReturnsFilter(this.emptyReturns(), OpcodeMatchers.ARETURN, new MethodMutatorFactory[]{EmptyObjectReturnValsMutator.EMPTY_RETURNS, BooleanFalseReturnValsMutator.FALSE_RETURNS}), new EmptyReturnsFilter(QueryStart.match(OpcodeMatchers.ICONST_1), OpcodeMatchers.IRETURN, new MethodMutatorFactory[]{BooleanTrueReturnValsMutator.TRUE_RETURNS}), new EmptyReturnsFilter(this.hardCodedTrue(), OpcodeMatchers.ARETURN, new MethodMutatorFactory[]{BooleanTrueReturnValsMutator.TRUE_RETURNS}))){

            @Override
            public InterceptorType type() {
                return InterceptorType.FILTER;
            }
        };
    }

    private static Match<AbstractInsnNode> ldcConstant(String s) {
        return (c, n) -> Result.result(s.equals(((LdcInsnNode)n).cst), c);
    }

    private static Match<AbstractInsnNode> isZeroConstant() {
        HashSet<Integer> zeroConstants = new HashSet<Integer>();
        zeroConstants.add(3);
        zeroConstants.add(9);
        zeroConstants.add(11);
        zeroConstants.add(14);
        return (context, node) -> Result.result(zeroConstants.contains(node.getOpcode()), context);
    }

    private SequenceQuery<AbstractInsnNode> emptyReturns() {
        SequenceQuery<AbstractInsnNode> constantZero = QueryStart.match(EquivalentReturnMutationFilter.isZeroConstant()).then(InstructionMatchers.methodCallNamed("valueOf"));
        SequenceQuery<AbstractInsnNode> constantFalse = QueryStart.match(InstructionMatchers.getStatic("java/lang/Boolean", "FALSE"));
        SequenceQuery<AbstractInsnNode> emptyString = QueryStart.match(OpcodeMatchers.LDC.and(EquivalentReturnMutationFilter.ldcConstant("")));
        return constantZero.or(constantFalse).or(emptyString).or(QueryStart.match(EquivalentReturnMutationFilter.loadsEmptyReturnOntoStack()));
    }

    private static Match<AbstractInsnNode> loadsEmptyReturnOntoStack() {
        return EquivalentReturnMutationFilter.noArgsCall("java/util/Optional", "empty").or(EquivalentReturnMutationFilter.noArgsCall("java/util/stream/Stream", "empty")).or(EquivalentReturnMutationFilter.noArgsCall("java/util/Collections", "emptyList")).or(EquivalentReturnMutationFilter.noArgsCall("java/util/Collections", "emptyMap")).or(EquivalentReturnMutationFilter.noArgsCall("java/util/Collections", "emptySet")).or(EquivalentReturnMutationFilter.noArgsCall("java/util/List", "of")).or(EquivalentReturnMutationFilter.noArgsCall("java/util/Set", "of"));
    }

    private static Match<AbstractInsnNode> noArgsCall(String owner, String name) {
        return InstructionMatchers.methodCallTo(ClassName.fromString((String)owner), name).and(EquivalentReturnMutationFilter.takesNoArgs());
    }

    private static Match<AbstractInsnNode> takesNoArgs() {
        return (c, node) -> {
            if (node instanceof MethodInsnNode) {
                MethodInsnNode call = (MethodInsnNode)node;
                return Result.result(Type.getArgumentTypes(call.desc).length == 0, c);
            }
            return Result.result(false, c);
        };
    }

    private SequenceQuery<AbstractInsnNode> hardCodedTrue() {
        SequenceQuery<AbstractInsnNode> boxedTrue = QueryStart.match(OpcodeMatchers.ICONST_1).then(InstructionMatchers.methodCallNamed("valueOf"));
        SequenceQuery<AbstractInsnNode> constantTrue = QueryStart.match(InstructionMatchers.getStatic("java/lang/Boolean", "TRUE"));
        return boxedTrue.or(constantTrue);
    }

    private Match<AbstractInsnNode> primitiveReturns() {
        return OpcodeMatchers.IRETURN.or(OpcodeMatchers.FRETURN).or(OpcodeMatchers.DRETURN).or(OpcodeMatchers.LRETURN);
    }

    private SequenceQuery<AbstractInsnNode> primitiveZeroConstants() {
        HashSet<Integer> zeroConstants = new HashSet<Integer>();
        zeroConstants.add(3);
        zeroConstants.add(9);
        zeroConstants.add(11);
        zeroConstants.add(14);
        return QueryStart.match((c, n) -> Result.result(zeroConstants.contains(n.getOpcode()), c));
    }
}

