/*
 * Decompiled with CFR 0.152.
 */
package org.pitest;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.predicate.Predicate;
import org.pitest.internal.ClassPath;
import org.pitest.internal.IsolationUtils;
import org.pitest.internal.classloader.DefaultPITClassloader;
import org.pitest.mutationtest.DefaultMutationConfigFactory;
import org.pitest.mutationtest.HtmlReportFactory;
import org.pitest.mutationtest.ListenerFactory;
import org.pitest.mutationtest.MutationCoverageReport;
import org.pitest.mutationtest.Mutator;
import org.pitest.mutationtest.ReportOptions;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.instrument.KnownLocationJavaAgentJarFinder;
import org.pitest.util.Glob;
import org.pitest.util.JavaAgent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PitMojo
extends AbstractMojo {
    private List<String> targetClasses;
    private List<String> targetTests;
    private List<String> excludedMethods;
    private List<String> avoidCallsTo;
    private List<String> inScopeClasses;
    private File reportsDirectory;
    private int maxDependencyDistance;
    private int threads;
    private boolean mutateStaticInitializers;
    private boolean includeJarFiles;
    private List<String> mutators;
    private float timeoutFactor;
    private long timeoutConstant;
    private int maxMutationsPerClass;
    private MavenProject project;
    private Map<String, Artifact> pluginArtifactMap;
    protected ArtifactRepository localRepository;
    protected ArtifactFactory factory;

    public void execute() throws MojoExecutionException {
        HashSet<String> classPath = new HashSet<String>();
        try {
            classPath.addAll(this.project.getTestClasspathElements());
            classPath.addAll(this.project.getCompileClasspathElements());
            classPath.addAll(this.project.getRuntimeClasspathElements());
            classPath.addAll(this.project.getSystemClasspathElements());
        }
        catch (DependencyResolutionRequiredException e1) {
            this.getLog().info((Throwable)e1);
            e1.printStackTrace();
        }
        Artifact pitVersionInfo = this.pluginArtifactMap.get("org.pitest:pitest");
        this.addOwnDependenciesToClassPath(classPath);
        ReportOptions data = new ReportOptions();
        data.setClassPathElements(classPath);
        data.setDependencyAnalysisMaxDistance(this.maxDependencyDistance);
        data.setIncludeJarFiles(this.includeJarFiles);
        data.setTargetClasses(this.determineTargetClasses());
        data.setTargetTests(this.determineTargetTests());
        data.setClassesInScope(this.determineClassesInScope());
        data.setMutateStaticInitializers(this.mutateStaticInitializers);
        data.setExcludedMethods(this.globStringsToPredicates(this.excludedMethods));
        data.setNumberOfThreads(this.threads);
        data.setMaxMutationsPerClass(this.maxMutationsPerClass);
        data.setReportDir(this.reportsDirectory.getAbsolutePath());
        data.setMutators(this.determineMutators());
        data.setTimeoutConstant(this.timeoutConstant);
        data.setTimeoutFactor(this.timeoutFactor);
        if (this.avoidCallsTo != null) {
            data.setLoggingClasses(this.avoidCallsTo);
        }
        ArrayList<String> sourceRoots = new ArrayList<String>();
        sourceRoots.addAll(this.project.getCompileSourceRoots());
        sourceRoots.addAll(this.project.getTestCompileSourceRoots());
        data.setSourceDirs(this.stringsTofiles(sourceRoots));
        System.out.println("Running report with " + data);
        MutationCoverageReport report = this.pickReportType(data, pitVersionInfo);
        DefaultPITClassloader loader = new DefaultPITClassloader((ClassPath)data.getClassPath(true).getOrElse((Object)new ClassPath()), IsolationUtils.getContextClassLoader());
        ClassLoader original = IsolationUtils.getContextClassLoader();
        try {
            IsolationUtils.setContextClassLoader((ClassLoader)loader);
            Runnable run = (Runnable)IsolationUtils.cloneForLoader((Object)report, (ClassLoader)loader);
            run.run();
        }
        catch (Exception e) {
            throw new MojoExecutionException("fail", e);
        }
        finally {
            IsolationUtils.setContextClassLoader((ClassLoader)original);
        }
    }

    private Collection<Predicate<String>> globStringsToPredicates(List<String> excludedMethods) {
        return FCollection.map(excludedMethods, (F)Glob.toGlobPredicate());
    }

    private Collection<Predicate<String>> determineTargetTests() {
        return FCollection.map(this.targetTests, (F)Glob.toGlobPredicate());
    }

    private void addOwnDependenciesToClassPath(Set<String> classPath) {
        for (Artifact dependency : this.pluginArtifactMap.values()) {
            classPath.add(dependency.getFile().getAbsolutePath());
        }
    }

    private MutationCoverageReport pickReportType(ReportOptions data, Artifact pitVersionInfo) {
        return new MutationCoverageReport(data, (JavaAgent)new KnownLocationJavaAgentJarFinder(pitVersionInfo.getFile().getAbsolutePath()), (ListenerFactory)new HtmlReportFactory(), true);
    }

    private Collection<MethodMutatorFactory> determineMutators() {
        if (this.mutators != null) {
            return FCollection.map(this.mutators, this.stringToMutator());
        }
        return DefaultMutationConfigFactory.DEFAULT_MUTATORS;
    }

    private F<String, MethodMutatorFactory> stringToMutator() {
        return new F<String, MethodMutatorFactory>(){

            public Mutator apply(String a) {
                return Mutator.valueOf((String)a);
            }
        };
    }

    private Collection<Predicate<String>> determineClassesInScope() {
        return this.returnOrDefaultToClassesLikeGroupName(this.inScopeClasses);
    }

    private Collection<Predicate<String>> determineTargetClasses() {
        return this.returnOrDefaultToClassesLikeGroupName(this.targetClasses);
    }

    private Collection<Predicate<String>> returnOrDefaultToClassesLikeGroupName(Collection<String> filters) {
        if (filters == null) {
            return Collections.singleton(new Glob(this.project.getGroupId() + "*"));
        }
        return FCollection.map(filters, (F)Glob.toGlobPredicate());
    }

    private Collection<File> stringsTofiles(List<String> sourceRoots) {
        return FCollection.map(sourceRoots, this.stringToFile());
    }

    private F<String, File> stringToFile() {
        return new F<String, File>(){

            public File apply(String a) {
                return new File(a);
            }
        };
    }
}

