/*
 * Decompiled with CFR 0.152.
 */
package org.pitest;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.pitest.DependencyFilter;
import org.pitest.PitMojo;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.predicate.Predicate;
import org.pitest.internal.ClassByteArraySource;
import org.pitest.internal.ClassPathByteArraySource;
import org.pitest.mutationtest.Mutator;
import org.pitest.mutationtest.MutatorGrouping;
import org.pitest.mutationtest.ReportOptions;
import org.pitest.mutationtest.config.ConfigurationFactory;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.report.OutputFormat;
import org.pitest.testng.TestGroupConfig;
import org.pitest.util.Functions;
import org.pitest.util.Glob;
import org.pitest.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MojoToReportOptionsConverter {
    private final PitMojo mojo;

    public MojoToReportOptionsConverter(PitMojo mojo) {
        this.mojo = mojo;
    }

    public ReportOptions convert() {
        HashSet<String> classPath = new HashSet<String>();
        try {
            classPath.addAll(this.mojo.getProject().getTestClasspathElements());
            classPath.addAll(this.mojo.getProject().getCompileClasspathElements());
            classPath.addAll(this.mojo.getProject().getRuntimeClasspathElements());
            classPath.addAll(this.mojo.getProject().getSystemClasspathElements());
        }
        catch (DependencyResolutionRequiredException e1) {
            this.mojo.getLog().info((Throwable)e1);
            e1.printStackTrace();
        }
        this.addOwnDependenciesToClassPath(classPath);
        return this.parseReportOptions(classPath);
    }

    private ReportOptions parseReportOptions(Set<String> classPath) {
        ReportOptions data = new ReportOptions();
        if (this.mojo.getProject().getBuild() != null) {
            Log.getLogger().info("Mutating from " + this.mojo.getProject().getBuild().getOutputDirectory());
            data.setCodePaths(Collections.singleton(this.mojo.getProject().getBuild().getOutputDirectory()));
        }
        data.setClassPathElements(classPath);
        data.setDependencyAnalysisMaxDistance(this.mojo.getMaxDependencyDistance());
        data.setFailWhenNoMutations(this.mojo.isFailWhenNoMutations());
        data.setTargetClasses(this.determineTargetClasses());
        data.setTargetTests(this.determineTargetTests());
        data.setClassesInScope(this.determineClassesInScope());
        data.setMutateStaticInitializers(this.mojo.isMutateStaticInitializers());
        data.setExcludedMethods(this.globStringsToPredicates(this.mojo.getExcludedMethods()));
        data.setExcludedClasses(this.globStringsToPredicates(this.mojo.getExcludedClasses()));
        data.setNumberOfThreads(this.mojo.getThreads());
        data.setMaxMutationsPerClass(this.mojo.getMaxMutationsPerClass());
        data.setReportDir(this.mojo.getReportsDirectory().getAbsolutePath());
        data.setVerbose(this.mojo.isVerbose());
        if (this.mojo.getJvmArgs() != null) {
            data.addChildJVMArgs(this.mojo.getJvmArgs());
        }
        data.setMutators(this.determineMutators());
        data.setTimeoutConstant(this.mojo.getTimeoutConstant());
        data.setTimeoutFactor(this.mojo.getTimeoutFactor());
        if (this.mojo.getAvoidCallsTo() != null) {
            data.setLoggingClasses(this.mojo.getAvoidCallsTo());
        }
        ArrayList<String> sourceRoots = new ArrayList<String>();
        sourceRoots.addAll(this.mojo.getProject().getCompileSourceRoots());
        sourceRoots.addAll(this.mojo.getProject().getTestCompileSourceRoots());
        data.setSourceDirs(this.stringsTofiles(sourceRoots));
        data.addOutputFormats(this.determineOutputFormats());
        this.setTestType(data);
        return data;
    }

    private void setTestType(ReportOptions data) {
        TestGroupConfig conf = new TestGroupConfig(this.mojo.getExcludedTestNGGroups(), this.mojo.getIncludedTestNGGroups());
        ConfigurationFactory configFactory = new ConfigurationFactory(conf, (ClassByteArraySource)new ClassPathByteArraySource(data.getClassPath()));
        data.setGroupConfig(conf);
        data.setConfiguration(configFactory.createConfiguration());
    }

    private void addOwnDependenciesToClassPath(Set<String> classPath) {
        for (Artifact dependency : this.filteredDependencies()) {
            classPath.add(dependency.getFile().getAbsolutePath());
        }
    }

    private Collection<Predicate<String>> globStringsToPredicates(List<String> excludedMethods) {
        return FCollection.map(excludedMethods, (F)Glob.toGlobPredicate());
    }

    private Collection<Predicate<String>> determineTargetTests() {
        return FCollection.map(this.mojo.getTargetTests(), (F)Glob.toGlobPredicate());
    }

    private Collection<Artifact> filteredDependencies() {
        DependencyFilter filter = new DependencyFilter("org.pitest");
        return FCollection.filter(this.mojo.getPluginArtifactMap().values(), (F)filter);
    }

    private Collection<MethodMutatorFactory> determineMutators() {
        if (this.mojo.getMutators() != null) {
            return FCollection.flatMap(this.mojo.getMutators(), this.stringToMutators());
        }
        return Mutator.DEFAULTS.asCollection();
    }

    private F<String, MutatorGrouping> stringToMutators() {
        return new F<String, MutatorGrouping>(){

            public Mutator apply(String a) {
                return Mutator.valueOf((String)a);
            }
        };
    }

    private Collection<Predicate<String>> determineClassesInScope() {
        return this.returnOrDefaultToClassesLikeGroupName(this.mojo.getInScopeClasses());
    }

    private Collection<Predicate<String>> determineTargetClasses() {
        return this.returnOrDefaultToClassesLikeGroupName(this.mojo.getTargetClasses());
    }

    private Collection<Predicate<String>> returnOrDefaultToClassesLikeGroupName(Collection<String> filters) {
        if (filters == null) {
            return Collections.singleton(new Glob(this.mojo.getProject().getGroupId() + "*"));
        }
        return FCollection.map(filters, (F)Glob.toGlobPredicate());
    }

    private Collection<File> stringsTofiles(List<String> sourceRoots) {
        return FCollection.map(sourceRoots, this.stringToFile());
    }

    private F<String, File> stringToFile() {
        return new F<String, File>(){

            public File apply(String a) {
                return new File(a);
            }
        };
    }

    private Collection<OutputFormat> determineOutputFormats() {
        if (this.mojo.getOutputFormats() != null) {
            return FCollection.map(this.mojo.getOutputFormats(), (F)Functions.stringToEnum(OutputFormat.class));
        }
        return Arrays.asList(OutputFormat.HTML);
    }
}

