/*
 * Decompiled with CFR 0.152.
 */
package org.pitest;

import org.apache.maven.plugin.MojoExecutionException;
import org.pitest.GoalStrategy;
import org.pitest.coverage.execute.CoverageOptions;
import org.pitest.coverage.execute.LaunchOptions;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.internal.ClassPath;
import org.pitest.internal.IsolationUtils;
import org.pitest.internal.classloader.DefaultPITClassloader;
import org.pitest.mutationtest.CompoundListenerFactory;
import org.pitest.mutationtest.CoverageDatabase;
import org.pitest.mutationtest.DefaultCoverageDatabase;
import org.pitest.mutationtest.ListenerFactory;
import org.pitest.mutationtest.MutationClassPaths;
import org.pitest.mutationtest.MutationCoverageReport;
import org.pitest.mutationtest.ReportOptions;
import org.pitest.mutationtest.Timings;
import org.pitest.mutationtest.instrument.JarCreatingJarFinder;
import org.pitest.mutationtest.instrument.KnownLocationJavaAgentFinder;
import org.pitest.mutationtest.report.DatedDirectoryResultOutputStrategy;
import org.pitest.mutationtest.report.OutputFormat;
import org.pitest.mutationtest.report.ResultOutputStrategy;
import org.pitest.mutationtest.verify.BuildVerifier;
import org.pitest.mutationtest.verify.DefaultBuildVerifier;
import org.pitest.util.JavaAgent;

public class RunPitStrategy
implements GoalStrategy {
    public void execute(ReportOptions data) throws MojoExecutionException {
        System.out.println("Running report with " + data);
        ClassPath cp = data.getClassPath();
        JarCreatingJarFinder jac = new JarCreatingJarFinder(cp);
        KnownLocationJavaAgentFinder ja = new KnownLocationJavaAgentFinder((String)jac.getJarLocation().value());
        DatedDirectoryResultOutputStrategy reportOutput = new DatedDirectoryResultOutputStrategy(data.getReportDir());
        CompoundListenerFactory reportFactory = new CompoundListenerFactory((Iterable)FCollection.map((Iterable)data.getOutputFormats(), (F)OutputFormat.createFactoryForFormat((ResultOutputStrategy)reportOutput)));
        CoverageOptions coverageOptions = data.createCoverageOptions();
        LaunchOptions launchOptions = new LaunchOptions((JavaAgent)ja, data.getJvmArgs());
        MutationClassPaths cps = data.getMutationClassPaths();
        Timings timings = new Timings();
        DefaultCoverageDatabase coverageDatabase = new DefaultCoverageDatabase(coverageOptions, launchOptions, cps, timings);
        MutationCoverageReport report = new MutationCoverageReport((CoverageDatabase)coverageDatabase, data, (ListenerFactory)reportFactory, timings, (BuildVerifier)new DefaultBuildVerifier());
        DefaultPITClassloader loader = new DefaultPITClassloader(cp, IsolationUtils.bootClassLoader());
        ClassLoader original = IsolationUtils.getContextClassLoader();
        try {
            IsolationUtils.setContextClassLoader((ClassLoader)loader);
            Runnable run = (Runnable)IsolationUtils.cloneForLoader((Object)report, (ClassLoader)loader);
            run.run();
        }
        catch (Exception e) {
            throw new MojoExecutionException("fail", e);
        }
        finally {
            IsolationUtils.setContextClassLoader((ClassLoader)original);
            jac.close();
            ja.close();
        }
    }
}

