/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.maven;

import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.predicate.Predicate;
import org.pitest.mutationtest.config.PluginServices;
import org.pitest.plugin.ClientClasspathPlugin;
import org.pitest.util.PitError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyFilter
implements Predicate<Artifact> {
    private final Set<GroupIdPair> groups = new HashSet<GroupIdPair>();

    public DependencyFilter(PluginServices plugins) {
        Iterable runtimePlugins = plugins.findClientClasspathPlugins();
        FCollection.mapTo((Iterable)runtimePlugins, DependencyFilter.artifactToPair(), this.groups);
    }

    private static F<ClientClasspathPlugin, GroupIdPair> artifactToPair() {
        return new F<ClientClasspathPlugin, GroupIdPair>(){

            public GroupIdPair apply(ClientClasspathPlugin a) {
                Package p = a.getClass().getPackage();
                GroupIdPair g = new GroupIdPair(p.getImplementationVendor(), p.getImplementationTitle());
                if (g.id == null) {
                    this.reportBadPlugin("title", a);
                }
                if (g.group == null) {
                    this.reportBadPlugin("vendor", a);
                }
                return g;
            }

            private void reportBadPlugin(String missingProperty, ClientClasspathPlugin a) {
                Class<?> clss = a.getClass();
                throw new PitError("No implementation " + missingProperty + " in manifest of plugin jar for " + clss + " in " + clss.getProtectionDomain().getCodeSource().getLocation());
            }
        };
    }

    public Boolean apply(Artifact a) {
        GroupIdPair p = new GroupIdPair(a.getGroupId(), a.getArtifactId());
        return this.groups.contains(p);
    }

    private static class GroupIdPair {
        private final String group;
        private final String id;

        GroupIdPair(String group, String id) {
            this.group = group;
            this.id = id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GroupIdPair other = (GroupIdPair)obj;
            if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
                return false;
            }
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }
    }
}

