/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.maven;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.pitest:pitest-maven:1.1.4", 0);
        this.append(sb, "", 0);
        this.append(sb, "pitest-maven", 0);
        this.append(sb, "Pitest Maven Mojo.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "pitest:help", 0);
            this.append(sb, "Display help information on pitest-maven.\nCall\n\u00a0\u00a0mvn\u00a0pitest:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "mutationCoverage".equals(this.goal)) {
            this.append(sb, "pitest:mutationCoverage", 0);
            this.append(sb, "Goal which runs a coverage mutation report", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "additionalClasspathElements", 2);
                this.append(sb, "List of additional classpath entries to use when looking for tests and mutable code. These will be used in addition to the classpath with which PIT is launched.", 3);
                this.append(sb, "", 0);
                this.append(sb, "avoidCallsTo", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "classpathDependencyExcludes", 2);
                this.append(sb, "List of classpath entries, formatted as 'groupId:artifactId', which should not be included in the classpath when running mutation tests. Modelled after the corresponding Surefire/Failsafe property.", 3);
                this.append(sb, "", 0);
                this.append(sb, "coverageThreshold (Default: 0)", 2);
                this.append(sb, "Line coverage threshold at which to fail build", 3);
                this.append(sb, "", 0);
                this.append(sb, "detectInlinedCode (Default: true)", 2);
                this.append(sb, "Detect inlined code", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedClasses", 2);
                this.append(sb, "Classes not to mutate or run tests from", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedGroups", 2);
                this.append(sb, "TestNG Groups/JUnit Categories to exclude", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedMethods", 2);
                this.append(sb, "Methods not to mutate", 3);
                this.append(sb, "", 0);
                this.append(sb, "exportLineCoverage (Default: false)", 2);
                this.append(sb, "Export line coverage data", 3);
                this.append(sb, "", 0);
                this.append(sb, "failWhenNoMutations (Default: true)", 2);
                this.append(sb, "Throw error if no mutations found", 3);
                this.append(sb, "", 0);
                this.append(sb, "historyInputFile", 2);
                this.append(sb, "File to read history from for incremental analysis (can be same as output file)", 3);
                this.append(sb, "", 0);
                this.append(sb, "historyOutputFile", 2);
                this.append(sb, "File to write history information to for incremental analysis", 3);
                this.append(sb, "", 0);
                this.append(sb, "includedGroups", 2);
                this.append(sb, "TestNG Groups/JUnit Categories to include", 3);
                this.append(sb, "", 0);
                this.append(sb, "jvm", 2);
                this.append(sb, "Path to java executable to use when running tests. Will default to executable in JAVA_HOME if none set.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jvmArgs", 2);
                this.append(sb, "Arguments to pass to child processes", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxDependencyDistance (Default: -1)", 2);
                this.append(sb, "Maximum distance to look from test to class. Relevant when mutating static initializers", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxMutationsPerClass (Default: -1)", 2);
                this.append(sb, "Maximum number of mutations to allow per class", 3);
                this.append(sb, "", 0);
                this.append(sb, "mutateStaticInitializers (Default: false)", 2);
                this.append(sb, "Mutate static initializers", 3);
                this.append(sb, "", 0);
                this.append(sb, "mutationEngine (Default: gregor)", 2);
                this.append(sb, "Engine to use when generating mutations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mutationThreshold (Default: 0)", 2);
                this.append(sb, "Mutation score threshold at which to fail build", 3);
                this.append(sb, "", 0);
                this.append(sb, "mutationUnitSize", 2);
                this.append(sb, "Maximum number of mutations to include in a single analysis unit.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mutators", 2);
                this.append(sb, "Mutation operators to apply", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputFormats", 2);
                this.append(sb, "Formats to output during analysis phase", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportsDirectory (Default: ${project.build.directory}/pit-reports)", 2);
                this.append(sb, "Base directory where all reports are written to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "When set indicates that analysis of this project should be skipped", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipTests (Default: false)", 2);
                this.append(sb, "honors common skipTests flag in a maven run", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetClasses", 2);
                this.append(sb, "Classes to include in mutation test", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetTests", 2);
                this.append(sb, "Tests to run", 3);
                this.append(sb, "", 0);
                this.append(sb, "threads (Default: 1)", 2);
                this.append(sb, "Number of threads to use", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeoutConstant (Default: 3000)", 2);
                this.append(sb, "Constant factor to allow for timeouts", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeoutFactor (Default: 1.25)", 2);
                this.append(sb, "Weighting to allow for timeouts", 3);
                this.append(sb, "", 0);
                this.append(sb, "timestampedReports (Default: true)", 2);
                this.append(sb, "Create timestamped subdirectory for report", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Output verbose logging", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "scmMutationCoverage".equals(this.goal)) {
            this.append(sb, "pitest:scmMutationCoverage", 0);
            this.append(sb, "Goal which runs a coverage mutation report only for files that have been modified or introduced locally based on the source control configured in maven.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "additionalClasspathElements", 2);
                this.append(sb, "List of additional classpath entries to use when looking for tests and mutable code. These will be used in addition to the classpath with which PIT is launched.", 3);
                this.append(sb, "", 0);
                this.append(sb, "avoidCallsTo", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "Project basedir", 3);
                this.append(sb, "", 0);
                this.append(sb, "classpathDependencyExcludes", 2);
                this.append(sb, "List of classpath entries, formatted as 'groupId:artifactId', which should not be included in the classpath when running mutation tests. Modelled after the corresponding Surefire/Failsafe property.", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionType (Default: connection)", 2);
                this.append(sb, "Connection type to use when querying scm for changed files. Can either be 'connection' or 'developerConnection'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "coverageThreshold (Default: 0)", 2);
                this.append(sb, "Line coverage threshold at which to fail build", 3);
                this.append(sb, "", 0);
                this.append(sb, "detectInlinedCode (Default: true)", 2);
                this.append(sb, "Detect inlined code", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedClasses", 2);
                this.append(sb, "Classes not to mutate or run tests from", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedGroups", 2);
                this.append(sb, "TestNG Groups/JUnit Categories to exclude", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedMethods", 2);
                this.append(sb, "Methods not to mutate", 3);
                this.append(sb, "", 0);
                this.append(sb, "exportLineCoverage (Default: false)", 2);
                this.append(sb, "Export line coverage data", 3);
                this.append(sb, "", 0);
                this.append(sb, "failWhenNoMutations (Default: true)", 2);
                this.append(sb, "Throw error if no mutations found", 3);
                this.append(sb, "", 0);
                this.append(sb, "historyInputFile", 2);
                this.append(sb, "File to read history from for incremental analysis (can be same as output file)", 3);
                this.append(sb, "", 0);
                this.append(sb, "historyOutputFile", 2);
                this.append(sb, "File to write history information to for incremental analysis", 3);
                this.append(sb, "", 0);
                this.append(sb, "include", 2);
                this.append(sb, "List of scm status to include. Names match those defined by the maven scm plugin. Common values include ADDED,MODIFIED (the defaults) & UNKNOWN.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includedGroups", 2);
                this.append(sb, "TestNG Groups/JUnit Categories to include", 3);
                this.append(sb, "", 0);
                this.append(sb, "jvm", 2);
                this.append(sb, "Path to java executable to use when running tests. Will default to executable in JAVA_HOME if none set.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jvmArgs", 2);
                this.append(sb, "Arguments to pass to child processes", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxDependencyDistance (Default: -1)", 2);
                this.append(sb, "Maximum distance to look from test to class. Relevant when mutating static initializers", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxMutationsPerClass (Default: -1)", 2);
                this.append(sb, "Maximum number of mutations to allow per class", 3);
                this.append(sb, "", 0);
                this.append(sb, "mutateStaticInitializers (Default: false)", 2);
                this.append(sb, "Mutate static initializers", 3);
                this.append(sb, "", 0);
                this.append(sb, "mutationEngine (Default: gregor)", 2);
                this.append(sb, "Engine to use when generating mutations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mutationThreshold (Default: 0)", 2);
                this.append(sb, "Mutation score threshold at which to fail build", 3);
                this.append(sb, "", 0);
                this.append(sb, "mutationUnitSize", 2);
                this.append(sb, "Maximum number of mutations to include in a single analysis unit.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mutators", 2);
                this.append(sb, "Mutation operators to apply", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputFormats", 2);
                this.append(sb, "Formats to output during analysis phase", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportsDirectory (Default: ${project.build.directory}/pit-reports)", 2);
                this.append(sb, "Base directory where all reports are written to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmRootDir", 2);
                this.append(sb, "Base of scm root. For a multi module project this is probably the parent project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "When set indicates that analysis of this project should be skipped", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipTests (Default: false)", 2);
                this.append(sb, "honors common skipTests flag in a maven run", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetClasses", 2);
                this.append(sb, "Classes to include in mutation test", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetTests", 2);
                this.append(sb, "Tests to run", 3);
                this.append(sb, "", 0);
                this.append(sb, "threads (Default: 1)", 2);
                this.append(sb, "Number of threads to use", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeoutConstant (Default: 3000)", 2);
                this.append(sb, "Constant factor to allow for timeouts", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeoutFactor (Default: 1.25)", 2);
                this.append(sb, "Weighting to allow for timeouts", 3);
                this.append(sb, "", 0);
                this.append(sb, "timestampedReports (Default: true)", 2);
                this.append(sb, "Create timestamped subdirectory for report", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Output verbose logging", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

