/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.maven;

import java.io.File;
import java.util.Collections;
import org.pitest.functional.F;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PathToJavaClassConverter
implements F<String, Iterable<String>> {
    private final String sourceRoot;

    PathToJavaClassConverter(String sourceRoot) {
        this.sourceRoot = sourceRoot;
    }

    public Iterable<String> apply(String a) {
        File f = new File(a);
        String modifiedFilePath = f.getAbsolutePath();
        String fileName = f.getName();
        if (modifiedFilePath.startsWith(this.sourceRoot) && fileName.indexOf(46) != -1) {
            return this.createClassGlobFromFilePath(this.sourceRoot, modifiedFilePath);
        }
        return Collections.emptyList();
    }

    private Iterable<String> createClassGlobFromFilePath(String sourceRoot, String modifiedFilePath) {
        String rootedPath = modifiedFilePath.substring(sourceRoot.length() + 1, modifiedFilePath.length());
        return Collections.singleton(this.stripFileExtension(rootedPath).replace('/', '.').replace('\\', '.') + "*");
    }

    private String stripFileExtension(String rootedPath) {
        return rootedPath.substring(0, rootedPath.lastIndexOf("."));
    }
}

