/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.util.StringUtils;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.Option;
import org.pitest.functional.predicate.Predicate;
import org.pitest.maven.MojoToReportOptionsConverter;
import org.pitest.maven.PathToJavaClassConverter;
import org.pitest.maven.PitMojo;
import org.pitest.maven.RunPitStrategy;
import org.pitest.maven.ScmStatus;
import org.pitest.maven.SurefireConfigConverter;
import org.pitest.mutationtest.config.PluginServices;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.mutationtest.tooling.CombinedStatistics;

public class ScmMojo
extends PitMojo {
    private ScmManager manager;
    private HashSet<String> include;
    private String connectionType;
    private File basedir;
    private File scmRootDir;

    public ScmMojo(RunPitStrategy executionStrategy, ScmManager manager, Predicate<Artifact> filter, PluginServices plugins) {
        super(executionStrategy, filter, plugins);
        this.manager = manager;
    }

    public ScmMojo() {
    }

    @Override
    protected Option<CombinedStatistics> analyse() throws MojoExecutionException {
        this.targetClasses = ScmMojo.makeConcreteList(this.findModifiedClassNames());
        if (this.targetClasses.isEmpty()) {
            this.getLog().info((CharSequence)"No locally modified files found - nothing to mutation test");
            return Option.none();
        }
        this.logClassNames();
        this.defaultTargetTestsToGroupNameIfNoValueSet();
        ReportOptions data = new MojoToReportOptionsConverter(this, new SurefireConfigConverter(), (Predicate<Artifact>)this.filter).convert();
        data.setFailWhenNoMutations(false);
        return Option.some((Object)this.goalStrategy.execute(this.detectBaseDir(), data, this.plugins, new HashMap<String, String>()));
    }

    private void defaultTargetTestsToGroupNameIfNoValueSet() {
        if (this.getTargetTests() == null) {
            this.targetTests = ScmMojo.makeConcreteList(Collections.singletonList(this.getProject().getGroupId() + "*"));
        }
    }

    private void logClassNames() {
        for (String each : this.targetClasses) {
            this.getLog().info((CharSequence)("Will mutate locally changed class " + each));
        }
    }

    private List<String> findModifiedClassNames() throws MojoExecutionException {
        File sourceRoot = new File(this.project.getBuild().getSourceDirectory());
        List<String> modifiedPaths = this.findModifiedPaths();
        return FCollection.flatMap(modifiedPaths, (F)new PathToJavaClassConverter(sourceRoot.getAbsolutePath()));
    }

    private List<String> findModifiedPaths() throws MojoExecutionException {
        try {
            Set<ScmFileStatus> statusToInclude = this.makeStatusSet();
            ArrayList<String> modifiedPaths = new ArrayList<String>();
            ScmRepository repository = this.manager.makeScmRepository(this.getSCMConnection());
            File scmRoot = this.scmRoot();
            this.getLog().info((CharSequence)("Scm root dir is " + scmRoot));
            StatusScmResult status = this.manager.status(repository, new ScmFileSet(scmRoot));
            for (ScmFile file : status.getChangedFiles()) {
                if (!statusToInclude.contains(file.getStatus())) continue;
                modifiedPaths.add(file.getPath());
            }
            return modifiedPaths;
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Error while querying scm", (Exception)((Object)e));
        }
    }

    private Set<ScmFileStatus> makeStatusSet() {
        if (this.include == null || this.include.isEmpty()) {
            return new HashSet<ScmFileStatus>(Arrays.asList(ScmStatus.ADDED.getStatus(), ScmStatus.MODIFIED.getStatus()));
        }
        HashSet<ScmFileStatus> s = new HashSet<ScmFileStatus>();
        FCollection.mapTo(this.include, ScmMojo.stringToMavenScmStatus(), s);
        return s;
    }

    private static F<String, ScmFileStatus> stringToMavenScmStatus() {
        return new F<String, ScmFileStatus>(){

            public ScmFileStatus apply(String a) {
                return ScmStatus.valueOf(a.toUpperCase()).getStatus();
            }
        };
    }

    private File scmRoot() {
        if (this.scmRootDir != null) {
            return this.scmRootDir;
        }
        return this.basedir;
    }

    private String getSCMConnection() throws MojoExecutionException {
        if (this.project.getScm() == null) {
            throw new MojoExecutionException("No SCM Connection configured.");
        }
        String scmConnection = this.project.getScm().getConnection();
        if ("connection".equalsIgnoreCase(this.connectionType) && StringUtils.isNotEmpty((String)scmConnection)) {
            return scmConnection;
        }
        String scmDeveloper = this.project.getScm().getDeveloperConnection();
        if ("developerconnection".equalsIgnoreCase(this.connectionType) && StringUtils.isNotEmpty((String)scmDeveloper)) {
            return scmDeveloper;
        }
        throw new MojoExecutionException("SCM Connection is not set.");
    }

    public void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }

    public void setScmRootDir(File scmRootDir) {
        this.scmRootDir = scmRootDir;
    }

    private static ArrayList<String> makeConcreteList(List<String> list) {
        return new ArrayList<String>(list);
    }
}

